"""Mapping templates for GBD risk factors.

This code is automatically generated by gbd_mapping_generator/risk_builder.py

Any manual changes will be lost.
"""
from __future__ import annotations

from .base_template import Categories, GbdRecord, ModelableEntity, Restrictions, Tmred
from .cause_template import Cause
from .id import rei_id, scalar


class RiskFactor(ModelableEntity):
    """Container for risk GBD ids and metadata."""
    __slots__ = ('name', 'kind', 'gbd_id', 'level', 'most_detailed', 'distribution',
                 'population_attributable_fraction_calculation_type', 'restrictions', 'affected_causes',
                 'population_attributable_fraction_of_one_causes', 'parent', 'sub_risk_factors',
                 'affected_risk_factors', 'categories', 'tmred', 'relative_risk_scalar', )

    def __init__(self,
                 name: str,
                 kind: str,
                 gbd_id: rei_id,
                 level: int,
                 most_detailed: bool,
                 distribution: str | None,
                 population_attributable_fraction_calculation_type: str,
                 restrictions: Restrictions,
                 affected_causes: tuple[Cause, ...],
                 population_attributable_fraction_of_one_causes: tuple[Cause, ...],
                 parent: RiskFactor | None = None,
                 sub_risk_factors: tuple[RiskFactor, ...] = None,
                 affected_risk_factors: tuple[RiskFactor, ...] = None,
                 categories: Categories = None,
                 tmred: Tmred = None,
                 relative_risk_scalar: scalar = None, ):
        super().__init__(name=name,
                         kind=kind,
                         gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id
        self.level = level
        self.most_detailed = most_detailed
        self.distribution = distribution
        self.population_attributable_fraction_calculation_type = population_attributable_fraction_calculation_type
        self.restrictions = restrictions
        self.affected_causes = affected_causes
        self.population_attributable_fraction_of_one_causes = population_attributable_fraction_of_one_causes
        self.parent = parent
        self.sub_risk_factors = sub_risk_factors
        self.affected_risk_factors = affected_risk_factors
        self.categories = categories
        self.tmred = tmred
        self.relative_risk_scalar = relative_risk_scalar


class RiskFactors(GbdRecord):
    """Container for GBD risks."""
    __slots__ = ('unsafe_water_sanitation_and_handwashing', 'unsafe_water_source', 'unsafe_sanitation',
                 'air_pollution', 'ambient_particulate_matter_pollution', 'household_air_pollution_from_solid_fuels',
                 'ambient_ozone_pollution', 'other_environmental_risks', 'residential_radon', 'lead_exposure',
                 'child_and_maternal_malnutrition', 'suboptimal_breastfeeding', 'child_underweight',
                 'iron_deficiency', 'vitamin_a_deficiency', 'zinc_deficiency', 'tobacco', 'smoking',
                 'secondhand_smoke', 'high_alcohol_use', 'drug_use', 'metabolic_risks',
                 'high_fasting_plasma_glucose', 'high_systolic_blood_pressure', 'high_body_mass_index',
                 'low_bone_mineral_density', 'dietary_risks', 'diet_low_in_fruits', 'diet_low_in_vegetables',
                 'diet_low_in_whole_grains', 'diet_low_in_nuts_and_seeds', 'diet_low_in_milk',
                 'diet_high_in_red_meat', 'diet_high_in_processed_meat', 'diet_high_in_sugar_sweetened_beverages',
                 'diet_low_in_fiber', 'diet_low_in_seafood_omega_3_fatty_acids',
                 'diet_low_in_omega_6_polyunsaturated_fatty_acids', 'diet_high_in_trans_fatty_acids',
                 'diet_high_in_sodium', 'low_physical_activity', 'occupational_risks', 'occupational_carcinogens',
                 'occupational_asthmagens', 'occupational_particulate_matter_gases_and_fumes', 'occupational_noise',
                 'occupational_injuries', 'occupational_ergonomic_factors', 'sexual_violence_against_children',
                 'intimate_partner_violence', 'non_exclusive_breastfeeding', 'discontinued_breastfeeding',
                 'injected_drug_use', 'drug_dependence', 'diet_low_in_calcium', 'occupational_exposure_to_asbestos',
                 'occupational_exposure_to_arsenic', 'occupational_exposure_to_benzene',
                 'occupational_exposure_to_beryllium', 'occupational_exposure_to_cadmium',
                 'occupational_exposure_to_chromium', 'occupational_exposure_to_diesel_engine_exhaust',
                 'occupational_exposure_to_formaldehyde', 'occupational_exposure_to_nickel',
                 'occupational_exposure_to_polycyclic_aromatic_hydrocarbons', 'occupational_exposure_to_silica',
                 'occupational_exposure_to_sulfuric_acid', 'intimate_partner_violence_exposure_approach',
                 'intimate_partner_violence_direct_paf_approach', 'all_risk_factors', 'unsafe_sex',
                 'intimate_partner_violence_hiv_paf_approach', 'environmental_occupational_risks',
                 'behavioral_risks', 'occupational_exposure_to_trichloroethylene',
                 'no_access_to_handwashing_facility', 'child_growth_failure', 'child_wasting', 'child_stunting',
                 'lead_exposure_in_blood', 'lead_exposure_in_bone', 'non_optimal_temperature', 'chewing_tobacco',
                 'diet_low_in_legumes', 'short_gestation', 'low_birth_weight', 'high_temperature', 'low_temperature',
                 'low_birth_weight_and_short_gestation', 'kidney_dysfunction', 'bullying_victimization',
                 'high_ldl_cholesterol', 'high_body_mass_index_in_adults', 'high_body_mass_index_in_children',
                 'particulate_matter_pollution', 'sexual_violence_against_children_and_bullying',
                 'nitrogen_dioxide_pollution', )

    def __init__(self,
                 unsafe_water_sanitation_and_handwashing: RiskFactor,
                 unsafe_water_source: RiskFactor,
                 unsafe_sanitation: RiskFactor,
                 air_pollution: RiskFactor,
                 ambient_particulate_matter_pollution: RiskFactor,
                 household_air_pollution_from_solid_fuels: RiskFactor,
                 ambient_ozone_pollution: RiskFactor,
                 other_environmental_risks: RiskFactor,
                 residential_radon: RiskFactor,
                 lead_exposure: RiskFactor,
                 child_and_maternal_malnutrition: RiskFactor,
                 suboptimal_breastfeeding: RiskFactor,
                 child_underweight: RiskFactor,
                 iron_deficiency: RiskFactor,
                 vitamin_a_deficiency: RiskFactor,
                 zinc_deficiency: RiskFactor,
                 tobacco: RiskFactor,
                 smoking: RiskFactor,
                 secondhand_smoke: RiskFactor,
                 high_alcohol_use: RiskFactor,
                 drug_use: RiskFactor,
                 metabolic_risks: RiskFactor,
                 high_fasting_plasma_glucose: RiskFactor,
                 high_systolic_blood_pressure: RiskFactor,
                 high_body_mass_index: RiskFactor,
                 low_bone_mineral_density: RiskFactor,
                 dietary_risks: RiskFactor,
                 diet_low_in_fruits: RiskFactor,
                 diet_low_in_vegetables: RiskFactor,
                 diet_low_in_whole_grains: RiskFactor,
                 diet_low_in_nuts_and_seeds: RiskFactor,
                 diet_low_in_milk: RiskFactor,
                 diet_high_in_red_meat: RiskFactor,
                 diet_high_in_processed_meat: RiskFactor,
                 diet_high_in_sugar_sweetened_beverages: RiskFactor,
                 diet_low_in_fiber: RiskFactor,
                 diet_low_in_seafood_omega_3_fatty_acids: RiskFactor,
                 diet_low_in_omega_6_polyunsaturated_fatty_acids: RiskFactor,
                 diet_high_in_trans_fatty_acids: RiskFactor,
                 diet_high_in_sodium: RiskFactor,
                 low_physical_activity: RiskFactor,
                 occupational_risks: RiskFactor,
                 occupational_carcinogens: RiskFactor,
                 occupational_asthmagens: RiskFactor,
                 occupational_particulate_matter_gases_and_fumes: RiskFactor,
                 occupational_noise: RiskFactor,
                 occupational_injuries: RiskFactor,
                 occupational_ergonomic_factors: RiskFactor,
                 sexual_violence_against_children: RiskFactor,
                 intimate_partner_violence: RiskFactor,
                 non_exclusive_breastfeeding: RiskFactor,
                 discontinued_breastfeeding: RiskFactor,
                 injected_drug_use: RiskFactor,
                 drug_dependence: RiskFactor,
                 diet_low_in_calcium: RiskFactor,
                 occupational_exposure_to_asbestos: RiskFactor,
                 occupational_exposure_to_arsenic: RiskFactor,
                 occupational_exposure_to_benzene: RiskFactor,
                 occupational_exposure_to_beryllium: RiskFactor,
                 occupational_exposure_to_cadmium: RiskFactor,
                 occupational_exposure_to_chromium: RiskFactor,
                 occupational_exposure_to_diesel_engine_exhaust: RiskFactor,
                 occupational_exposure_to_formaldehyde: RiskFactor,
                 occupational_exposure_to_nickel: RiskFactor,
                 occupational_exposure_to_polycyclic_aromatic_hydrocarbons: RiskFactor,
                 occupational_exposure_to_silica: RiskFactor,
                 occupational_exposure_to_sulfuric_acid: RiskFactor,
                 intimate_partner_violence_exposure_approach: RiskFactor,
                 intimate_partner_violence_direct_paf_approach: RiskFactor,
                 all_risk_factors: RiskFactor,
                 unsafe_sex: RiskFactor,
                 intimate_partner_violence_hiv_paf_approach: RiskFactor,
                 environmental_occupational_risks: RiskFactor,
                 behavioral_risks: RiskFactor,
                 occupational_exposure_to_trichloroethylene: RiskFactor,
                 no_access_to_handwashing_facility: RiskFactor,
                 child_growth_failure: RiskFactor,
                 child_wasting: RiskFactor,
                 child_stunting: RiskFactor,
                 lead_exposure_in_blood: RiskFactor,
                 lead_exposure_in_bone: RiskFactor,
                 non_optimal_temperature: RiskFactor,
                 chewing_tobacco: RiskFactor,
                 diet_low_in_legumes: RiskFactor,
                 short_gestation: RiskFactor,
                 low_birth_weight: RiskFactor,
                 high_temperature: RiskFactor,
                 low_temperature: RiskFactor,
                 low_birth_weight_and_short_gestation: RiskFactor,
                 kidney_dysfunction: RiskFactor,
                 bullying_victimization: RiskFactor,
                 high_ldl_cholesterol: RiskFactor,
                 high_body_mass_index_in_adults: RiskFactor,
                 high_body_mass_index_in_children: RiskFactor,
                 particulate_matter_pollution: RiskFactor,
                 sexual_violence_against_children_and_bullying: RiskFactor,
                 nitrogen_dioxide_pollution: RiskFactor, ):
        super().__init__()
        self.unsafe_water_sanitation_and_handwashing = unsafe_water_sanitation_and_handwashing
        self.unsafe_water_source = unsafe_water_source
        self.unsafe_sanitation = unsafe_sanitation
        self.air_pollution = air_pollution
        self.ambient_particulate_matter_pollution = ambient_particulate_matter_pollution
        self.household_air_pollution_from_solid_fuels = household_air_pollution_from_solid_fuels
        self.ambient_ozone_pollution = ambient_ozone_pollution
        self.other_environmental_risks = other_environmental_risks
        self.residential_radon = residential_radon
        self.lead_exposure = lead_exposure
        self.child_and_maternal_malnutrition = child_and_maternal_malnutrition
        self.suboptimal_breastfeeding = suboptimal_breastfeeding
        self.child_underweight = child_underweight
        self.iron_deficiency = iron_deficiency
        self.vitamin_a_deficiency = vitamin_a_deficiency
        self.zinc_deficiency = zinc_deficiency
        self.tobacco = tobacco
        self.smoking = smoking
        self.secondhand_smoke = secondhand_smoke
        self.high_alcohol_use = high_alcohol_use
        self.drug_use = drug_use
        self.metabolic_risks = metabolic_risks
        self.high_fasting_plasma_glucose = high_fasting_plasma_glucose
        self.high_systolic_blood_pressure = high_systolic_blood_pressure
        self.high_body_mass_index = high_body_mass_index
        self.low_bone_mineral_density = low_bone_mineral_density
        self.dietary_risks = dietary_risks
        self.diet_low_in_fruits = diet_low_in_fruits
        self.diet_low_in_vegetables = diet_low_in_vegetables
        self.diet_low_in_whole_grains = diet_low_in_whole_grains
        self.diet_low_in_nuts_and_seeds = diet_low_in_nuts_and_seeds
        self.diet_low_in_milk = diet_low_in_milk
        self.diet_high_in_red_meat = diet_high_in_red_meat
        self.diet_high_in_processed_meat = diet_high_in_processed_meat
        self.diet_high_in_sugar_sweetened_beverages = diet_high_in_sugar_sweetened_beverages
        self.diet_low_in_fiber = diet_low_in_fiber
        self.diet_low_in_seafood_omega_3_fatty_acids = diet_low_in_seafood_omega_3_fatty_acids
        self.diet_low_in_omega_6_polyunsaturated_fatty_acids = diet_low_in_omega_6_polyunsaturated_fatty_acids
        self.diet_high_in_trans_fatty_acids = diet_high_in_trans_fatty_acids
        self.diet_high_in_sodium = diet_high_in_sodium
        self.low_physical_activity = low_physical_activity
        self.occupational_risks = occupational_risks
        self.occupational_carcinogens = occupational_carcinogens
        self.occupational_asthmagens = occupational_asthmagens
        self.occupational_particulate_matter_gases_and_fumes = occupational_particulate_matter_gases_and_fumes
        self.occupational_noise = occupational_noise
        self.occupational_injuries = occupational_injuries
        self.occupational_ergonomic_factors = occupational_ergonomic_factors
        self.sexual_violence_against_children = sexual_violence_against_children
        self.intimate_partner_violence = intimate_partner_violence
        self.non_exclusive_breastfeeding = non_exclusive_breastfeeding
        self.discontinued_breastfeeding = discontinued_breastfeeding
        self.injected_drug_use = injected_drug_use
        self.drug_dependence = drug_dependence
        self.diet_low_in_calcium = diet_low_in_calcium
        self.occupational_exposure_to_asbestos = occupational_exposure_to_asbestos
        self.occupational_exposure_to_arsenic = occupational_exposure_to_arsenic
        self.occupational_exposure_to_benzene = occupational_exposure_to_benzene
        self.occupational_exposure_to_beryllium = occupational_exposure_to_beryllium
        self.occupational_exposure_to_cadmium = occupational_exposure_to_cadmium
        self.occupational_exposure_to_chromium = occupational_exposure_to_chromium
        self.occupational_exposure_to_diesel_engine_exhaust = occupational_exposure_to_diesel_engine_exhaust
        self.occupational_exposure_to_formaldehyde = occupational_exposure_to_formaldehyde
        self.occupational_exposure_to_nickel = occupational_exposure_to_nickel
        self.occupational_exposure_to_polycyclic_aromatic_hydrocarbons = occupational_exposure_to_polycyclic_aromatic_hydrocarbons
        self.occupational_exposure_to_silica = occupational_exposure_to_silica
        self.occupational_exposure_to_sulfuric_acid = occupational_exposure_to_sulfuric_acid
        self.intimate_partner_violence_exposure_approach = intimate_partner_violence_exposure_approach
        self.intimate_partner_violence_direct_paf_approach = intimate_partner_violence_direct_paf_approach
        self.all_risk_factors = all_risk_factors
        self.unsafe_sex = unsafe_sex
        self.intimate_partner_violence_hiv_paf_approach = intimate_partner_violence_hiv_paf_approach
        self.environmental_occupational_risks = environmental_occupational_risks
        self.behavioral_risks = behavioral_risks
        self.occupational_exposure_to_trichloroethylene = occupational_exposure_to_trichloroethylene
        self.no_access_to_handwashing_facility = no_access_to_handwashing_facility
        self.child_growth_failure = child_growth_failure
        self.child_wasting = child_wasting
        self.child_stunting = child_stunting
        self.lead_exposure_in_blood = lead_exposure_in_blood
        self.lead_exposure_in_bone = lead_exposure_in_bone
        self.non_optimal_temperature = non_optimal_temperature
        self.chewing_tobacco = chewing_tobacco
        self.diet_low_in_legumes = diet_low_in_legumes
        self.short_gestation = short_gestation
        self.low_birth_weight = low_birth_weight
        self.high_temperature = high_temperature
        self.low_temperature = low_temperature
        self.low_birth_weight_and_short_gestation = low_birth_weight_and_short_gestation
        self.kidney_dysfunction = kidney_dysfunction
        self.bullying_victimization = bullying_victimization
        self.high_ldl_cholesterol = high_ldl_cholesterol
        self.high_body_mass_index_in_adults = high_body_mass_index_in_adults
        self.high_body_mass_index_in_children = high_body_mass_index_in_children
        self.particulate_matter_pollution = particulate_matter_pollution
        self.sexual_violence_against_children_and_bullying = sexual_violence_against_children_and_bullying
        self.nitrogen_dioxide_pollution = nitrogen_dioxide_pollution
