> [!IMPORTANT]
> **Note for contributors:** When branching out, create a new branch from the `dev` branch.

# 🎉 Welcome to **cognee**! 

We're excited that you're interested in contributing to our project! 
We want to ensure that every user and contributor feels welcome, included and supported to participate in cognee community. 
This guide will help you get started and ensure your contributions can be efficiently integrated into the project.

## 🌟 Quick Links

- [Code of Conduct](CODE_OF_CONDUCT.md)
- [Discord Community](https://discord.gg/bcy8xFAtfd)  
- [Issue Tracker](https://github.com/topoteretes/cognee/issues)
- [Cognee Docs](https://docs.cognee.ai)

## 1. 🚀 Ways to Contribute

You can contribute to **cognee** in many ways:

- 📝 Submitting bug reports or feature requests
- 💡 Improving documentation
- 🔍 Reviewing pull requests
- 🛠️ Contributing code or tests
- 🌐 Helping other users

## 📫 Get in Touch

There are several ways to connect with the **cognee** team and community:

### GitHub Collaboration
- [Open an issue](https://github.com/topoteretes/cognee/issues) for bug reports, feature requests, or discussions
- Submit pull requests to contribute code or documentation
- Join ongoing discussions in existing issues and PRs

### Community Channels
- Join our [Discord community](https://discord.gg/bcy8xFAtfd) for real-time discussions
- Participate in community events and discussions
- Get help from other community members

### Direct Contact
- Email: vasilije@cognee.ai
- For business inquiries or sensitive matters, please reach out via email
- For general questions, prefer public channels like GitHub issues or Discord

We aim to respond to all communications within 2 business days. For faster responses, consider using our Discord channel where the whole community can help!

## Issue Labels

To help you find the most appropriate issues to work on, we use the following labels:

- `good first issue` - Perfect for newcomers to the project
- `bug` - Something isn't working as expected
- `documentation` - Improvements or additions to documentation
- `enhancement` - New features or improvements
- `help wanted` - Extra attention or assistance needed
- `question` - Further information is requested
- `wontfix` - This will not be worked on

Looking for a place to start? Try filtering for [good first issues](https://github.com/topoteretes/cognee/labels/good%20first%20issue)!


## 2. 🛠️ Development Setup

### Fork and Clone

1. Fork the [**cognee**](https://github.com/topoteretes/cognee) repository
2. Clone your fork:
```shell
git clone https://github.com/<your-github-username>/cognee.git
cd cognee
```
In case you are working on Vector and Graph Adapters
1. Fork the [**cognee**](https://github.com/topoteretes/cognee-community) repository
2. Clone your fork:
```shell
git clone https://github.com/<your-github-username>/cognee-community.git
cd cognee-community
```

### Create a Branch

Create a new branch for your work:
```shell
git checkout -b feature/your-feature-name
```

## 3. 🎯 Making Changes

1. **Code Style**: Follow the project's coding standards
2. **Documentation**: Update relevant documentation
3. **Tests**: Add tests for new features
4. **Commits**: Write clear commit messages

### Running Tests
```shell
python cognee/cognee/tests/test_library.py
```

## 4. 📤 Submitting Changes

1. Install ruff on your system
2. Run ```ruff format .``` and ``` ruff check ``` and fix the issues
3. Push your changes:
```shell
git add .
git commit -s -m "Description of your changes"
git push origin feature/your-feature-name
```

2. Create a Pull Request:
   - Go to the [**cognee** repository](https://github.com/topoteretes/cognee) or [cognee community repository](https://github.com/topoteretes/cognee-community)
   - Click "Compare & Pull Request" and open a PR against dev branch
   - Fill in the PR template with details about your changes

## 5. 📜 Developer Certificate of Origin (DCO)

All contributions must be signed-off to indicate agreement with our DCO:

```shell
git config alias.cos "commit -s"  # Create alias for signed commits
```

When your PR is ready, please include:
> "I affirm that all code in every commit of this pull request conforms to the terms of the Topoteretes Developer Certificate of Origin"

## 6. 🤝 Community Guidelines

- Be respectful and inclusive
- Help others learn and grow
- Follow our [Code of Conduct](CODE_OF_CONDUCT.md)
- Provide constructive feedback
- Ask questions when unsure

## 7. 📫 Getting Help

- Open an [issue](https://github.com/topoteretes/cognee/issues)
- Join our Discord community
- Check existing documentation

Thank you for contributing to **cognee**! 🌟
