# isort: skip_file
from __future__ import annotations

from typing import overload

from .unit import Unit
from .quantity import Quantity, QuantitySetter, UnitApplier, UnitChanger

class AccelerationSetter(QuantitySetter[Acceleration]):
    @property
    def foot_per_square_second(self) -> Acceleration: ...
    @property
    def meter_per_square_second(self) -> Acceleration: ...

class Acceleration(Quantity[Acceleration]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[Acceleration] | None = None) -> None: ...
    class ToUnit(UnitApplier[Acceleration]):
        @property
        def foot_per_square_second(self) -> Acceleration: ...
        @property
        def meter_per_square_second(self) -> Acceleration: ...

        def __call__(self, unit: Unit[Acceleration] | str) -> Acceleration: ...

    class AsUnit(UnitChanger[Acceleration]):
        @property
        def foot_per_square_second(self) -> Acceleration: ...
        @property
        def meter_per_square_second(self) -> Acceleration: ...

        def __call__(self, unit: Unit[Acceleration] | str) -> Acceleration: ...

    @property
    def to_unit(self) -> Acceleration.ToUnit: ...

    @property
    def as_unit(self) -> Acceleration.AsUnit: ...

    @overload
    def set(self, value: float) -> AccelerationSetter: ...
    @overload
    def set(self, value: float, unit: Unit[Acceleration]) -> Acceleration: ...
    @overload
    def set(self, value: float, unit: str) -> Acceleration: ...

class AnglePlaneSetter(QuantitySetter[AnglePlane]):
    @property
    def degree(self) -> AnglePlane: ...
    @property
    def radian(self) -> AnglePlane: ...

class AnglePlane(Quantity[AnglePlane]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[AnglePlane] | None = None) -> None: ...
    class ToUnit(UnitApplier[AnglePlane]):
        @property
        def degree(self) -> AnglePlane: ...
        @property
        def radian(self) -> AnglePlane: ...

        def __call__(self, unit: Unit[AnglePlane] | str) -> AnglePlane: ...

    class AsUnit(UnitChanger[AnglePlane]):
        @property
        def degree(self) -> AnglePlane: ...
        @property
        def radian(self) -> AnglePlane: ...

        def __call__(self, unit: Unit[AnglePlane] | str) -> AnglePlane: ...

    @property
    def to_unit(self) -> AnglePlane.ToUnit: ...

    @property
    def as_unit(self) -> AnglePlane.AsUnit: ...

    @overload
    def set(self, value: float) -> AnglePlaneSetter: ...
    @overload
    def set(self, value: float, unit: Unit[AnglePlane]) -> AnglePlane: ...
    @overload
    def set(self, value: float, unit: str) -> AnglePlane: ...

class AreaSetter(QuantitySetter[Area]):
    @property
    def square_foot(self) -> Area: ...
    @property
    def square_meter(self) -> Area: ...
    @property
    def square_millimeter(self) -> Area: ...

class Area(Quantity[Area]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[Area] | None = None) -> None: ...
    class ToUnit(UnitApplier[Area]):
        @property
        def square_foot(self) -> Area: ...
        @property
        def square_meter(self) -> Area: ...
        @property
        def square_millimeter(self) -> Area: ...

        def __call__(self, unit: Unit[Area] | str) -> Area: ...

    class AsUnit(UnitChanger[Area]):
        @property
        def square_foot(self) -> Area: ...
        @property
        def square_meter(self) -> Area: ...
        @property
        def square_millimeter(self) -> Area: ...

        def __call__(self, unit: Unit[Area] | str) -> Area: ...

    @property
    def to_unit(self) -> Area.ToUnit: ...

    @property
    def as_unit(self) -> Area.AsUnit: ...

    @overload
    def set(self, value: float) -> AreaSetter: ...
    @overload
    def set(self, value: float, unit: Unit[Area]) -> Area: ...
    @overload
    def set(self, value: float, unit: str) -> Area: ...

class ForceSetter(QuantitySetter[Force]):
    @property
    def newton(self) -> Force: ...
    @property
    def pound_force(self) -> Force: ...

class Force(Quantity[Force]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[Force] | None = None) -> None: ...
    class ToUnit(UnitApplier[Force]):
        @property
        def newton(self) -> Force: ...
        @property
        def pound_force(self) -> Force: ...

        def __call__(self, unit: Unit[Force] | str) -> Force: ...

    class AsUnit(UnitChanger[Force]):
        @property
        def newton(self) -> Force: ...
        @property
        def pound_force(self) -> Force: ...

        def __call__(self, unit: Unit[Force] | str) -> Force: ...

    @property
    def to_unit(self) -> Force.ToUnit: ...

    @property
    def as_unit(self) -> Force.AsUnit: ...

    @overload
    def set(self, value: float) -> ForceSetter: ...
    @overload
    def set(self, value: float, unit: Unit[Force]) -> Force: ...
    @overload
    def set(self, value: float, unit: str) -> Force: ...

class LengthSetter(QuantitySetter[Length]):
    @property
    def foot(self) -> Length: ...
    @property
    def inch(self) -> Length: ...
    @property
    def meter(self) -> Length: ...
    @property
    def millimeter(self) -> Length: ...

class Length(Quantity[Length]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[Length] | None = None) -> None: ...
    class ToUnit(UnitApplier[Length]):
        @property
        def foot(self) -> Length: ...
        @property
        def inch(self) -> Length: ...
        @property
        def meter(self) -> Length: ...
        @property
        def millimeter(self) -> Length: ...

        def __call__(self, unit: Unit[Length] | str) -> Length: ...

    class AsUnit(UnitChanger[Length]):
        @property
        def foot(self) -> Length: ...
        @property
        def inch(self) -> Length: ...
        @property
        def meter(self) -> Length: ...
        @property
        def millimeter(self) -> Length: ...

        def __call__(self, unit: Unit[Length] | str) -> Length: ...

    @property
    def to_unit(self) -> Length.ToUnit: ...

    @property
    def as_unit(self) -> Length.AsUnit: ...

    @overload
    def set(self, value: float) -> LengthSetter: ...
    @overload
    def set(self, value: float, unit: Unit[Length]) -> Length: ...
    @overload
    def set(self, value: float, unit: str) -> Length: ...

class DimensionlessSetter(QuantitySetter[Dimensionless]):
    @property
    def dimensionless(self) -> Dimensionless: ...

class Dimensionless(Quantity[Dimensionless]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[Dimensionless] | None = None) -> None: ...
    class ToUnit(UnitApplier[Dimensionless]):
        @property
        def dimensionless(self) -> Dimensionless: ...

        def __call__(self, unit: Unit[Dimensionless] | str) -> Dimensionless: ...

    class AsUnit(UnitChanger[Dimensionless]):
        @property
        def dimensionless(self) -> Dimensionless: ...

        def __call__(self, unit: Unit[Dimensionless] | str) -> Dimensionless: ...

    @property
    def to_unit(self) -> Dimensionless.ToUnit: ...

    @property
    def as_unit(self) -> Dimensionless.AsUnit: ...

    @overload
    def set(self, value: float) -> DimensionlessSetter: ...
    @overload
    def set(self, value: float, unit: Unit[Dimensionless]) -> Dimensionless: ...
    @overload
    def set(self, value: float, unit: str) -> Dimensionless: ...

class MassDensitySetter(QuantitySetter[MassDensity]):
    @property
    def kilogram_per_cubic_meter(self) -> MassDensity: ...
    @property
    def ounce_per_milliliter(self) -> MassDensity: ...
    @property
    def pound_mass_per_cubic_foot(self) -> MassDensity: ...

class MassDensity(Quantity[MassDensity]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[MassDensity] | None = None) -> None: ...
    class ToUnit(UnitApplier[MassDensity]):
        @property
        def kilogram_per_cubic_meter(self) -> MassDensity: ...
        @property
        def ounce_per_milliliter(self) -> MassDensity: ...
        @property
        def pound_mass_per_cubic_foot(self) -> MassDensity: ...

        def __call__(self, unit: Unit[MassDensity] | str) -> MassDensity: ...

    class AsUnit(UnitChanger[MassDensity]):
        @property
        def kilogram_per_cubic_meter(self) -> MassDensity: ...
        @property
        def ounce_per_milliliter(self) -> MassDensity: ...
        @property
        def pound_mass_per_cubic_foot(self) -> MassDensity: ...

        def __call__(self, unit: Unit[MassDensity] | str) -> MassDensity: ...

    @property
    def to_unit(self) -> MassDensity.ToUnit: ...

    @property
    def as_unit(self) -> MassDensity.AsUnit: ...

    @overload
    def set(self, value: float) -> MassDensitySetter: ...
    @overload
    def set(self, value: float, unit: Unit[MassDensity]) -> MassDensity: ...
    @overload
    def set(self, value: float, unit: str) -> MassDensity: ...

class MassFlowRateSetter(QuantitySetter[MassFlowRate]):
    @property
    def kilogram_per_second(self) -> MassFlowRate: ...

class MassFlowRate(Quantity[MassFlowRate]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[MassFlowRate] | None = None) -> None: ...
    class ToUnit(UnitApplier[MassFlowRate]):
        @property
        def kilogram_per_second(self) -> MassFlowRate: ...

        def __call__(self, unit: Unit[MassFlowRate] | str) -> MassFlowRate: ...

    class AsUnit(UnitChanger[MassFlowRate]):
        @property
        def kilogram_per_second(self) -> MassFlowRate: ...

        def __call__(self, unit: Unit[MassFlowRate] | str) -> MassFlowRate: ...

    @property
    def to_unit(self) -> MassFlowRate.ToUnit: ...

    @property
    def as_unit(self) -> MassFlowRate.AsUnit: ...

    @overload
    def set(self, value: float) -> MassFlowRateSetter: ...
    @overload
    def set(self, value: float, unit: Unit[MassFlowRate]) -> MassFlowRate: ...
    @overload
    def set(self, value: float, unit: str) -> MassFlowRate: ...

class PowerThermalDutySetter(QuantitySetter[PowerThermalDuty]):
    @property
    def Btu_per_hour(self) -> PowerThermalDuty: ...
    @property
    def horsepower(self) -> PowerThermalDuty: ...
    @property
    def watt(self) -> PowerThermalDuty: ...

class PowerThermalDuty(Quantity[PowerThermalDuty]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[PowerThermalDuty] | None = None) -> None: ...
    class ToUnit(UnitApplier[PowerThermalDuty]):
        @property
        def Btu_per_hour(self) -> PowerThermalDuty: ...
        @property
        def horsepower(self) -> PowerThermalDuty: ...
        @property
        def watt(self) -> PowerThermalDuty: ...

        def __call__(self, unit: Unit[PowerThermalDuty] | str) -> PowerThermalDuty: ...

    class AsUnit(UnitChanger[PowerThermalDuty]):
        @property
        def Btu_per_hour(self) -> PowerThermalDuty: ...
        @property
        def horsepower(self) -> PowerThermalDuty: ...
        @property
        def watt(self) -> PowerThermalDuty: ...

        def __call__(self, unit: Unit[PowerThermalDuty] | str) -> PowerThermalDuty: ...

    @property
    def to_unit(self) -> PowerThermalDuty.ToUnit: ...

    @property
    def as_unit(self) -> PowerThermalDuty.AsUnit: ...

    @overload
    def set(self, value: float) -> PowerThermalDutySetter: ...
    @overload
    def set(self, value: float, unit: Unit[PowerThermalDuty]) -> PowerThermalDuty: ...
    @overload
    def set(self, value: float, unit: str) -> PowerThermalDuty: ...

class PressureSetter(QuantitySetter[Pressure]):
    @property
    def Pa(self) -> Pressure: ...
    @property
    def pascal(self) -> Pressure: ...
    @property
    def pascals(self) -> Pressure: ...
    @property
    def pound_force_per_square_inch(self) -> Pressure: ...

class Pressure(Quantity[Pressure]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[Pressure] | None = None) -> None: ...
    class ToUnit(UnitApplier[Pressure]):
        @property
        def Pa(self) -> Pressure: ...
        @property
        def pascal(self) -> Pressure: ...
        @property
        def pascals(self) -> Pressure: ...
        @property
        def pound_force_per_square_inch(self) -> Pressure: ...

        def __call__(self, unit: Unit[Pressure] | str) -> Pressure: ...

    class AsUnit(UnitChanger[Pressure]):
        @property
        def Pa(self) -> Pressure: ...
        @property
        def pascal(self) -> Pressure: ...
        @property
        def pascals(self) -> Pressure: ...
        @property
        def pound_force_per_square_inch(self) -> Pressure: ...

        def __call__(self, unit: Unit[Pressure] | str) -> Pressure: ...

    @property
    def to_unit(self) -> Pressure.ToUnit: ...

    @property
    def as_unit(self) -> Pressure.AsUnit: ...

    @overload
    def set(self, value: float) -> PressureSetter: ...
    @overload
    def set(self, value: float, unit: Unit[Pressure]) -> Pressure: ...
    @overload
    def set(self, value: float, unit: str) -> Pressure: ...

class SecondMomentOfAreaSetter(QuantitySetter[SecondMomentOfArea]):
    @property
    def inch_quadrupled(self) -> SecondMomentOfArea: ...
    @property
    def millimeter_quadrupled(self) -> SecondMomentOfArea: ...

class SecondMomentOfArea(Quantity[SecondMomentOfArea]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[SecondMomentOfArea] | None = None) -> None: ...
    class ToUnit(UnitApplier[SecondMomentOfArea]):
        @property
        def inch_quadrupled(self) -> SecondMomentOfArea: ...
        @property
        def millimeter_quadrupled(self) -> SecondMomentOfArea: ...

        def __call__(self, unit: Unit[SecondMomentOfArea] | str) -> SecondMomentOfArea: ...

    class AsUnit(UnitChanger[SecondMomentOfArea]):
        @property
        def inch_quadrupled(self) -> SecondMomentOfArea: ...
        @property
        def millimeter_quadrupled(self) -> SecondMomentOfArea: ...

        def __call__(self, unit: Unit[SecondMomentOfArea] | str) -> SecondMomentOfArea: ...

    @property
    def to_unit(self) -> SecondMomentOfArea.ToUnit: ...

    @property
    def as_unit(self) -> SecondMomentOfArea.AsUnit: ...

    @overload
    def set(self, value: float) -> SecondMomentOfAreaSetter: ...
    @overload
    def set(self, value: float, unit: Unit[SecondMomentOfArea]) -> SecondMomentOfArea: ...
    @overload
    def set(self, value: float, unit: str) -> SecondMomentOfArea: ...

class SpecificVolumeSetter(QuantitySetter[SpecificVolume]):
    @property
    def cubic_foot_per_pound_mass(self) -> SpecificVolume: ...
    @property
    def cubic_meter_per_kilogram(self) -> SpecificVolume: ...

class SpecificVolume(Quantity[SpecificVolume]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[SpecificVolume] | None = None) -> None: ...
    class ToUnit(UnitApplier[SpecificVolume]):
        @property
        def cubic_foot_per_pound_mass(self) -> SpecificVolume: ...
        @property
        def cubic_meter_per_kilogram(self) -> SpecificVolume: ...

        def __call__(self, unit: Unit[SpecificVolume] | str) -> SpecificVolume: ...

    class AsUnit(UnitChanger[SpecificVolume]):
        @property
        def cubic_foot_per_pound_mass(self) -> SpecificVolume: ...
        @property
        def cubic_meter_per_kilogram(self) -> SpecificVolume: ...

        def __call__(self, unit: Unit[SpecificVolume] | str) -> SpecificVolume: ...

    @property
    def to_unit(self) -> SpecificVolume.ToUnit: ...

    @property
    def as_unit(self) -> SpecificVolume.AsUnit: ...

    @overload
    def set(self, value: float) -> SpecificVolumeSetter: ...
    @overload
    def set(self, value: float, unit: Unit[SpecificVolume]) -> SpecificVolume: ...
    @overload
    def set(self, value: float, unit: str) -> SpecificVolume: ...

class TorqueSetter(QuantitySetter[Torque]):
    @property
    def foot_pound_force(self) -> Torque: ...
    @property
    def inch_pound_force(self) -> Torque: ...
    @property
    def newton_meter(self) -> Torque: ...

class Torque(Quantity[Torque]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[Torque] | None = None) -> None: ...
    class ToUnit(UnitApplier[Torque]):
        @property
        def foot_pound_force(self) -> Torque: ...
        @property
        def inch_pound_force(self) -> Torque: ...
        @property
        def newton_meter(self) -> Torque: ...

        def __call__(self, unit: Unit[Torque] | str) -> Torque: ...

    class AsUnit(UnitChanger[Torque]):
        @property
        def foot_pound_force(self) -> Torque: ...
        @property
        def inch_pound_force(self) -> Torque: ...
        @property
        def newton_meter(self) -> Torque: ...

        def __call__(self, unit: Unit[Torque] | str) -> Torque: ...

    @property
    def to_unit(self) -> Torque.ToUnit: ...

    @property
    def as_unit(self) -> Torque.AsUnit: ...

    @overload
    def set(self, value: float) -> TorqueSetter: ...
    @overload
    def set(self, value: float, unit: Unit[Torque]) -> Torque: ...
    @overload
    def set(self, value: float, unit: str) -> Torque: ...

class VelocityLinearSetter(QuantitySetter[VelocityLinear]):
    @property
    def feet_per_second(self) -> VelocityLinear: ...
    @property
    def meter_per_second(self) -> VelocityLinear: ...

class VelocityLinear(Quantity[VelocityLinear]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[VelocityLinear] | None = None) -> None: ...
    class ToUnit(UnitApplier[VelocityLinear]):
        @property
        def feet_per_second(self) -> VelocityLinear: ...
        @property
        def meter_per_second(self) -> VelocityLinear: ...

        def __call__(self, unit: Unit[VelocityLinear] | str) -> VelocityLinear: ...

    class AsUnit(UnitChanger[VelocityLinear]):
        @property
        def feet_per_second(self) -> VelocityLinear: ...
        @property
        def meter_per_second(self) -> VelocityLinear: ...

        def __call__(self, unit: Unit[VelocityLinear] | str) -> VelocityLinear: ...

    @property
    def to_unit(self) -> VelocityLinear.ToUnit: ...

    @property
    def as_unit(self) -> VelocityLinear.AsUnit: ...

    @overload
    def set(self, value: float) -> VelocityLinearSetter: ...
    @overload
    def set(self, value: float, unit: Unit[VelocityLinear]) -> VelocityLinear: ...
    @overload
    def set(self, value: float, unit: str) -> VelocityLinear: ...

class VolumetricFlowRateSetter(QuantitySetter[VolumetricFlowRate]):
    @property
    def cubic_foot_per_minute(self) -> VolumetricFlowRate: ...
    @property
    def cubic_meter_per_second(self) -> VolumetricFlowRate: ...
    @property
    def gallon_per_minute(self) -> VolumetricFlowRate: ...

class VolumetricFlowRate(Quantity[VolumetricFlowRate]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[VolumetricFlowRate] | None = None) -> None: ...
    class ToUnit(UnitApplier[VolumetricFlowRate]):
        @property
        def cubic_foot_per_minute(self) -> VolumetricFlowRate: ...
        @property
        def cubic_meter_per_second(self) -> VolumetricFlowRate: ...
        @property
        def gallon_per_minute(self) -> VolumetricFlowRate: ...

        def __call__(self, unit: Unit[VolumetricFlowRate] | str) -> VolumetricFlowRate: ...

    class AsUnit(UnitChanger[VolumetricFlowRate]):
        @property
        def cubic_foot_per_minute(self) -> VolumetricFlowRate: ...
        @property
        def cubic_meter_per_second(self) -> VolumetricFlowRate: ...
        @property
        def gallon_per_minute(self) -> VolumetricFlowRate: ...

        def __call__(self, unit: Unit[VolumetricFlowRate] | str) -> VolumetricFlowRate: ...

    @property
    def to_unit(self) -> VolumetricFlowRate.ToUnit: ...

    @property
    def as_unit(self) -> VolumetricFlowRate.AsUnit: ...

    @overload
    def set(self, value: float) -> VolumetricFlowRateSetter: ...
    @overload
    def set(self, value: float, unit: Unit[VolumetricFlowRate]) -> VolumetricFlowRate: ...
    @overload
    def set(self, value: float, unit: str) -> VolumetricFlowRate: ...

class ViscosityDynamicSetter(QuantitySetter[ViscosityDynamic]):
    @property
    def pascal_second(self) -> ViscosityDynamic: ...
    @property
    def poise(self) -> ViscosityDynamic: ...
    @property
    def pound_force_second_per_square_foot(self) -> ViscosityDynamic: ...

class ViscosityDynamic(Quantity[ViscosityDynamic]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[ViscosityDynamic] | None = None) -> None: ...
    class ToUnit(UnitApplier[ViscosityDynamic]):
        @property
        def pascal_second(self) -> ViscosityDynamic: ...
        @property
        def poise(self) -> ViscosityDynamic: ...
        @property
        def pound_force_second_per_square_foot(self) -> ViscosityDynamic: ...

        def __call__(self, unit: Unit[ViscosityDynamic] | str) -> ViscosityDynamic: ...

    class AsUnit(UnitChanger[ViscosityDynamic]):
        @property
        def pascal_second(self) -> ViscosityDynamic: ...
        @property
        def poise(self) -> ViscosityDynamic: ...
        @property
        def pound_force_second_per_square_foot(self) -> ViscosityDynamic: ...

        def __call__(self, unit: Unit[ViscosityDynamic] | str) -> ViscosityDynamic: ...

    @property
    def to_unit(self) -> ViscosityDynamic.ToUnit: ...

    @property
    def as_unit(self) -> ViscosityDynamic.AsUnit: ...

    @overload
    def set(self, value: float) -> ViscosityDynamicSetter: ...
    @overload
    def set(self, value: float, unit: Unit[ViscosityDynamic]) -> ViscosityDynamic: ...
    @overload
    def set(self, value: float, unit: str) -> ViscosityDynamic: ...

class ViscosityKinematicSetter(QuantitySetter[ViscosityKinematic]):
    @property
    def foot_squared_per_second(self) -> ViscosityKinematic: ...
    @property
    def square_meter_per_second(self) -> ViscosityKinematic: ...

class ViscosityKinematic(Quantity[ViscosityKinematic]):
    def __init__(self, name: str, value: float | None = None, preferred: Unit[ViscosityKinematic] | None = None) -> None: ...
    class ToUnit(UnitApplier[ViscosityKinematic]):
        @property
        def foot_squared_per_second(self) -> ViscosityKinematic: ...
        @property
        def square_meter_per_second(self) -> ViscosityKinematic: ...

        def __call__(self, unit: Unit[ViscosityKinematic] | str) -> ViscosityKinematic: ...

    class AsUnit(UnitChanger[ViscosityKinematic]):
        @property
        def foot_squared_per_second(self) -> ViscosityKinematic: ...
        @property
        def square_meter_per_second(self) -> ViscosityKinematic: ...

        def __call__(self, unit: Unit[ViscosityKinematic] | str) -> ViscosityKinematic: ...

    @property
    def to_unit(self) -> ViscosityKinematic.ToUnit: ...

    @property
    def as_unit(self) -> ViscosityKinematic.AsUnit: ...

    @overload
    def set(self, value: float) -> ViscosityKinematicSetter: ...
    @overload
    def set(self, value: float, unit: Unit[ViscosityKinematic]) -> ViscosityKinematic: ...
    @overload
    def set(self, value: float, unit: str) -> ViscosityKinematic: ...
