
class Resource(object):

    def __init__(self, name, id, total=100):
        self.id = id
        self.name = name
        self.total = total
        self.allocations = {}
        self.features = {}
        self.status = {}

    def allocate(self, task, value):
        self.left -= value
        self.allocations[task.id] = value

    def deallocate(self, task):
        value = self.allocations[task.id]
        del self.allocations[task.id]
        self.left += value

class NonBlockingStreamReader:

    def __init__(self, stream):
        '''
        stream: the stream to read from.
                Usually a process' stdout or stderr.
        '''
        self._s = stream
        self._q = Queue()

        def _populateQueue(stream, queue):
            '''
            Collect lines from 'stream' and put them in 'quque'.
            '''

            while True:
                line = stream.readline()
                if line:
                    queue.put(line)
                else:
                    self.end = True
                    break
                    #raise UnexpectedEndOfStream
                time.sleep(0.01)
        self.end = False
        self._t = threading.Thread(target=_populateQueue,
                                   args=(self._s, self._q))
        self._t.daemon = True
        self._t.start()  # start collecting lines from the stream

    def readline(self, timeout=None):
        try:
            return self._q.get(block=timeout is not None,
                               timeout=timeout)
        except Empty:
            if self.end:
                raise UnexpectedEndOfStream
            return None

class UnexpectedEndOfStream(Exception):
    pass
