# mypy-boto3-iam<a id="mypy-boto3-iam"></a>

[![PyPI - mypy-boto3-iam](https://img.shields.io/pypi/v/mypy-boto3-iam.svg?color=blue)](https://pypi.org/project/mypy-boto3-iam)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iam.svg?color=blue)](https://pypi.org/project/mypy-boto3-iam)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-iam?color=blue)](https://pypistats.org/packages/mypy-boto3-iam)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IAM 1.17.76](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-iam docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iam/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-iam](#mypy-boto3-iam)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `IAM` service.

```bash
python -m pip install boto3-stubs[iam]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iam]` in your environment:
  `python -m pip install 'boto3-stubs[iam]'`

Both type checking and auto-complete should work for `IAM` service. No explicit
type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[iam]` in your environment:
  `python -m pip install 'boto3-stubs[iam]'`

Both type checking and auto-complete should work for `IAM` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iam]` in your environment:
  `python -m pip install 'boto3-stubs[iam]'`
- Run `mypy` as usual

Type checking should work for `IAM` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iam]` in your environment:
  `python -m pip install 'boto3-stubs[iam]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IAM` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`IAMClient` provides annotations for `boto3.client("iam")`.

```python
import boto3

from mypy_boto3_iam import IAMClient

client: IAMClient = boto3.client("iam")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IAMClient = session.client("iam")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_iam.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_iam import IAMClient
from mypy_boto3_iam.paginator import (
    GetAccountAuthorizationDetailsPaginator,
    GetGroupPaginator,
    ListAccessKeysPaginator,
    ListAccountAliasesPaginator,
    ListAttachedGroupPoliciesPaginator,
    ListAttachedRolePoliciesPaginator,
    ListAttachedUserPoliciesPaginator,
    ListEntitiesForPolicyPaginator,
    ListGroupPoliciesPaginator,
    ListGroupsPaginator,
    ListGroupsForUserPaginator,
    ListInstanceProfilesPaginator,
    ListInstanceProfilesForRolePaginator,
    ListMFADevicesPaginator,
    ListPoliciesPaginator,
    ListPolicyVersionsPaginator,
    ListRolePoliciesPaginator,
    ListRolesPaginator,
    ListSSHPublicKeysPaginator,
    ListServerCertificatesPaginator,
    ListSigningCertificatesPaginator,
    ListUserPoliciesPaginator,
    ListUserTagsPaginator,
    ListUsersPaginator,
    ListVirtualMFADevicesPaginator,
    SimulateCustomPolicyPaginator,
    SimulatePrincipalPolicyPaginator,
)

client: IAMClient = boto3.client("iam")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_account_authorization_details_paginator: GetAccountAuthorizationDetailsPaginator = client.get_paginator("get_account_authorization_details")
get_group_paginator: GetGroupPaginator = client.get_paginator("get_group")
list_access_keys_paginator: ListAccessKeysPaginator = client.get_paginator("list_access_keys")
list_account_aliases_paginator: ListAccountAliasesPaginator = client.get_paginator("list_account_aliases")
list_attached_group_policies_paginator: ListAttachedGroupPoliciesPaginator = client.get_paginator("list_attached_group_policies")
list_attached_role_policies_paginator: ListAttachedRolePoliciesPaginator = client.get_paginator("list_attached_role_policies")
list_attached_user_policies_paginator: ListAttachedUserPoliciesPaginator = client.get_paginator("list_attached_user_policies")
list_entities_for_policy_paginator: ListEntitiesForPolicyPaginator = client.get_paginator("list_entities_for_policy")
list_group_policies_paginator: ListGroupPoliciesPaginator = client.get_paginator("list_group_policies")
list_groups_paginator: ListGroupsPaginator = client.get_paginator("list_groups")
list_groups_for_user_paginator: ListGroupsForUserPaginator = client.get_paginator("list_groups_for_user")
list_instance_profiles_paginator: ListInstanceProfilesPaginator = client.get_paginator("list_instance_profiles")
list_instance_profiles_for_role_paginator: ListInstanceProfilesForRolePaginator = client.get_paginator("list_instance_profiles_for_role")
list_mfa_devices_paginator: ListMFADevicesPaginator = client.get_paginator("list_mfa_devices")
list_policies_paginator: ListPoliciesPaginator = client.get_paginator("list_policies")
list_policy_versions_paginator: ListPolicyVersionsPaginator = client.get_paginator("list_policy_versions")
list_role_policies_paginator: ListRolePoliciesPaginator = client.get_paginator("list_role_policies")
list_roles_paginator: ListRolesPaginator = client.get_paginator("list_roles")
list_ssh_public_keys_paginator: ListSSHPublicKeysPaginator = client.get_paginator("list_ssh_public_keys")
list_server_certificates_paginator: ListServerCertificatesPaginator = client.get_paginator("list_server_certificates")
list_signing_certificates_paginator: ListSigningCertificatesPaginator = client.get_paginator("list_signing_certificates")
list_user_policies_paginator: ListUserPoliciesPaginator = client.get_paginator("list_user_policies")
list_user_tags_paginator: ListUserTagsPaginator = client.get_paginator("list_user_tags")
list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
list_virtual_mfa_devices_paginator: ListVirtualMFADevicesPaginator = client.get_paginator("list_virtual_mfa_devices")
simulate_custom_policy_paginator: SimulateCustomPolicyPaginator = client.get_paginator("simulate_custom_policy")
simulate_principal_policy_paginator: SimulatePrincipalPolicyPaginator = client.get_paginator("simulate_principal_policy")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_iam.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_iam import IAMClient
from mypy_boto3_iam.waiter import (
    InstanceProfileExistsWaiter,
    PolicyExistsWaiter,
    RoleExistsWaiter,
    UserExistsWaiter,
)

client: IAMClient = boto3.client("iam")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
instance_profile_exists_waiter: InstanceProfileExistsWaiter = client.get_waiter("instance_profile_exists")
policy_exists_waiter: PolicyExistsWaiter = client.get_waiter("policy_exists")
role_exists_waiter: RoleExistsWaiter = client.get_waiter("role_exists")
user_exists_waiter: UserExistsWaiter = client.get_waiter("user_exists")
```

### Service Resource annotations<a id="service-resource-annotations"></a>

`IAMServiceResource` provides annotations for `boto3.resource("iam")`.

```python
from mypy_boto3_iam import IAMServiceResource

resource: IAMServiceResource = boto3.resource("iam")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: IAMServiceResource = session.resource("iam")
```

### Other resources annotations<a id="other-resources-annotations"></a>

`mypy_boto3_iam.service_resource` module contains type annotations for all
resources.

```python
from mypy_boto3_iam import IAMServiceResource
from mypy_boto3_iam.service_resource import (
    AccessKey,
    AccessKeyPair,
    AccountPasswordPolicy,
    AccountSummary,
    AssumeRolePolicy,
    CurrentUser,
    Group,
    GroupPolicy,
    InstanceProfile,
    LoginProfile,
    MfaDevice,
    Policy,
    PolicyVersion,
    Role,
    RolePolicy,
    SamlProvider,
    ServerCertificate,
    SigningCertificate,
    User,
    UserPolicy,
    VirtualMfaDevice,
)

resource: IAMServiceResource = boto3.resource("iam")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_access_key: AccessKey = resource.AccessKey(...)
my_access_key_pair: AccessKeyPair = resource.AccessKeyPair(...)
my_account_password_policy: AccountPasswordPolicy = resource.AccountPasswordPolicy(...)
my_account_summary: AccountSummary = resource.AccountSummary(...)
my_assume_role_policy: AssumeRolePolicy = resource.AssumeRolePolicy(...)
my_current_user: CurrentUser = resource.CurrentUser(...)
my_group: Group = resource.Group(...)
my_group_policy: GroupPolicy = resource.GroupPolicy(...)
my_instance_profile: InstanceProfile = resource.InstanceProfile(...)
my_login_profile: LoginProfile = resource.LoginProfile(...)
my_mfa_device: MfaDevice = resource.MfaDevice(...)
my_policy: Policy = resource.Policy(...)
my_policy_version: PolicyVersion = resource.PolicyVersion(...)
my_role: Role = resource.Role(...)
my_role_policy: RolePolicy = resource.RolePolicy(...)
my_saml_provider: SamlProvider = resource.SamlProvider(...)
my_server_certificate: ServerCertificate = resource.ServerCertificate(...)
my_signing_certificate: SigningCertificate = resource.SigningCertificate(...)
my_user: User = resource.User(...)
my_user_policy: UserPolicy = resource.UserPolicy(...)
my_virtual_mfa_device: VirtualMfaDevice = resource.VirtualMfaDevice(...)
```

### Collections annotations<a id="collections-annotations"></a>

`mypy_boto3_iam.service_resource` module contains type annotations for all
`IAMServiceResource` collections.

```python
from mypy_boto3_iam import IAMServiceResource
from mypy_boto3_iam.service_resource import (
    ServiceResourceGroupsCollection,
    ServiceResourceInstanceProfilesCollection,
    ServiceResourcePoliciesCollection,
    ServiceResourceRolesCollection,
    ServiceResourceSamlProvidersCollection,
    ServiceResourceServerCertificatesCollection,
    ServiceResourceUsersCollection,
    ServiceResourceVirtualMfaDevicesCollection,
)

resource: IAMServiceResource = boto3.resource("iam")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
groups: iam_resources.ServiceResourceGroupsCollection = resource.groups
instance_profiles: iam_resources.ServiceResourceInstanceProfilesCollection = resource.instance_profiles
policies: iam_resources.ServiceResourcePoliciesCollection = resource.policies
roles: iam_resources.ServiceResourceRolesCollection = resource.roles
saml_providers: iam_resources.ServiceResourceSamlProvidersCollection = resource.saml_providers
server_certificates: iam_resources.ServiceResourceServerCertificatesCollection = resource.server_certificates
users: iam_resources.ServiceResourceUsersCollection = resource.users
virtual_mfa_devices: iam_resources.ServiceResourceVirtualMfaDevicesCollection = resource.virtual_mfa_devices
```

### Literals<a id="literals"></a>

`mypy_boto3_iam.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_iam.literals import (
    AccessAdvisorUsageGranularityTypeType,
    ContextKeyTypeEnumType,
    DeletionTaskStatusTypeType,
    EntityTypeType,
    GetAccountAuthorizationDetailsPaginatorName,
    GetGroupPaginatorName,
    InstanceProfileExistsWaiterName,
    ListAccessKeysPaginatorName,
    ListAccountAliasesPaginatorName,
    ListAttachedGroupPoliciesPaginatorName,
    ListAttachedRolePoliciesPaginatorName,
    ListAttachedUserPoliciesPaginatorName,
    ListEntitiesForPolicyPaginatorName,
    ListGroupPoliciesPaginatorName,
    ListGroupsForUserPaginatorName,
    ListGroupsPaginatorName,
    ListInstanceProfilesForRolePaginatorName,
    ListInstanceProfilesPaginatorName,
    ListMFADevicesPaginatorName,
    ListPoliciesPaginatorName,
    ListPolicyVersionsPaginatorName,
    ListRolePoliciesPaginatorName,
    ListRolesPaginatorName,
    ListSSHPublicKeysPaginatorName,
    ListServerCertificatesPaginatorName,
    ListSigningCertificatesPaginatorName,
    ListUserPoliciesPaginatorName,
    ListUserTagsPaginatorName,
    ListUsersPaginatorName,
    ListVirtualMFADevicesPaginatorName,
    PermissionsBoundaryAttachmentTypeType,
    PolicyEvaluationDecisionTypeType,
    PolicyExistsWaiterName,
    PolicySourceTypeType,
    PolicyUsageTypeType,
    ReportFormatTypeType,
    ReportStateTypeType,
    RoleExistsWaiterName,
    SimulateCustomPolicyPaginatorName,
    SimulatePrincipalPolicyPaginatorName,
    UserExistsWaiterName,
    assignmentStatusTypeType,
    encodingTypeType,
    globalEndpointTokenVersionType,
    jobStatusTypeType,
    policyOwnerEntityTypeType,
    policyScopeTypeType,
    policyTypeType,
    sortKeyTypeType,
    statusTypeType,
    summaryKeyTypeType,
)

def check_value(value: AccessAdvisorUsageGranularityTypeType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_iam.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_iam.type_defs import (
    AccessDetailTypeDef,
    AccessKeyLastUsedTypeDef,
    AccessKeyMetadataTypeDef,
    AccessKeyTypeDef,
    AttachedPermissionsBoundaryTypeDef,
    AttachedPolicyTypeDef,
    ContextEntryTypeDef,
    CreateAccessKeyResponseTypeDef,
    CreateGroupResponseTypeDef,
    CreateInstanceProfileResponseTypeDef,
    CreateLoginProfileResponseTypeDef,
    CreateOpenIDConnectProviderResponseTypeDef,
    CreatePolicyResponseTypeDef,
    CreatePolicyVersionResponseTypeDef,
    CreateRoleResponseTypeDef,
    CreateSAMLProviderResponseTypeDef,
    CreateServiceLinkedRoleResponseTypeDef,
    CreateServiceSpecificCredentialResponseTypeDef,
    CreateUserResponseTypeDef,
    CreateVirtualMFADeviceResponseTypeDef,
    DeleteServiceLinkedRoleResponseTypeDef,
    DeletionTaskFailureReasonTypeTypeDef,
    EntityDetailsTypeDef,
    EntityInfoTypeDef,
    ErrorDetailsTypeDef,
    EvaluationResultTypeDef,
    GenerateCredentialReportResponseTypeDef,
    GenerateOrganizationsAccessReportResponseTypeDef,
    GenerateServiceLastAccessedDetailsResponseTypeDef,
    GetAccessKeyLastUsedResponseTypeDef,
    GetAccountAuthorizationDetailsResponseTypeDef,
    GetAccountPasswordPolicyResponseTypeDef,
    GetAccountSummaryResponseTypeDef,
    GetContextKeysForPolicyResponseTypeDef,
    GetCredentialReportResponseTypeDef,
    GetGroupPolicyResponseTypeDef,
    GetGroupResponseTypeDef,
    GetInstanceProfileResponseTypeDef,
    GetLoginProfileResponseTypeDef,
    GetOpenIDConnectProviderResponseTypeDef,
    GetOrganizationsAccessReportResponseTypeDef,
    GetPolicyResponseTypeDef,
    GetPolicyVersionResponseTypeDef,
    GetRolePolicyResponseTypeDef,
    GetRoleResponseTypeDef,
    GetSAMLProviderResponseTypeDef,
    GetSSHPublicKeyResponseTypeDef,
    GetServerCertificateResponseTypeDef,
    GetServiceLastAccessedDetailsResponseTypeDef,
    GetServiceLastAccessedDetailsWithEntitiesResponseTypeDef,
    GetServiceLinkedRoleDeletionStatusResponseTypeDef,
    GetUserPolicyResponseTypeDef,
    GetUserResponseTypeDef,
    GroupDetailTypeDef,
    GroupTypeDef,
    InstanceProfileTypeDef,
    ListAccessKeysResponseTypeDef,
    ListAccountAliasesResponseTypeDef,
    ListAttachedGroupPoliciesResponseTypeDef,
    ListAttachedRolePoliciesResponseTypeDef,
    ListAttachedUserPoliciesResponseTypeDef,
    ListEntitiesForPolicyResponseTypeDef,
    ListGroupPoliciesResponseTypeDef,
    ListGroupsForUserResponseTypeDef,
    ListGroupsResponseTypeDef,
    ListInstanceProfileTagsResponseTypeDef,
    ListInstanceProfilesForRoleResponseTypeDef,
    ListInstanceProfilesResponseTypeDef,
    ListMFADeviceTagsResponseTypeDef,
    ListMFADevicesResponseTypeDef,
    ListOpenIDConnectProviderTagsResponseTypeDef,
    ListOpenIDConnectProvidersResponseTypeDef,
    ListPoliciesGrantingServiceAccessEntryTypeDef,
    ListPoliciesGrantingServiceAccessResponseTypeDef,
    ListPoliciesResponseTypeDef,
    ListPolicyTagsResponseTypeDef,
    ListPolicyVersionsResponseTypeDef,
    ListRolePoliciesResponseTypeDef,
    ListRoleTagsResponseTypeDef,
    ListRolesResponseTypeDef,
    ListSAMLProviderTagsResponseTypeDef,
    ListSAMLProvidersResponseTypeDef,
    ListSSHPublicKeysResponseTypeDef,
    ListServerCertificateTagsResponseTypeDef,
    ListServerCertificatesResponseTypeDef,
    ListServiceSpecificCredentialsResponseTypeDef,
    ListSigningCertificatesResponseTypeDef,
    ListUserPoliciesResponseTypeDef,
    ListUserTagsResponseTypeDef,
    ListUsersResponseTypeDef,
    ListVirtualMFADevicesResponseTypeDef,
    LoginProfileTypeDef,
    MFADeviceTypeDef,
    ManagedPolicyDetailTypeDef,
    OpenIDConnectProviderListEntryTypeDef,
    OrganizationsDecisionDetailTypeDef,
    PaginatorConfigTypeDef,
    PasswordPolicyTypeDef,
    PermissionsBoundaryDecisionDetailTypeDef,
    PolicyDetailTypeDef,
    PolicyGrantingServiceAccessTypeDef,
    PolicyGroupTypeDef,
    PolicyRoleTypeDef,
    PolicyTypeDef,
    PolicyUserTypeDef,
    PolicyVersionTypeDef,
    PositionTypeDef,
    ResetServiceSpecificCredentialResponseTypeDef,
    ResourceSpecificResultTypeDef,
    RoleDetailTypeDef,
    RoleLastUsedTypeDef,
    RoleTypeDef,
    RoleUsageTypeTypeDef,
    SAMLProviderListEntryTypeDef,
    SSHPublicKeyMetadataTypeDef,
    SSHPublicKeyTypeDef,
    ServerCertificateMetadataTypeDef,
    ServerCertificateTypeDef,
    ServiceLastAccessedTypeDef,
    ServiceSpecificCredentialMetadataTypeDef,
    ServiceSpecificCredentialTypeDef,
    SigningCertificateTypeDef,
    SimulatePolicyResponseTypeDef,
    StatementTypeDef,
    TagTypeDef,
    TrackedActionLastAccessedTypeDef,
    UpdateRoleDescriptionResponseTypeDef,
    UpdateSAMLProviderResponseTypeDef,
    UploadSSHPublicKeyResponseTypeDef,
    UploadServerCertificateResponseTypeDef,
    UploadSigningCertificateResponseTypeDef,
    UserDetailTypeDef,
    UserTypeDef,
    VirtualMFADeviceTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccessDetailTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-iam` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-iam docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iam/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
