"""
Type annotations for iam service client paginators.

[Open documentation](./paginators.md)

Usage::

    ```python
    import boto3

    from mypy_boto3_iam import IAMClient
    from mypy_boto3_iam.paginator import (
        GetAccountAuthorizationDetailsPaginator,
        GetGroupPaginator,
        ListAccessKeysPaginator,
        ListAccountAliasesPaginator,
        ListAttachedGroupPoliciesPaginator,
        ListAttachedRolePoliciesPaginator,
        ListAttachedUserPoliciesPaginator,
        ListEntitiesForPolicyPaginator,
        ListGroupPoliciesPaginator,
        ListGroupsPaginator,
        ListGroupsForUserPaginator,
        ListInstanceProfilesPaginator,
        ListInstanceProfilesForRolePaginator,
        ListMFADevicesPaginator,
        ListPoliciesPaginator,
        ListPolicyVersionsPaginator,
        ListRolePoliciesPaginator,
        ListRolesPaginator,
        ListSSHPublicKeysPaginator,
        ListServerCertificatesPaginator,
        ListSigningCertificatesPaginator,
        ListUserPoliciesPaginator,
        ListUserTagsPaginator,
        ListUsersPaginator,
        ListVirtualMFADevicesPaginator,
        SimulateCustomPolicyPaginator,
        SimulatePrincipalPolicyPaginator,
    )

    client: IAMClient = boto3.client("iam")

    get_account_authorization_details_paginator: GetAccountAuthorizationDetailsPaginator = client.get_paginator("get_account_authorization_details")
    get_group_paginator: GetGroupPaginator = client.get_paginator("get_group")
    list_access_keys_paginator: ListAccessKeysPaginator = client.get_paginator("list_access_keys")
    list_account_aliases_paginator: ListAccountAliasesPaginator = client.get_paginator("list_account_aliases")
    list_attached_group_policies_paginator: ListAttachedGroupPoliciesPaginator = client.get_paginator("list_attached_group_policies")
    list_attached_role_policies_paginator: ListAttachedRolePoliciesPaginator = client.get_paginator("list_attached_role_policies")
    list_attached_user_policies_paginator: ListAttachedUserPoliciesPaginator = client.get_paginator("list_attached_user_policies")
    list_entities_for_policy_paginator: ListEntitiesForPolicyPaginator = client.get_paginator("list_entities_for_policy")
    list_group_policies_paginator: ListGroupPoliciesPaginator = client.get_paginator("list_group_policies")
    list_groups_paginator: ListGroupsPaginator = client.get_paginator("list_groups")
    list_groups_for_user_paginator: ListGroupsForUserPaginator = client.get_paginator("list_groups_for_user")
    list_instance_profiles_paginator: ListInstanceProfilesPaginator = client.get_paginator("list_instance_profiles")
    list_instance_profiles_for_role_paginator: ListInstanceProfilesForRolePaginator = client.get_paginator("list_instance_profiles_for_role")
    list_mfa_devices_paginator: ListMFADevicesPaginator = client.get_paginator("list_mfa_devices")
    list_policies_paginator: ListPoliciesPaginator = client.get_paginator("list_policies")
    list_policy_versions_paginator: ListPolicyVersionsPaginator = client.get_paginator("list_policy_versions")
    list_role_policies_paginator: ListRolePoliciesPaginator = client.get_paginator("list_role_policies")
    list_roles_paginator: ListRolesPaginator = client.get_paginator("list_roles")
    list_ssh_public_keys_paginator: ListSSHPublicKeysPaginator = client.get_paginator("list_ssh_public_keys")
    list_server_certificates_paginator: ListServerCertificatesPaginator = client.get_paginator("list_server_certificates")
    list_signing_certificates_paginator: ListSigningCertificatesPaginator = client.get_paginator("list_signing_certificates")
    list_user_policies_paginator: ListUserPoliciesPaginator = client.get_paginator("list_user_policies")
    list_user_tags_paginator: ListUserTagsPaginator = client.get_paginator("list_user_tags")
    list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
    list_virtual_mfa_devices_paginator: ListVirtualMFADevicesPaginator = client.get_paginator("list_virtual_mfa_devices")
    simulate_custom_policy_paginator: SimulateCustomPolicyPaginator = client.get_paginator("simulate_custom_policy")
    simulate_principal_policy_paginator: SimulatePrincipalPolicyPaginator = client.get_paginator("simulate_principal_policy")
    ```
"""
from typing import Iterator, List

from botocore.paginate import Paginator as Boto3Paginator

from .literals import (
    EntityTypeType,
    PolicyUsageTypeType,
    assignmentStatusTypeType,
    policyScopeTypeType,
)
from .type_defs import (
    ContextEntryTypeDef,
    GetAccountAuthorizationDetailsResponseTypeDef,
    GetGroupResponseTypeDef,
    ListAccessKeysResponseTypeDef,
    ListAccountAliasesResponseTypeDef,
    ListAttachedGroupPoliciesResponseTypeDef,
    ListAttachedRolePoliciesResponseTypeDef,
    ListAttachedUserPoliciesResponseTypeDef,
    ListEntitiesForPolicyResponseTypeDef,
    ListGroupPoliciesResponseTypeDef,
    ListGroupsForUserResponseTypeDef,
    ListGroupsResponseTypeDef,
    ListInstanceProfilesForRoleResponseTypeDef,
    ListInstanceProfilesResponseTypeDef,
    ListMFADevicesResponseTypeDef,
    ListPoliciesResponseTypeDef,
    ListPolicyVersionsResponseTypeDef,
    ListRolePoliciesResponseTypeDef,
    ListRolesResponseTypeDef,
    ListServerCertificatesResponseTypeDef,
    ListSigningCertificatesResponseTypeDef,
    ListSSHPublicKeysResponseTypeDef,
    ListUserPoliciesResponseTypeDef,
    ListUsersResponseTypeDef,
    ListUserTagsResponseTypeDef,
    ListVirtualMFADevicesResponseTypeDef,
    PaginatorConfigTypeDef,
    SimulatePolicyResponseTypeDef,
)

__all__ = (
    "GetAccountAuthorizationDetailsPaginator",
    "GetGroupPaginator",
    "ListAccessKeysPaginator",
    "ListAccountAliasesPaginator",
    "ListAttachedGroupPoliciesPaginator",
    "ListAttachedRolePoliciesPaginator",
    "ListAttachedUserPoliciesPaginator",
    "ListEntitiesForPolicyPaginator",
    "ListGroupPoliciesPaginator",
    "ListGroupsPaginator",
    "ListGroupsForUserPaginator",
    "ListInstanceProfilesPaginator",
    "ListInstanceProfilesForRolePaginator",
    "ListMFADevicesPaginator",
    "ListPoliciesPaginator",
    "ListPolicyVersionsPaginator",
    "ListRolePoliciesPaginator",
    "ListRolesPaginator",
    "ListSSHPublicKeysPaginator",
    "ListServerCertificatesPaginator",
    "ListSigningCertificatesPaginator",
    "ListUserPoliciesPaginator",
    "ListUserTagsPaginator",
    "ListUsersPaginator",
    "ListVirtualMFADevicesPaginator",
    "SimulateCustomPolicyPaginator",
    "SimulatePrincipalPolicyPaginator",
)

class GetAccountAuthorizationDetailsPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.GetAccountAuthorizationDetails)[Show boto3-stubs documentation](./paginators.md#getaccountauthorizationdetailspaginator)
    """

    def paginate(
        self, Filter: List[EntityTypeType] = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[GetAccountAuthorizationDetailsResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.GetAccountAuthorizationDetails.paginate)
        [Show boto3-stubs documentation](./paginators.md#getaccountauthorizationdetailspaginator)
        """

class GetGroupPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.GetGroup)[Show boto3-stubs documentation](./paginators.md#getgrouppaginator)
    """

    def paginate(
        self, GroupName: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[GetGroupResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.GetGroup.paginate)
        [Show boto3-stubs documentation](./paginators.md#getgrouppaginator)
        """

class ListAccessKeysPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAccessKeys)[Show boto3-stubs documentation](./paginators.md#listaccesskeyspaginator)
    """

    def paginate(
        self, UserName: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListAccessKeysResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAccessKeys.paginate)
        [Show boto3-stubs documentation](./paginators.md#listaccesskeyspaginator)
        """

class ListAccountAliasesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAccountAliases)[Show boto3-stubs documentation](./paginators.md#listaccountaliasespaginator)
    """

    def paginate(
        self, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListAccountAliasesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAccountAliases.paginate)
        [Show boto3-stubs documentation](./paginators.md#listaccountaliasespaginator)
        """

class ListAttachedGroupPoliciesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAttachedGroupPolicies)[Show boto3-stubs documentation](./paginators.md#listattachedgrouppoliciespaginator)
    """

    def paginate(
        self,
        GroupName: str,
        PathPrefix: str = None,
        PaginationConfig: PaginatorConfigTypeDef = None,
    ) -> Iterator[ListAttachedGroupPoliciesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAttachedGroupPolicies.paginate)
        [Show boto3-stubs documentation](./paginators.md#listattachedgrouppoliciespaginator)
        """

class ListAttachedRolePoliciesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAttachedRolePolicies)[Show boto3-stubs documentation](./paginators.md#listattachedrolepoliciespaginator)
    """

    def paginate(
        self, RoleName: str, PathPrefix: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListAttachedRolePoliciesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAttachedRolePolicies.paginate)
        [Show boto3-stubs documentation](./paginators.md#listattachedrolepoliciespaginator)
        """

class ListAttachedUserPoliciesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAttachedUserPolicies)[Show boto3-stubs documentation](./paginators.md#listattacheduserpoliciespaginator)
    """

    def paginate(
        self, UserName: str, PathPrefix: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListAttachedUserPoliciesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListAttachedUserPolicies.paginate)
        [Show boto3-stubs documentation](./paginators.md#listattacheduserpoliciespaginator)
        """

class ListEntitiesForPolicyPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListEntitiesForPolicy)[Show boto3-stubs documentation](./paginators.md#listentitiesforpolicypaginator)
    """

    def paginate(
        self,
        PolicyArn: str,
        EntityFilter: EntityTypeType = None,
        PathPrefix: str = None,
        PolicyUsageFilter: PolicyUsageTypeType = None,
        PaginationConfig: PaginatorConfigTypeDef = None,
    ) -> Iterator[ListEntitiesForPolicyResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListEntitiesForPolicy.paginate)
        [Show boto3-stubs documentation](./paginators.md#listentitiesforpolicypaginator)
        """

class ListGroupPoliciesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListGroupPolicies)[Show boto3-stubs documentation](./paginators.md#listgrouppoliciespaginator)
    """

    def paginate(
        self, GroupName: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListGroupPoliciesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListGroupPolicies.paginate)
        [Show boto3-stubs documentation](./paginators.md#listgrouppoliciespaginator)
        """

class ListGroupsPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListGroups)[Show boto3-stubs documentation](./paginators.md#listgroupspaginator)
    """

    def paginate(
        self, PathPrefix: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListGroupsResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListGroups.paginate)
        [Show boto3-stubs documentation](./paginators.md#listgroupspaginator)
        """

class ListGroupsForUserPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListGroupsForUser)[Show boto3-stubs documentation](./paginators.md#listgroupsforuserpaginator)
    """

    def paginate(
        self, UserName: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListGroupsForUserResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListGroupsForUser.paginate)
        [Show boto3-stubs documentation](./paginators.md#listgroupsforuserpaginator)
        """

class ListInstanceProfilesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListInstanceProfiles)[Show boto3-stubs documentation](./paginators.md#listinstanceprofilespaginator)
    """

    def paginate(
        self, PathPrefix: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListInstanceProfilesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListInstanceProfiles.paginate)
        [Show boto3-stubs documentation](./paginators.md#listinstanceprofilespaginator)
        """

class ListInstanceProfilesForRolePaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListInstanceProfilesForRole)[Show boto3-stubs documentation](./paginators.md#listinstanceprofilesforrolepaginator)
    """

    def paginate(
        self, RoleName: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListInstanceProfilesForRoleResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListInstanceProfilesForRole.paginate)
        [Show boto3-stubs documentation](./paginators.md#listinstanceprofilesforrolepaginator)
        """

class ListMFADevicesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListMFADevices)[Show boto3-stubs documentation](./paginators.md#listmfadevicespaginator)
    """

    def paginate(
        self, UserName: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListMFADevicesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListMFADevices.paginate)
        [Show boto3-stubs documentation](./paginators.md#listmfadevicespaginator)
        """

class ListPoliciesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListPolicies)[Show boto3-stubs documentation](./paginators.md#listpoliciespaginator)
    """

    def paginate(
        self,
        Scope: policyScopeTypeType = None,
        OnlyAttached: bool = None,
        PathPrefix: str = None,
        PolicyUsageFilter: PolicyUsageTypeType = None,
        PaginationConfig: PaginatorConfigTypeDef = None,
    ) -> Iterator[ListPoliciesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListPolicies.paginate)
        [Show boto3-stubs documentation](./paginators.md#listpoliciespaginator)
        """

class ListPolicyVersionsPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListPolicyVersions)[Show boto3-stubs documentation](./paginators.md#listpolicyversionspaginator)
    """

    def paginate(
        self, PolicyArn: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListPolicyVersionsResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListPolicyVersions.paginate)
        [Show boto3-stubs documentation](./paginators.md#listpolicyversionspaginator)
        """

class ListRolePoliciesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListRolePolicies)[Show boto3-stubs documentation](./paginators.md#listrolepoliciespaginator)
    """

    def paginate(
        self, RoleName: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListRolePoliciesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListRolePolicies.paginate)
        [Show boto3-stubs documentation](./paginators.md#listrolepoliciespaginator)
        """

class ListRolesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListRoles)[Show boto3-stubs documentation](./paginators.md#listrolespaginator)
    """

    def paginate(
        self, PathPrefix: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListRolesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListRoles.paginate)
        [Show boto3-stubs documentation](./paginators.md#listrolespaginator)
        """

class ListSSHPublicKeysPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListSSHPublicKeys)[Show boto3-stubs documentation](./paginators.md#listsshpublickeyspaginator)
    """

    def paginate(
        self, UserName: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListSSHPublicKeysResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListSSHPublicKeys.paginate)
        [Show boto3-stubs documentation](./paginators.md#listsshpublickeyspaginator)
        """

class ListServerCertificatesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListServerCertificates)[Show boto3-stubs documentation](./paginators.md#listservercertificatespaginator)
    """

    def paginate(
        self, PathPrefix: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListServerCertificatesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListServerCertificates.paginate)
        [Show boto3-stubs documentation](./paginators.md#listservercertificatespaginator)
        """

class ListSigningCertificatesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListSigningCertificates)[Show boto3-stubs documentation](./paginators.md#listsigningcertificatespaginator)
    """

    def paginate(
        self, UserName: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListSigningCertificatesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListSigningCertificates.paginate)
        [Show boto3-stubs documentation](./paginators.md#listsigningcertificatespaginator)
        """

class ListUserPoliciesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListUserPolicies)[Show boto3-stubs documentation](./paginators.md#listuserpoliciespaginator)
    """

    def paginate(
        self, UserName: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListUserPoliciesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListUserPolicies.paginate)
        [Show boto3-stubs documentation](./paginators.md#listuserpoliciespaginator)
        """

class ListUserTagsPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListUserTags)[Show boto3-stubs documentation](./paginators.md#listusertagspaginator)
    """

    def paginate(
        self, UserName: str, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListUserTagsResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListUserTags.paginate)
        [Show boto3-stubs documentation](./paginators.md#listusertagspaginator)
        """

class ListUsersPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListUsers)[Show boto3-stubs documentation](./paginators.md#listuserspaginator)
    """

    def paginate(
        self, PathPrefix: str = None, PaginationConfig: PaginatorConfigTypeDef = None
    ) -> Iterator[ListUsersResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListUsers.paginate)
        [Show boto3-stubs documentation](./paginators.md#listuserspaginator)
        """

class ListVirtualMFADevicesPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListVirtualMFADevices)[Show boto3-stubs documentation](./paginators.md#listvirtualmfadevicespaginator)
    """

    def paginate(
        self,
        AssignmentStatus: assignmentStatusTypeType = None,
        PaginationConfig: PaginatorConfigTypeDef = None,
    ) -> Iterator[ListVirtualMFADevicesResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.ListVirtualMFADevices.paginate)
        [Show boto3-stubs documentation](./paginators.md#listvirtualmfadevicespaginator)
        """

class SimulateCustomPolicyPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.SimulateCustomPolicy)[Show boto3-stubs documentation](./paginators.md#simulatecustompolicypaginator)
    """

    def paginate(
        self,
        PolicyInputList: List[str],
        ActionNames: List[str],
        PermissionsBoundaryPolicyInputList: List[str] = None,
        ResourceArns: List[str] = None,
        ResourcePolicy: str = None,
        ResourceOwner: str = None,
        CallerArn: str = None,
        ContextEntries: List[ContextEntryTypeDef] = None,
        ResourceHandlingOption: str = None,
        PaginationConfig: PaginatorConfigTypeDef = None,
    ) -> Iterator[SimulatePolicyResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.SimulateCustomPolicy.paginate)
        [Show boto3-stubs documentation](./paginators.md#simulatecustompolicypaginator)
        """

class SimulatePrincipalPolicyPaginator(Boto3Paginator):
    """
    [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.SimulatePrincipalPolicy)[Show boto3-stubs documentation](./paginators.md#simulateprincipalpolicypaginator)
    """

    def paginate(
        self,
        PolicySourceArn: str,
        ActionNames: List[str],
        PolicyInputList: List[str] = None,
        PermissionsBoundaryPolicyInputList: List[str] = None,
        ResourceArns: List[str] = None,
        ResourcePolicy: str = None,
        ResourceOwner: str = None,
        CallerArn: str = None,
        ContextEntries: List[ContextEntryTypeDef] = None,
        ResourceHandlingOption: str = None,
        PaginationConfig: PaginatorConfigTypeDef = None,
    ) -> Iterator[SimulatePolicyResponseTypeDef]:
        """
        [Show boto3 documentation](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/iam.html#IAM.Paginator.SimulatePrincipalPolicy.paginate)
        [Show boto3-stubs documentation](./paginators.md#simulateprincipalpolicypaginator)
        """
