from .client import Simile
from .auth_client import SimileAuth
from .models import (
    Population,
    Agent,
    DataItem,
    PopulationInfo,
    CreatePopulationPayload,
    CreateAgentPayload,
    CreateDataItemPayload,
    UpdateDataItemPayload,
    DeletionResponse,
    OpenGenerationRequest,
    OpenGenerationResponse,
    ClosedGenerationRequest,
    ClosedGenerationResponse,
    MemoryStream,
    MemoryTurn,
    MemoryTurnType,
    ContextMemoryTurn,
    ImageMemoryTurn,
    OpenQuestionMemoryTurn,
    ClosedQuestionMemoryTurn,
)
from .exceptions import (
    SimileAPIError,
    SimileAuthenticationError,
    SimileNotFoundError,
    SimileBadRequestError,
)

__all__ = [
    "Simile",
    "SimileAuth",
    "Population",
    "PopulationInfo",
    "Agent",
    "DataItem",
    "CreatePopulationPayload",
    "CreateAgentPayload",
    "CreateDataItemPayload",
    "UpdateDataItemPayload",
    "DeletionResponse",
    "OpenGenerationRequest",
    "OpenGenerationResponse",
    "ClosedGenerationRequest",
    "ClosedGenerationResponse",
    "MemoryStream",
    "MemoryTurn",
    "MemoryTurnType",
    "ContextMemoryTurn",
    "ImageMemoryTurn",
    "OpenQuestionMemoryTurn",
    "ClosedQuestionMemoryTurn",
    "SimileAPIError",
    "SimileAuthenticationError",
    "SimileNotFoundError",
    "SimileBadRequestError",
]

__version__ = "0.2.15"
