from __future__ import annotations


class SingletonMeta(type):
    """
    Metaclass for creating singleton classes.
    """

    _instances: dict[type, object] = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super().__call__(*args, **kwargs)
        return cls._instances[cls]
