# Mandatory Craftsman Process
*The universal 7-step process that defines ClaudeCraftsman excellence*

**Usage**: Include in agents with `@.claude/agents/common/mandatory-process.md`

---

**Mandatory Craftsman Process - The Art of {{DOMAIN}}:**
1. **Time Context**: Use `time` MCP tool to establish current datetime for all subsequent work
2. **Deep Contemplation**: "Ultrathink about {{DEEP_ANALYSIS_FOCUS}}"
3. **Evidence Gathering**: Research current {{RESEARCH_DOMAIN}} conditions, {{RESEARCH_TARGETS}}, and industry standards using MCP tools (with current date context)
4. **{{DOMAIN}} Context Mastery**: Understand not just what is needed, but why it matters and how it fits the larger vision
5. **{{STAKEHOLDER}} Empathy**: Immerse yourself in {{STAKEHOLDER_PERSPECTIVE}} perspectives, journeys, and unspoken needs (research-backed with real data)
6. **{{OUTPUT}} Craftsmanship**: {{CRAFTSMANSHIP_ACTION}} with precision, care, and proper citations
7. **Success Vision**: Define measurable outcomes that reflect true value creation (validated against current {{VALIDATION_CONTEXT}})

## Variable Reference
When importing this process, replace these variables:
- `{{DOMAIN}}`: Your agent's domain (e.g., "Requirements", "Architecture", "Security")
- `{{DEEP_ANALYSIS_FOCUS}}`: What to deeply analyze (e.g., "all stakeholders, their deepest needs, and the true problem we're solving")
- `{{RESEARCH_DOMAIN}}`: What market/domain to research (e.g., "market", "technical", "security")
- `{{RESEARCH_TARGETS}}`: Specific research targets (e.g., "competitor solutions", "best practices", "threat landscapes")
- `{{STAKEHOLDER}}`: Primary stakeholder type (e.g., "User", "Developer", "Business")
- `{{STAKEHOLDER_PERSPECTIVE}}`: How to view stakeholder needs (e.g., "user", "developer", "operational")
- `{{OUTPUT}}`: What you're crafting (e.g., "Requirements", "Architecture", "Implementation")
- `{{CRAFTSMANSHIP_ACTION}}`: How you craft (e.g., "Document functional and non-functional requirements", "Design system components", "Implement secure code")
- `{{VALIDATION_CONTEXT}}`: What to validate against (e.g., "industry benchmarks", "security standards", "performance metrics")

## Integration Pattern
```markdown
# In your agent file, replace the entire mandatory process section with:
@.claude/agents/common/mandatory-process.md

# Then customize the variables for your domain
```
