---
name: help
description: Command selection guide for choosing the right command based on project scope. All commands produce craftsman-quality outputs - the difference is scope, not quality.
---

# ClaudeCraftsman Command Selection Guide
*Choose the right scope for the right job - all outputs are craftsman quality*

## Philosophy
Every command in the ClaudeCraftsman framework produces work we'd be proud to showcase. There are no "simple" or "basic" outputs - only different scopes of excellent work. Whether you're creating a single agent or designing a complex system, the output will reflect our commitment to craftsmanship.

## Quick Decision Tree

```
What are you trying to do?

┌─ Create single component (agent, command, template)
│  └─ Use: /add [type] [name]
│     └─ Examples: /add agent backend, /add command test
│        └─ Result: Craftsman-quality component with full framework integration
│
├─ Plan a feature or enhancement
│  └─ Use: /plan [feature-name]
│     └─ Examples: /plan user-authentication, /plan api-optimization
│        └─ Result: Comprehensive feature plan with analysis and coordination
│
├─ Design a complex system with research
│  └─ Use: /design [system-name] --research=deep
│     └─ Examples: /design e-commerce-platform, /design ai-analytics-system
│        └─ Result: Complete system specifications with market research
│
├─ Execute a plan systematically
│  └─ Use: /implement [plan-name]
│     └─ Examples: /implement user-auth, /implement data-migration
│        └─ Result: Orchestrated execution with progress tracking
│
├─ Test your implementation
│  └─ Use: /test [feature] [--type]
│     └─ Examples: /test login --bdd, /test api --playwright
│        └─ Result: Comprehensive test suite with quality validation
│
└─ Get help choosing
   └─ Use: /help or read this guide
```

## Command Comparison

| Command | Time | Files | Scope & Purpose |
|---------|------|-------|-----------------|
| **`/add`** | 2-5min | 1 file | Single craftsman-quality components with full framework integration |
| **`/plan`** | 5-15min | 2-4 files | Features with coordination, analysis, and implementation roadmap |
| **`/design`** | 15-45min | 5-12 files | Complex systems with market research and comprehensive specifications |
| **`/implement`** | Varies | Many | Execute plans with multi-agent orchestration and progress tracking |
| **`/test`** | 10-30min | 3-8 files | Create test suites with BDD/TDD and Playwright integration |
| **`/workflow`** | Varies | Many | Coordinate complex multi-agent development workflows |

**All commands produce craftsman-quality outputs. The difference is scope, not quality.**

## Detailed Command Guide

### `/add` - Craftsman Component Creation ⚡
**Perfect for:**
- ✅ Creating new agents with full framework integration
- ✅ Adding commands with comprehensive documentation
- ✅ Making templates with quality standards
- ✅ Single components that need to be excellent from the start

**What you get:**
- Complete craftsman-quality component
- Full MCP tool integration (where applicable)
- Framework standards compliance
- Quality gates and process documentation
- Ready for immediate use in framework

**Process:**
1. Analyze component requirements and domain
2. Apply craftsman template with domain customization
3. Include all framework standards and integrations
4. Validate quality and framework compliance
5. Single excellent file ready for use

**Example:** "I need a backend-architect agent"
```bash
/add agent backend-architect
```
**Result:** Fully crafted agent with TDD methodology, MCP integration, quality gates, and craftsman philosophy - just like our hand-built agents.

### `/plan` - Feature Excellence Planning 📋
**Perfect for:**
- ✅ Multi-component features requiring coordination
- ✅ Enhancements to existing systems with analysis
- ✅ Features needing implementation roadmap
- ✅ Coordination between multiple framework components

**What you get:**
- Comprehensive feature analysis and requirements
- Implementation roadmap with phases and dependencies
- Resource planning and coordination strategy
- Quality standards and acceptance criteria
- Integration plans with existing components

**Process:**
1. Feature requirements analysis with research
2. Stakeholder and coordination analysis
3. Implementation planning with quality focus
4. Resource and dependency mapping
5. Success criteria and quality gates definition

**Example:** "I want to add comprehensive user authentication"
```bash
/plan user-authentication-system
```
**Result:** Complete feature plan with security analysis, implementation phases, testing strategy, and integration requirements.

### `/design` - System Architecture Excellence 🏗️
**Perfect for:**
- ✅ New products or platforms requiring market validation
- ✅ Complex systems with multiple integration points
- ✅ Business analysis and competitive research needed
- ✅ Comprehensive specifications for major initiatives

**What you get:**
- Market research and competitive analysis
- Business requirements and user research
- Complete technical specifications
- Implementation roadmap with phases
- Risk analysis and mitigation strategies
- Comprehensive documentation suite

**Process:**
1. Market research using MCP tools for current data
2. Competitive analysis and positioning
3. User research and persona development
4. Technical architecture and specifications
5. Implementation planning with quality focus
6. Comprehensive documentation creation

**Example:** "I want to build a new project management SaaS platform"
```bash
/design project-management-saas --research=deep
```
**Result:** Complete system design with market analysis, technical architecture, business plan, and implementation roadmap.

## Quality Standards (Universal)

Every command, regardless of scope, includes:
- **Time Awareness**: Current dates via MCP time tool
- **Research Integration**: MCP tools used where applicable for validation
- **Proper Citations**: All claims backed by verifiable sources
- **Framework Standards**: Consistent file organization and naming
- **Quality Gates**: Comprehensive validation checklists
- **Craftsman Philosophy**: Thoughtful, intentional approach to work

## Scope Selection Examples

### Single Component → `/add`
- "Create a testing agent"
- "Add a deployment command"
- "Make a template for technical specifications"
- "Create a database architect agent"

### Feature Development → `/plan`
- "Add user authentication with OAuth"
- "Enhance the search functionality with AI"
- "Integrate with third-party payment processing"
- "Implement real-time notification system"
- "Add comprehensive logging and monitoring"

### System Architecture → `/design`
- "Build a multi-tenant SaaS platform"
- "Create marketplace with vendor management"
- "Design AI-powered analytics platform"
- "Architecture for enterprise integration hub"
- "New business vertical with market validation"

## Common Misconceptions ❌

### "Simple" vs "Complex" Tasks
❌ **Wrong thinking:** "This is simple, so I'll get basic output"
✅ **Craftsman thinking:** "This has focused scope, but will be excellent quality"

### Quality Compromises
❌ **Wrong thinking:** "Quick and dirty for now, improve later"
✅ **Craftsman thinking:** "Right-sized scope with uncompromising quality"

### Process Overhead
❌ **Wrong thinking:** "All this process is too much for a simple component"
✅ **Craftsman thinking:** "Every component deserves craftsman attention"

## Integration Between Commands

Commands work together seamlessly:
- **Design → Plan:** Use `/plan` for specific features within designed systems
- **Plan → Add:** Use `/add` for components identified in feature plans
- **Add → Plan:** Scale up to `/plan` if component creation reveals broader needs

## The Craftsman Difference

Other frameworks might give you:
- Basic templates with minimal functionality
- "Good enough" outputs that need refinement
- Shortcuts that create technical debt
- Generic solutions without domain expertise

ClaudeCraftsman gives you:
- ✅ Craftsman-quality components from the start
- ✅ Full framework integration and standards
- ✅ Research-backed decisions and validation
- ✅ Documentation worthy of showcasing
- ✅ Components that enhance rather than compromise your codebase

## When in Doubt

1. **Start with scope assessment:** Single component, feature, or system?
2. **Choose appropriate command:** `/add`, `/plan`, or `/design`
3. **Trust the process:** Every command produces excellent results appropriate to its scope
4. **Scale as needed:** Commands work together - you can always expand scope later

## Common Workflows

### Complete Feature Development
```bash
# 1. Design the feature
/plan user-notifications

# 2. Implement with progress tracking
/implement user-notifications

# 3. Create comprehensive tests
/test user-notifications --bdd

# 4. Deploy with confidence
/deploy user-notifications
```

### Rapid Component Creation
```bash
# Need a new API endpoint?
/add agent api-endpoint-builder

# Need deployment automation?
/add command deploy-staging
```

## Troubleshooting Guide

### Common Issues

**"I don't know which command to use"**
- Single file/component? → `/add`
- Multiple components? → `/plan`
- Need research? → `/design`
- Have a plan? → `/implement`
- Need tests? → `/test`

**"The output seems too complex"**
- All outputs are comprehensive by design
- Focus on the sections you need
- Quality is non-negotiable, scope is adjustable

**"Implementation is stuck"**
```bash
# Check implementation status
/implement [plan] --status

# Resume from interruption
/implement [plan] --resume

# Debug specific phase
/implement [plan] --phase=2 --verbose
```

**"Tests are failing"**
```bash
# Update tests for code changes
/test [feature] --update

# Focus on specific test type
/test [feature] --type=unit

# Debug with Playwright
/test [feature] --playwright --debug
```

### MCP Tool Issues

**MCP tools not working?**
1. Ensure MCP servers are enabled in Claude Code
2. Check `mcp__time__get_current_time` works
3. Verify other MCP tools are accessible
4. Framework will gracefully degrade if MCP unavailable

**Research not returning results?**
- Use current dates in searches (2025, not 2024)
- Be specific with search queries
- Try alternative MCP tools if one fails

## Best Practices

### Start Small, Think Big
1. Use `/add` for exploration
2. Scale up to `/plan` when patterns emerge
3. Graduate to `/design` for major initiatives

### Leverage the Framework
- Let agents handle their specialties
- Trust the process and quality gates
- Use MCP tools for research validation
- Track progress with built-in tools

### Quality Over Speed
- Every command enforces craftsman standards
- Time estimates are for quality work
- Rushing compromises excellence

Remember: **Every piece of work that bears the ClaudeCraftsman signature should make us proud.** There are no shortcuts to quality, no compromises on craftsmanship - only different scopes of excellence.
