# ClaudeCraftsman Example Projects
*Learn by example with these craftsman-quality demonstrations*

## Overview

These examples demonstrate the ClaudeCraftsman framework in action. Each project showcases different aspects of the framework, from simple features to complex systems.

## Example Projects

### 1. Task Tracker (Simple)
**Location**: `task-tracker/`
**Demonstrates**:
- Basic `/plan` usage for feature development
- Single agent workflows
- Component creation with `/add`
- Testing with `/test` command

**Key Features**:
- Task CRUD operations
- Priority management
- Due date tracking
- Simple UI components

### 2. API Service (Medium)
**Location**: `api-service/`
**Demonstrates**:
- Backend-focused development
- API design with design-architect
- Database integration
- Testing strategies
- Deployment configuration

**Key Features**:
- RESTful API design
- Authentication system
- Database models
- API documentation

### 3. Full-Stack App (Complex)
**Location**: `full-stack-app/`
**Demonstrates**:
- Complete `/design` workflow
- Multi-agent coordination
- Frontend + backend integration
- Comprehensive testing
- Production deployment

**Key Features**:
- User authentication
- Real-time features
- Payment integration
- Admin dashboard
- Mobile responsive

## How to Use These Examples

### 1. Study the Structure
Each example includes:
- `CLAUDE.md` - Framework configuration
- `.claude/docs/` - Generated documentation
- Implementation files
- Test suites
- Deployment configs

### 2. Follow the Workflow
See how each project progressed:
1. Initial planning/design
2. Implementation phases
3. Testing approach
4. Deployment strategy

### 3. Run the Examples
```bash
# Copy an example to try
cp -r ~/.claude/claudecraftsman/examples/task-tracker ~/my-task-tracker
cd ~/my-task-tracker

# Continue development
/plan new-feature
/implement new-feature
```

## Learning Paths

### Beginner Path
1. Start with Task Tracker
2. Study the `/plan` workflow
3. See how `/add` creates components
4. Understand basic testing

### Intermediate Path
1. Explore API Service
2. Learn backend patterns
3. Study database design
4. Understand API testing

### Advanced Path
1. Dive into Full-Stack App
2. Study `/design` process
3. Learn multi-agent coordination
4. Master deployment strategies

## Key Takeaways

### 1. Always Start with Planning
- Use `/plan` for features
- Use `/design` for systems
- Let requirements drive architecture

### 2. Leverage Agent Expertise
- Each agent is a specialist
- Trust their recommendations
- Maintain quality standards

### 3. Test Comprehensively
- Unit tests for components
- Integration tests for APIs
- E2E tests for workflows
- Performance benchmarks

### 4. Deploy with Confidence
- Use deployment strategies
- Monitor everything
- Plan for rollback

## Creating Your Own Project

After studying these examples:

```bash
# Start your project
cd ~/projects/my-app
/init-craftsman my-app

# Design your system
/design my-app --research=deep

# Or plan a feature
/plan user-authentication

# Implement with confidence
/implement user-authentication
```

## Example Code Quality

Every example demonstrates:
- ✅ Craftsman quality code
- ✅ Comprehensive documentation
- ✅ Thorough testing
- ✅ Production-ready deployment
- ✅ Best practices throughout

## Questions?

- Check the example documentation
- Review the code comments
- Consult best-practices.md
- Run `/help` for guidance

---

*Learn from examples, then craft your own masterpiece.*
