# ClaudeCraftsman Examples Index
*Quick reference to all example projects*

## Example Projects

### 📋 Task Tracker (Beginner)
**Path**: `examples/task-tracker/`
**Commands Used**: `/plan`, `/implement`, `/add`, `/test`
**Time to Complete**: 1 week
**Key Files**:
- `CLAUDE.md` - Project configuration
- `PLAN-task-management-2025-08-04.md` - Feature plan
- Backend API implementation
- React components
- Test suites

**What You'll Learn**:
- Basic framework workflow
- Planning simple features
- Agent coordination
- Testing strategies

---

### 🔌 API Service (Intermediate)
**Path**: `examples/api-service/`
**Commands Used**: `/plan`, `/implement`, `/test`, `/deploy`
**Time to Complete**: 2 weeks
**Key Files**:
- RESTful API design
- Database schemas
- Authentication system
- API documentation
- Deployment configuration

**What You'll Learn**:
- Backend-focused development
- API design patterns
- Database architecture
- Security implementation
- Deployment strategies

---

### 🚀 Full-Stack E-Commerce (Advanced)
**Path**: `examples/full-stack-app/`
**Commands Used**: `/design`, `/workflow`, `/implement`, `/test`, `/deploy`
**Time to Complete**: 4 months
**Key Files**:
- `DESIGN-PROJECT-SUMMARY.md` - Complete design process
- PRD with market research
- Technical specifications
- Microservices architecture
- Complete implementation

**What You'll Learn**:
- Comprehensive system design
- Market research integration
- Multi-agent workflows
- Complex architecture
- Production deployment

---

## Quick Start with Examples

### 1. Browse an Example
```bash
cd ~/.claude/claudecraftsman/examples/task-tracker
cat CLAUDE.md
cat PLAN-task-management-2025-08-04.md
```

### 2. Copy to Your Workspace
```bash
cp -r ~/.claude/claudecraftsman/examples/task-tracker ~/my-task-app
cd ~/my-task-app
```

### 3. Continue Development
```bash
/plan new-feature
/implement new-feature
/test new-feature
```

## Example Patterns

### Planning Pattern
All examples show proper planning:
- Clear requirements
- Phased implementation
- Resource identification
- Success criteria

### Implementation Pattern
Consistent implementation approach:
- Agent-appropriate work
- Quality standards maintained
- Documentation generated
- Tests included

### Testing Pattern
Comprehensive testing strategy:
- Unit tests (>80% coverage)
- Integration tests
- E2E scenarios
- Performance benchmarks

## Creating Your Own Examples

After studying these examples, create your own:

```bash
# Start fresh
/init-craftsman my-project

# Plan or design
/plan my-feature          # For simple features
/design my-system        # For complex systems

# Implement with confidence
/implement my-feature

# Share your example
# Add to examples/ directory for others to learn from
```

## Key Takeaways

1. **Start Small**: Task Tracker shows you don't need complexity to use the framework effectively
2. **Scale Gradually**: API Service demonstrates growing complexity
3. **Go Big**: Full-Stack shows the framework handles enterprise-scale projects
4. **Quality Throughout**: Every example maintains craftsman standards

---

*Study these examples, then create your own masterpiece with ClaudeCraftsman.*
