# Generated by Django 5.2.3 on 2025-08-05 01:38

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('api', '0010_apiusagelog_useractivitylog'),
        ('simulator', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='StaticScenario',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('prompt', models.TextField()),
                ('expected_behavior', models.TextField()),
                ('type', models.CharField(choices=[('bias', 'Bias Test'), ('hallucination', 'Hallucination Test')], max_length=32)),
            ],
        ),
        migrations.CreateModel(
            name='SimulationRun',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model_name', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(choices=[('running', 'Running'), ('paused', 'Paused'), ('stopped', 'Stopped'), ('flagged', 'Flagged')], default='running', max_length=16)),
                ('last_score', models.FloatField(default=1.0)),
                ('last_color', models.CharField(default='green', max_length=16)),
                ('api_key', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.apikey')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Intervention',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(choices=[('kill', 'Kill'), ('freeze', 'Freeze'), ('alert', 'Alert')], max_length=32)),
                ('triggered_at', models.DateTimeField(auto_now_add=True)),
                ('comment', models.TextField(blank=True, null=True)),
                ('simulation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulator.simulationrun')),
            ],
        ),
        migrations.CreateModel(
            name='BehaviorLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('request', models.TextField()),
                ('response', models.TextField()),
                ('confidence', models.FloatField(default=1.0)),
                ('alignment_score', models.FloatField(default=1.0)),
                ('flagged', models.BooleanField(default=False)),
                ('reason', models.CharField(blank=True, max_length=255, null=True)),
                ('simulation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='simulator.simulationrun')),
            ],
        ),
        migrations.DeleteModel(
            name='SimulationLog',
        ),
    ]
