# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Certificate(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN of the certificate
    """
    certificate_body: pulumi.Output[str]
    """
    The certificate's PEM-formatted public key
    """
    certificate_chain: pulumi.Output[str]
    """
    The certificate's PEM-formatted chain
    """
    domain_name: pulumi.Output[str]
    """
    A domain name for which the certificate should be issued
    """
    domain_validation_options: pulumi.Output[list]
    """
    A list of attributes to feed into other resources to complete certificate validation. Can have more than one element, e.g. if SANs are defined. Only set if `DNS`-validation was used.
    """
    private_key: pulumi.Output[str]
    """
    The certificate's PEM-formatted private key
    """
    subject_alternative_names: pulumi.Output[list]
    """
    A list of domains that should be SANs in the issued certificate
    """
    tags: pulumi.Output[dict]
    """
    A mapping of tags to assign to the resource.
    """
    validation_emails: pulumi.Output[list]
    """
    A list of addresses that received a validation E-Mail. Only set if `EMAIL`-validation was used.
    """
    validation_method: pulumi.Output[str]
    """
    Which method to use for validation. `DNS` or `EMAIL` are valid, `NONE` can be used for certificates that were imported into ACM and then into Terraform.
    * Importing an existing certificate
    """
    def __init__(__self__, resource_name, opts=None, certificate_body=None, certificate_chain=None, domain_name=None, private_key=None, subject_alternative_names=None, tags=None, validation_method=None, __name__=None, __opts__=None):
        """
        The ACM certificate resource allows requesting and management of certificates
        from the Amazon Certificate Manager.
        
        It deals with requesting certificates and managing their attributes and life-cycle.
        This resource does not deal with validation of a certificate but can provide inputs
        for other resources implementing the validation. It does not wait for a certificate to be issued.
        Use a `aws_acm_certificate_validation` resource for this.
        
        Most commonly, this resource is used to together with `aws_route53_record` and
        `aws_acm_certificate_validation` to request a DNS validated certificate,
        deploy the required validation records and wait for validation to complete.
        
        Domain validation through E-Mail is also supported but should be avoided as it requires a manual step outside
        of Terraform.
        
        It's recommended to specify `create_before_destroy = true` in a [lifecycle][1] block to replace a certificate
        which is currently in use (eg, by `aws_lb_listener`).
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_body: The certificate's PEM-formatted public key
        :param pulumi.Input[str] certificate_chain: The certificate's PEM-formatted chain
        :param pulumi.Input[str] domain_name: A domain name for which the certificate should be issued
        :param pulumi.Input[str] private_key: The certificate's PEM-formatted private key
        :param pulumi.Input[list] subject_alternative_names: A list of domains that should be SANs in the issued certificate
        :param pulumi.Input[dict] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] validation_method: Which method to use for validation. `DNS` or `EMAIL` are valid, `NONE` can be used for certificates that were imported into ACM and then into Terraform.
               * Importing an existing certificate
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['certificate_body'] = certificate_body

        __props__['certificate_chain'] = certificate_chain

        __props__['domain_name'] = domain_name

        __props__['private_key'] = private_key

        __props__['subject_alternative_names'] = subject_alternative_names

        __props__['tags'] = tags

        __props__['validation_method'] = validation_method

        __props__['arn'] = None
        __props__['domain_validation_options'] = None
        __props__['validation_emails'] = None

        super(Certificate, __self__).__init__(
            'aws:acm/certificate:Certificate',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

