# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class CertificateAuthority(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    Amazon Resource Name (ARN) of the certificate authority.
    """
    certificate: pulumi.Output[str]
    """
    Base64-encoded certificate authority (CA) certificate. Only available after the certificate authority certificate has been imported.
    """
    certificate_authority_configuration: pulumi.Output[dict]
    """
    Nested argument containing algorithms and certificate subject information. Defined below.
    """
    certificate_chain: pulumi.Output[str]
    """
    Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. Only available after the certificate authority certificate has been imported.
    """
    certificate_signing_request: pulumi.Output[str]
    """
    The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
    """
    enabled: pulumi.Output[bool]
    """
    Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
    """
    not_after: pulumi.Output[str]
    """
    Date and time after which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
    """
    not_before: pulumi.Output[str]
    """
    Date and time before which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
    """
    permanent_deletion_time_in_days: pulumi.Output[float]
    """
    The number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
    """
    revocation_configuration: pulumi.Output[dict]
    """
    Nested argument containing revocation configuration. Defined below.
    """
    serial: pulumi.Output[str]
    """
    Serial number of the certificate authority. Only available after the certificate authority certificate has been imported.
    """
    status: pulumi.Output[str]
    """
    Status of the certificate authority.
    """
    tags: pulumi.Output[dict]
    """
    Specifies a key-value map of user-defined tags that are attached to the certificate authority.
    """
    type: pulumi.Output[str]
    """
    The type of the certificate authority. Currently, this must be `SUBORDINATE`.
    """
    def __init__(__self__, resource_name, opts=None, certificate_authority_configuration=None, enabled=None, permanent_deletion_time_in_days=None, revocation_configuration=None, tags=None, type=None, __name__=None, __opts__=None):
        """
        Provides a resource to manage AWS Certificate Manager Private Certificate Authorities (ACM PCA Certificate Authorities).
        
        > **NOTE:** Creating this resource will leave the certificate authority in a `PENDING_CERTIFICATE` status, which means it cannot yet issue certificates. To complete this setup, you must fully sign the certificate authority CSR available in the `certificate_signing_request` attribute and import the signed certificate outside of Terraform. Terraform can support another resource to manage that workflow automatically in the future.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] certificate_authority_configuration: Nested argument containing algorithms and certificate subject information. Defined below.
        :param pulumi.Input[bool] enabled: Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
        :param pulumi.Input[float] permanent_deletion_time_in_days: The number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
        :param pulumi.Input[dict] revocation_configuration: Nested argument containing revocation configuration. Defined below.
        :param pulumi.Input[dict] tags: Specifies a key-value map of user-defined tags that are attached to the certificate authority.
        :param pulumi.Input[str] type: The type of the certificate authority. Currently, this must be `SUBORDINATE`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if certificate_authority_configuration is None:
            raise TypeError("Missing required property 'certificate_authority_configuration'")
        __props__['certificate_authority_configuration'] = certificate_authority_configuration

        __props__['enabled'] = enabled

        __props__['permanent_deletion_time_in_days'] = permanent_deletion_time_in_days

        __props__['revocation_configuration'] = revocation_configuration

        __props__['tags'] = tags

        __props__['type'] = type

        __props__['arn'] = None
        __props__['certificate'] = None
        __props__['certificate_chain'] = None
        __props__['certificate_signing_request'] = None
        __props__['not_after'] = None
        __props__['not_before'] = None
        __props__['serial'] = None
        __props__['status'] = None

        super(CertificateAuthority, __self__).__init__(
            'aws:acmpca/certificateAuthority:CertificateAuthority',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

