# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class GraphQLApi(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN
    """
    authentication_type: pulumi.Output[str]
    """
    The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`
    """
    log_config: pulumi.Output[dict]
    """
    Nested argument containing logging configuration. Defined below.
    """
    name: pulumi.Output[str]
    """
    A user-supplied name for the GraphqlApi.
    """
    openid_connect_config: pulumi.Output[dict]
    """
    Nested argument containing OpenID Connect configuration. Defined below.
    """
    schema: pulumi.Output[str]
    """
    The schema definition, in GraphQL schema language format. Terraform cannot perform drift detection of this configuration.
    """
    uris: pulumi.Output[dict]
    """
    Map of URIs associated with the API. e.g. `uris["GRAPHQL"] = https://ID.appsync-api.REGION.amazonaws.com/graphql`
    """
    user_pool_config: pulumi.Output[dict]
    """
    The Amazon Cognito User Pool configuration. Defined below.
    """
    def __init__(__self__, resource_name, opts=None, authentication_type=None, log_config=None, name=None, openid_connect_config=None, schema=None, user_pool_config=None, __name__=None, __opts__=None):
        """
        Provides an AppSync GraphQL API.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_type: The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`
        :param pulumi.Input[dict] log_config: Nested argument containing logging configuration. Defined below.
        :param pulumi.Input[str] name: A user-supplied name for the GraphqlApi.
        :param pulumi.Input[dict] openid_connect_config: Nested argument containing OpenID Connect configuration. Defined below.
        :param pulumi.Input[str] schema: The schema definition, in GraphQL schema language format. Terraform cannot perform drift detection of this configuration.
        :param pulumi.Input[dict] user_pool_config: The Amazon Cognito User Pool configuration. Defined below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if authentication_type is None:
            raise TypeError("Missing required property 'authentication_type'")
        __props__['authentication_type'] = authentication_type

        __props__['log_config'] = log_config

        __props__['name'] = name

        __props__['openid_connect_config'] = openid_connect_config

        __props__['schema'] = schema

        __props__['user_pool_config'] = user_pool_config

        __props__['arn'] = None
        __props__['uris'] = None

        super(GraphQLApi, __self__).__init__(
            'aws:appsync/graphQLApi:GraphQLApi',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

