# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Plan(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN of the backup plan.
    """
    name: pulumi.Output[str]
    """
    The display name of a backup plan.
    """
    rules: pulumi.Output[list]
    """
    A rule object that specifies a scheduled task that is used to back up a selection of resources.
    """
    tags: pulumi.Output[dict]
    """
    Metadata that you can assign to help organize the plans you create.
    """
    version: pulumi.Output[str]
    """
    Unique, randomly generated, Unicode, UTF-8 encoded string that serves as the version ID of the backup plan. 
    """
    def __init__(__self__, resource_name, opts=None, name=None, rules=None, tags=None, __name__=None, __opts__=None):
        """
        Provides an AWS Backup plan resource.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The display name of a backup plan.
        :param pulumi.Input[list] rules: A rule object that specifies a scheduled task that is used to back up a selection of resources.
        :param pulumi.Input[dict] tags: Metadata that you can assign to help organize the plans you create.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['name'] = name

        if rules is None:
            raise TypeError("Missing required property 'rules'")
        __props__['rules'] = rules

        __props__['tags'] = tags

        __props__['arn'] = None
        __props__['version'] = None

        super(Plan, __self__).__init__(
            'aws:backup/plan:Plan',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

