# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Vault(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN of the vault.
    """
    kms_key_arn: pulumi.Output[str]
    """
    The server-side encryption key that is used to protect your backups.
    """
    name: pulumi.Output[str]
    """
    Name of the backup vault to create.
    """
    recovery_points: pulumi.Output[float]
    """
    The number of recovery points that are stored in a backup vault.
    """
    tags: pulumi.Output[dict]
    """
    Metadata that you can assign to help organize the resources that you create.
    """
    def __init__(__self__, resource_name, opts=None, kms_key_arn=None, name=None, tags=None, __name__=None, __opts__=None):
        """
        Provides an AWS Backup vault resource.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] kms_key_arn: The server-side encryption key that is used to protect your backups.
        :param pulumi.Input[str] name: Name of the backup vault to create.
        :param pulumi.Input[dict] tags: Metadata that you can assign to help organize the resources that you create.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['kms_key_arn'] = kms_key_arn

        __props__['name'] = name

        __props__['tags'] = tags

        __props__['arn'] = None
        __props__['recovery_points'] = None

        super(Vault, __self__).__init__(
            'aws:backup/vault:Vault',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

