# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Hsm(pulumi.CustomResource):
    availability_zone: pulumi.Output[str]
    """
    The IDs of AZ in which HSM module will be located. Do not use together with subnet_id.
    """
    cluster_id: pulumi.Output[str]
    """
    The ID of Cloud HSM v2 cluster to which HSM will be added.
    """
    hsm_eni_id: pulumi.Output[str]
    """
    The id of the ENI interface allocated for HSM module.
    """
    hsm_id: pulumi.Output[str]
    """
    The id of the HSM module.
    """
    hsm_state: pulumi.Output[str]
    """
    The state of the HSM module.
    """
    ip_address: pulumi.Output[str]
    """
    The IP address of HSM module. Must be within the CIDR of selected subnet.
    """
    subnet_id: pulumi.Output[str]
    """
    The ID of subnet in which HSM module will be located.
    """
    def __init__(__self__, resource_name, opts=None, availability_zone=None, cluster_id=None, ip_address=None, subnet_id=None, __name__=None, __opts__=None):
        """
        Creates an HSM module in Amazon CloudHSM v2 cluster.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The IDs of AZ in which HSM module will be located. Do not use together with subnet_id.
        :param pulumi.Input[str] cluster_id: The ID of Cloud HSM v2 cluster to which HSM will be added.
        :param pulumi.Input[str] ip_address: The IP address of HSM module. Must be within the CIDR of selected subnet.
        :param pulumi.Input[str] subnet_id: The ID of subnet in which HSM module will be located.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['availability_zone'] = availability_zone

        if cluster_id is None:
            raise TypeError("Missing required property 'cluster_id'")
        __props__['cluster_id'] = cluster_id

        __props__['ip_address'] = ip_address

        __props__['subnet_id'] = subnet_id

        __props__['hsm_eni_id'] = None
        __props__['hsm_id'] = None
        __props__['hsm_state'] = None

        super(Hsm, __self__).__init__(
            'aws:cloudhsmv2/hsm:Hsm',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

