# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Dashboard(pulumi.CustomResource):
    dashboard_arn: pulumi.Output[str]
    """
    The Amazon Resource Name (ARN) of the dashboard.
    """
    dashboard_body: pulumi.Output[str]
    """
    The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
    """
    dashboard_name: pulumi.Output[str]
    """
    The name of the dashboard.
    """
    def __init__(__self__, resource_name, opts=None, dashboard_body=None, dashboard_name=None, __name__=None, __opts__=None):
        """
        Provides a CloudWatch Dashboard resource.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dashboard_body: The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
        :param pulumi.Input[str] dashboard_name: The name of the dashboard.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if dashboard_body is None:
            raise TypeError("Missing required property 'dashboard_body'")
        __props__['dashboard_body'] = dashboard_body

        if dashboard_name is None:
            raise TypeError("Missing required property 'dashboard_name'")
        __props__['dashboard_name'] = dashboard_name

        __props__['dashboard_arn'] = None

        super(Dashboard, __self__).__init__(
            'aws:cloudwatch/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

