# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Repository(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN of the repository
    """
    clone_url_http: pulumi.Output[str]
    """
    The URL to use for cloning the repository over HTTPS.
    """
    clone_url_ssh: pulumi.Output[str]
    """
    The URL to use for cloning the repository over SSH.
    """
    default_branch: pulumi.Output[str]
    """
    The default branch of the repository. The branch specified here needs to exist.
    """
    description: pulumi.Output[str]
    """
    The description of the repository. This needs to be less than 1000 characters
    """
    repository_id: pulumi.Output[str]
    """
    The ID of the repository
    """
    repository_name: pulumi.Output[str]
    """
    The name for the repository. This needs to be less than 100 characters.
    """
    def __init__(__self__, resource_name, opts=None, default_branch=None, description=None, repository_name=None, __name__=None, __opts__=None):
        """
        Provides a CodeCommit Repository Resource.
        
        > **NOTE on CodeCommit Availability**: The CodeCommit is not yet rolled out
        in all regions - available regions are listed
        [the AWS Docs](https://docs.aws.amazon.com/general/latest/gr/rande.html#codecommit_region).
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_branch: The default branch of the repository. The branch specified here needs to exist.
        :param pulumi.Input[str] description: The description of the repository. This needs to be less than 1000 characters
        :param pulumi.Input[str] repository_name: The name for the repository. This needs to be less than 100 characters.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['default_branch'] = default_branch

        __props__['description'] = description

        if repository_name is None:
            raise TypeError("Missing required property 'repository_name'")
        __props__['repository_name'] = repository_name

        __props__['arn'] = None
        __props__['clone_url_http'] = None
        __props__['clone_url_ssh'] = None
        __props__['repository_id'] = None

        super(Repository, __self__).__init__(
            'aws:codecommit/repository:Repository',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

