# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class IdentityPool(pulumi.CustomResource):
    allow_unauthenticated_identities: pulumi.Output[bool]
    """
    Whether the identity pool supports unauthenticated logins or not.
    """
    arn: pulumi.Output[str]
    """
    The ARN of the identity pool.
    """
    cognito_identity_providers: pulumi.Output[list]
    """
    An array of Amazon Cognito Identity user pools and their client IDs.
    """
    developer_provider_name: pulumi.Output[str]
    """
    The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your
    backend and the Cognito service to communicate about the developer provider.
    """
    identity_pool_name: pulumi.Output[str]
    """
    The Cognito Identity Pool name.
    """
    openid_connect_provider_arns: pulumi.Output[list]
    """
    A list of OpendID Connect provider ARNs.
    """
    saml_provider_arns: pulumi.Output[list]
    """
    An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
    """
    supported_login_providers: pulumi.Output[dict]
    """
    Key-Value pairs mapping provider names to provider app IDs.
    """
    def __init__(__self__, resource_name, opts=None, allow_unauthenticated_identities=None, cognito_identity_providers=None, developer_provider_name=None, identity_pool_name=None, openid_connect_provider_arns=None, saml_provider_arns=None, supported_login_providers=None, __name__=None, __opts__=None):
        """
        Provides an AWS Cognito Identity Pool.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_unauthenticated_identities: Whether the identity pool supports unauthenticated logins or not.
        :param pulumi.Input[list] cognito_identity_providers: An array of Amazon Cognito Identity user pools and their client IDs.
        :param pulumi.Input[str] developer_provider_name: The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your
               backend and the Cognito service to communicate about the developer provider.
        :param pulumi.Input[str] identity_pool_name: The Cognito Identity Pool name.
        :param pulumi.Input[list] openid_connect_provider_arns: A list of OpendID Connect provider ARNs.
        :param pulumi.Input[list] saml_provider_arns: An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
        :param pulumi.Input[dict] supported_login_providers: Key-Value pairs mapping provider names to provider app IDs.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['allow_unauthenticated_identities'] = allow_unauthenticated_identities

        __props__['cognito_identity_providers'] = cognito_identity_providers

        __props__['developer_provider_name'] = developer_provider_name

        if identity_pool_name is None:
            raise TypeError("Missing required property 'identity_pool_name'")
        __props__['identity_pool_name'] = identity_pool_name

        __props__['openid_connect_provider_arns'] = openid_connect_provider_arns

        __props__['saml_provider_arns'] = saml_provider_arns

        __props__['supported_login_providers'] = supported_login_providers

        __props__['arn'] = None

        super(IdentityPool, __self__).__init__(
            'aws:cognito/identityPool:IdentityPool',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

