# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Ami(pulumi.CustomResource):
    architecture: pulumi.Output[str]
    """
    Machine architecture for created instances. Defaults to "x86_64".
    """
    description: pulumi.Output[str]
    """
    A longer, human-readable description for the AMI.
    """
    ebs_block_devices: pulumi.Output[list]
    """
    Nested block describing an EBS block device that should be
    attached to created instances. The structure of this block is described below.
    """
    ena_support: pulumi.Output[bool]
    """
    Specifies whether enhanced networking with ENA is enabled. Defaults to `false`.
    """
    ephemeral_block_devices: pulumi.Output[list]
    """
    Nested block describing an ephemeral block device that
    should be attached to created instances. The structure of this block is described below.
    """
    image_location: pulumi.Output[str]
    """
    Path to an S3 object containing an image manifest, e.g. created
    by the `ec2-upload-bundle` command in the EC2 command line tools.
    """
    kernel_id: pulumi.Output[str]
    """
    The id of the kernel image (AKI) that will be used as the paravirtual
    kernel in created instances.
    """
    manage_ebs_snapshots: pulumi.Output[bool]
    name: pulumi.Output[str]
    """
    A region-unique name for the AMI.
    """
    ramdisk_id: pulumi.Output[str]
    """
    The id of an initrd image (ARI) that will be used when booting the
    created instances.
    """
    root_device_name: pulumi.Output[str]
    """
    The name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
    """
    root_snapshot_id: pulumi.Output[str]
    """
    The Snapshot ID for the root volume (for EBS-backed AMIs)
    """
    sriov_net_support: pulumi.Output[str]
    """
    When set to "simple" (the default), enables enhanced networking
    for created instances. No other value is supported at this time.
    """
    tags: pulumi.Output[dict]
    """
    A mapping of tags to assign to the resource.
    """
    virtualization_type: pulumi.Output[str]
    """
    Keyword to choose what virtualization mode created instances
    will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
    changes the set of further arguments that are required, as described below.
    """
    def __init__(__self__, resource_name, opts=None, architecture=None, description=None, ebs_block_devices=None, ena_support=None, ephemeral_block_devices=None, image_location=None, kernel_id=None, name=None, ramdisk_id=None, root_device_name=None, sriov_net_support=None, tags=None, virtualization_type=None, __name__=None, __opts__=None):
        """
        The AMI resource allows the creation and management of a completely-custom
        *Amazon Machine Image* (AMI).
        
        If you just want to duplicate an existing AMI, possibly copying it to another
        region, it's better to use `aws_ami_copy` instead.
        
        If you just want to share an existing AMI with another AWS account,
        it's better to use `aws_ami_launch_permission` instead.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] architecture: Machine architecture for created instances. Defaults to "x86_64".
        :param pulumi.Input[str] description: A longer, human-readable description for the AMI.
        :param pulumi.Input[list] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[bool] ena_support: Specifies whether enhanced networking with ENA is enabled. Defaults to `false`.
        :param pulumi.Input[list] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[str] image_location: Path to an S3 object containing an image manifest, e.g. created
               by the `ec2-upload-bundle` command in the EC2 command line tools.
        :param pulumi.Input[str] kernel_id: The id of the kernel image (AKI) that will be used as the paravirtual
               kernel in created instances.
        :param pulumi.Input[str] name: A region-unique name for the AMI.
        :param pulumi.Input[str] ramdisk_id: The id of an initrd image (ARI) that will be used when booting the
               created instances.
        :param pulumi.Input[str] root_device_name: The name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
        :param pulumi.Input[str] sriov_net_support: When set to "simple" (the default), enables enhanced networking
               for created instances. No other value is supported at this time.
        :param pulumi.Input[dict] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] virtualization_type: Keyword to choose what virtualization mode created instances
               will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
               changes the set of further arguments that are required, as described below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['architecture'] = architecture

        __props__['description'] = description

        __props__['ebs_block_devices'] = ebs_block_devices

        __props__['ena_support'] = ena_support

        __props__['ephemeral_block_devices'] = ephemeral_block_devices

        __props__['image_location'] = image_location

        __props__['kernel_id'] = kernel_id

        __props__['name'] = name

        __props__['ramdisk_id'] = ramdisk_id

        __props__['root_device_name'] = root_device_name

        __props__['sriov_net_support'] = sriov_net_support

        __props__['tags'] = tags

        __props__['virtualization_type'] = virtualization_type

        __props__['manage_ebs_snapshots'] = None
        __props__['root_snapshot_id'] = None

        super(Ami, __self__).__init__(
            'aws:ec2/ami:Ami',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

