# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class AmiCopy(pulumi.CustomResource):
    architecture: pulumi.Output[str]
    """
    Machine architecture for created instances. Defaults to "x86_64".
    """
    description: pulumi.Output[str]
    """
    A longer, human-readable description for the AMI.
    """
    ebs_block_devices: pulumi.Output[list]
    """
    Nested block describing an EBS block device that should be
    attached to created instances. The structure of this block is described below.
    """
    ena_support: pulumi.Output[bool]
    """
    Specifies whether enhanced networking with ENA is enabled. Defaults to `false`.
    """
    encrypted: pulumi.Output[bool]
    """
    Specifies whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
    """
    ephemeral_block_devices: pulumi.Output[list]
    """
    Nested block describing an ephemeral block device that
    should be attached to created instances. The structure of this block is described below.
    """
    image_location: pulumi.Output[str]
    """
    Path to an S3 object containing an image manifest, e.g. created
    by the `ec2-upload-bundle` command in the EC2 command line tools.
    """
    kernel_id: pulumi.Output[str]
    """
    The id of the kernel image (AKI) that will be used as the paravirtual
    kernel in created instances.
    """
    kms_key_id: pulumi.Output[str]
    """
    The full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
    """
    manage_ebs_snapshots: pulumi.Output[bool]
    name: pulumi.Output[str]
    """
    A region-unique name for the AMI.
    """
    ramdisk_id: pulumi.Output[str]
    """
    The id of an initrd image (ARI) that will be used when booting the
    created instances.
    """
    root_device_name: pulumi.Output[str]
    """
    The name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
    """
    root_snapshot_id: pulumi.Output[str]
    source_ami_id: pulumi.Output[str]
    """
    The id of the AMI to copy. This id must be valid in the region
    given by `source_ami_region`.
    """
    source_ami_region: pulumi.Output[str]
    """
    The region from which the AMI will be copied. This may be the
    same as the AWS provider region in order to create a copy within the same region.
    """
    sriov_net_support: pulumi.Output[str]
    """
    When set to "simple" (the default), enables enhanced networking
    for created instances. No other value is supported at this time.
    """
    tags: pulumi.Output[dict]
    """
    A mapping of tags to assign to the resource.
    """
    virtualization_type: pulumi.Output[str]
    """
    Keyword to choose what virtualization mode created instances
    will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
    changes the set of further arguments that are required, as described below.
    """
    def __init__(__self__, resource_name, opts=None, description=None, ebs_block_devices=None, encrypted=None, ephemeral_block_devices=None, kms_key_id=None, name=None, source_ami_id=None, source_ami_region=None, tags=None, __name__=None, __opts__=None):
        """
        The "AMI copy" resource allows duplication of an Amazon Machine Image (AMI),
        including cross-region copies.
        
        If the source AMI has associated EBS snapshots, those will also be duplicated
        along with the AMI.
        
        This is useful for taking a single AMI provisioned in one region and making
        it available in another for a multi-region deployment.
        
        Copying an AMI can take several minutes. The creation of this resource will
        block until the new AMI is available for use on new instances.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A longer, human-readable description for the AMI.
        :param pulumi.Input[list] ebs_block_devices: Nested block describing an EBS block device that should be
               attached to created instances. The structure of this block is described below.
        :param pulumi.Input[bool] encrypted: Specifies whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
        :param pulumi.Input[list] ephemeral_block_devices: Nested block describing an ephemeral block device that
               should be attached to created instances. The structure of this block is described below.
        :param pulumi.Input[str] kms_key_id: The full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
        :param pulumi.Input[str] name: A region-unique name for the AMI.
        :param pulumi.Input[str] source_ami_id: The id of the AMI to copy. This id must be valid in the region
               given by `source_ami_region`.
        :param pulumi.Input[str] source_ami_region: The region from which the AMI will be copied. This may be the
               same as the AWS provider region in order to create a copy within the same region.
        :param pulumi.Input[dict] tags: A mapping of tags to assign to the resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['description'] = description

        __props__['ebs_block_devices'] = ebs_block_devices

        __props__['encrypted'] = encrypted

        __props__['ephemeral_block_devices'] = ephemeral_block_devices

        __props__['kms_key_id'] = kms_key_id

        __props__['name'] = name

        if source_ami_id is None:
            raise TypeError("Missing required property 'source_ami_id'")
        __props__['source_ami_id'] = source_ami_id

        if source_ami_region is None:
            raise TypeError("Missing required property 'source_ami_region'")
        __props__['source_ami_region'] = source_ami_region

        __props__['tags'] = tags

        __props__['architecture'] = None
        __props__['ena_support'] = None
        __props__['image_location'] = None
        __props__['kernel_id'] = None
        __props__['manage_ebs_snapshots'] = None
        __props__['ramdisk_id'] = None
        __props__['root_device_name'] = None
        __props__['root_snapshot_id'] = None
        __props__['sriov_net_support'] = None
        __props__['virtualization_type'] = None

        super(AmiCopy, __self__).__init__(
            'aws:ec2/amiCopy:AmiCopy',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

