# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class SpotFleetRequest(pulumi.CustomResource):
    allocation_strategy: pulumi.Output[str]
    """
    Indicates how to allocate the target capacity across
    the Spot pools specified by the Spot fleet request. The default is
    `lowestPrice`.
    """
    client_token: pulumi.Output[str]
    excess_capacity_termination_policy: pulumi.Output[str]
    """
    Indicates whether running Spot
    instances should be terminated if the target capacity of the Spot fleet
    request is decreased below the current size of the Spot fleet.
    """
    fleet_type: pulumi.Output[str]
    """
    The type of fleet request. Indicates whether the Spot Fleet only requests the target
    capacity or also attempts to maintain it. Default is `maintain`.
    """
    iam_fleet_role: pulumi.Output[str]
    """
    Grants the Spot fleet permission to terminate
    Spot instances on your behalf when you cancel its Spot fleet request using
    CancelSpotFleetRequests or when the Spot fleet request expires, if you set
    terminateInstancesWithExpiration.
    """
    instance_interruption_behaviour: pulumi.Output[str]
    """
    Indicates whether a Spot
    instance stops or terminates when it is interrupted. Default is
    `terminate`.
    """
    instance_pools_to_use_count: pulumi.Output[float]
    """
    
    The number of Spot pools across which to allocate your target Spot capacity.
    Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
    the cheapest Spot pools and evenly allocates your target Spot capacity across
    the number of Spot pools that you specify.
    """
    launch_specifications: pulumi.Output[list]
    """
    Used to define the launch configuration of the
    spot-fleet request. Can be specified multiple times to define different bids
    across different markets and instance types.
    """
    load_balancers: pulumi.Output[list]
    """
    A list of elastic load balancer names to add to the Spot fleet.
    """
    replace_unhealthy_instances: pulumi.Output[bool]
    """
    Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
    """
    spot_price: pulumi.Output[str]
    """
    The maximum bid price per unit hour.
    """
    spot_request_state: pulumi.Output[str]
    """
    The state of the Spot fleet request.
    """
    target_capacity: pulumi.Output[float]
    """
    The number of units to request. You can choose to set the
    target capacity in terms of instances or a performance characteristic that is
    important to your application workload, such as vCPUs, memory, or I/O.
    """
    target_group_arns: pulumi.Output[list]
    """
    A list of `aws_alb_target_group` ARNs, for use with Application Load Balancing.
    """
    terminate_instances_with_expiration: pulumi.Output[bool]
    """
    Indicates whether running Spot
    instances should be terminated when the Spot fleet request expires.
    """
    valid_from: pulumi.Output[str]
    """
    The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
    """
    valid_until: pulumi.Output[str]
    """
    The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. Defaults to 24 hours.
    """
    wait_for_fulfillment: pulumi.Output[bool]
    """
    If set, Terraform will
    wait for the Spot Request to be fulfilled, and will throw an error if the
    timeout of 10m is reached.
    """
    def __init__(__self__, resource_name, opts=None, allocation_strategy=None, excess_capacity_termination_policy=None, fleet_type=None, iam_fleet_role=None, instance_interruption_behaviour=None, instance_pools_to_use_count=None, launch_specifications=None, load_balancers=None, replace_unhealthy_instances=None, spot_price=None, target_capacity=None, target_group_arns=None, terminate_instances_with_expiration=None, valid_from=None, valid_until=None, wait_for_fulfillment=None, __name__=None, __opts__=None):
        """
        Provides an EC2 Spot Fleet Request resource. This allows a fleet of Spot
        instances to be requested on the Spot market.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allocation_strategy: Indicates how to allocate the target capacity across
               the Spot pools specified by the Spot fleet request. The default is
               `lowestPrice`.
        :param pulumi.Input[str] excess_capacity_termination_policy: Indicates whether running Spot
               instances should be terminated if the target capacity of the Spot fleet
               request is decreased below the current size of the Spot fleet.
        :param pulumi.Input[str] fleet_type: The type of fleet request. Indicates whether the Spot Fleet only requests the target
               capacity or also attempts to maintain it. Default is `maintain`.
        :param pulumi.Input[str] iam_fleet_role: Grants the Spot fleet permission to terminate
               Spot instances on your behalf when you cancel its Spot fleet request using
               CancelSpotFleetRequests or when the Spot fleet request expires, if you set
               terminateInstancesWithExpiration.
        :param pulumi.Input[str] instance_interruption_behaviour: Indicates whether a Spot
               instance stops or terminates when it is interrupted. Default is
               `terminate`.
        :param pulumi.Input[float] instance_pools_to_use_count: 
               The number of Spot pools across which to allocate your target Spot capacity.
               Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
               the cheapest Spot pools and evenly allocates your target Spot capacity across
               the number of Spot pools that you specify.
        :param pulumi.Input[list] launch_specifications: Used to define the launch configuration of the
               spot-fleet request. Can be specified multiple times to define different bids
               across different markets and instance types.
        :param pulumi.Input[list] load_balancers: A list of elastic load balancer names to add to the Spot fleet.
        :param pulumi.Input[bool] replace_unhealthy_instances: Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        :param pulumi.Input[str] spot_price: The maximum bid price per unit hour.
        :param pulumi.Input[float] target_capacity: The number of units to request. You can choose to set the
               target capacity in terms of instances or a performance characteristic that is
               important to your application workload, such as vCPUs, memory, or I/O.
        :param pulumi.Input[list] target_group_arns: A list of `aws_alb_target_group` ARNs, for use with Application Load Balancing.
        :param pulumi.Input[bool] terminate_instances_with_expiration: Indicates whether running Spot
               instances should be terminated when the Spot fleet request expires.
        :param pulumi.Input[str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request. Defaults to 24 hours.
        :param pulumi.Input[bool] wait_for_fulfillment: If set, Terraform will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['allocation_strategy'] = allocation_strategy

        __props__['excess_capacity_termination_policy'] = excess_capacity_termination_policy

        __props__['fleet_type'] = fleet_type

        if iam_fleet_role is None:
            raise TypeError("Missing required property 'iam_fleet_role'")
        __props__['iam_fleet_role'] = iam_fleet_role

        __props__['instance_interruption_behaviour'] = instance_interruption_behaviour

        __props__['instance_pools_to_use_count'] = instance_pools_to_use_count

        if launch_specifications is None:
            raise TypeError("Missing required property 'launch_specifications'")
        __props__['launch_specifications'] = launch_specifications

        __props__['load_balancers'] = load_balancers

        __props__['replace_unhealthy_instances'] = replace_unhealthy_instances

        __props__['spot_price'] = spot_price

        if target_capacity is None:
            raise TypeError("Missing required property 'target_capacity'")
        __props__['target_capacity'] = target_capacity

        __props__['target_group_arns'] = target_group_arns

        __props__['terminate_instances_with_expiration'] = terminate_instances_with_expiration

        __props__['valid_from'] = valid_from

        __props__['valid_until'] = valid_until

        __props__['wait_for_fulfillment'] = wait_for_fulfillment

        __props__['client_token'] = None
        __props__['spot_request_state'] = None

        super(SpotFleetRequest, __self__).__init__(
            'aws:ec2/spotFleetRequest:SpotFleetRequest',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

