# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class VpcAttachment(pulumi.CustomResource):
    dns_support: pulumi.Output[str]
    """
    Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
    """
    ipv6_support: pulumi.Output[str]
    """
    Whether IPv6 support is enabled. Valid values: `disable`, `enable`. Default value: `disable`.
    """
    subnet_ids: pulumi.Output[list]
    """
    Identifiers of EC2 Subnets.
    """
    tags: pulumi.Output[dict]
    """
    Key-value tags for the EC2 Transit Gateway VPC Attachment.
    """
    transit_gateway_default_route_table_association: pulumi.Output[bool]
    """
    Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
    """
    transit_gateway_default_route_table_propagation: pulumi.Output[bool]
    """
    Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
    """
    transit_gateway_id: pulumi.Output[str]
    """
    Identifier of EC2 Transit Gateway.
    """
    vpc_id: pulumi.Output[str]
    """
    Identifier of EC2 VPC.
    """
    vpc_owner_id: pulumi.Output[str]
    """
    Identifier of the AWS account that owns the EC2 VPC.
    """
    def __init__(__self__, resource_name, opts=None, dns_support=None, ipv6_support=None, subnet_ids=None, tags=None, transit_gateway_default_route_table_association=None, transit_gateway_default_route_table_propagation=None, transit_gateway_id=None, vpc_id=None, __name__=None, __opts__=None):
        """
        Manages an EC2 Transit Gateway VPC Attachment. For examples of custom route table association and propagation, see the EC2 Transit Gateway Networking Examples Guide.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dns_support: Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
        :param pulumi.Input[str] ipv6_support: Whether IPv6 support is enabled. Valid values: `disable`, `enable`. Default value: `disable`.
        :param pulumi.Input[list] subnet_ids: Identifiers of EC2 Subnets.
        :param pulumi.Input[dict] tags: Key-value tags for the EC2 Transit Gateway VPC Attachment.
        :param pulumi.Input[bool] transit_gateway_default_route_table_association: Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
        :param pulumi.Input[bool] transit_gateway_default_route_table_propagation: Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
        :param pulumi.Input[str] transit_gateway_id: Identifier of EC2 Transit Gateway.
        :param pulumi.Input[str] vpc_id: Identifier of EC2 VPC.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['dns_support'] = dns_support

        __props__['ipv6_support'] = ipv6_support

        if subnet_ids is None:
            raise TypeError("Missing required property 'subnet_ids'")
        __props__['subnet_ids'] = subnet_ids

        __props__['tags'] = tags

        __props__['transit_gateway_default_route_table_association'] = transit_gateway_default_route_table_association

        __props__['transit_gateway_default_route_table_propagation'] = transit_gateway_default_route_table_propagation

        if transit_gateway_id is None:
            raise TypeError("Missing required property 'transit_gateway_id'")
        __props__['transit_gateway_id'] = transit_gateway_id

        if vpc_id is None:
            raise TypeError("Missing required property 'vpc_id'")
        __props__['vpc_id'] = vpc_id

        __props__['vpc_owner_id'] = None

        super(VpcAttachment, __self__).__init__(
            'aws:ec2transitgateway/vpcAttachment:VpcAttachment',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

