# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Environment(pulumi.CustomResource):
    all_settings: pulumi.Output[list]
    """
    List of all option settings configured in the Environment. These
    are a combination of default settings and their overrides from `setting` in
    the configuration.
    """
    application: pulumi.Output[str]
    """
    Name of the application that contains the version
    to be deployed
    """
    arn: pulumi.Output[str]
    autoscaling_groups: pulumi.Output[list]
    """
    The autoscaling groups used by this environment.
    """
    cname: pulumi.Output[str]
    """
    Fully qualified DNS name for the Environment.
    """
    cname_prefix: pulumi.Output[str]
    """
    Prefix to use for the fully qualified DNS name of
    the Environment.
    """
    description: pulumi.Output[str]
    """
    Short description of the Environment
    """
    instances: pulumi.Output[list]
    """
    Instances used by this environment.
    """
    launch_configurations: pulumi.Output[list]
    """
    Launch configurations in use by this environment.
    """
    load_balancers: pulumi.Output[list]
    """
    Elastic load balancers in use by this environment.
    """
    name: pulumi.Output[str]
    """
    A unique name for this Environment. This name is used
    in the application URL
    """
    platform_arn: pulumi.Output[str]
    """
    The [ARN][2] of the Elastic Beanstalk [Platform][3]
    to use in deployment
    """
    poll_interval: pulumi.Output[str]
    """
    The time between polling the AWS API to
    check if changes have been applied. Use this to adjust the rate of API calls
    for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
    use the default behavior, which is an exponential backoff
    """
    queues: pulumi.Output[list]
    """
    SQS queues in use by this environment.
    """
    settings: pulumi.Output[list]
    """
    Option settings to configure the new Environment. These
    override specific values that are set as defaults. The format is detailed
    below in Option Settings
    """
    solution_stack_name: pulumi.Output[str]
    """
    A solution stack to base your environment
    off of. Example stacks can be found in the [Amazon API documentation][1]
    """
    tags: pulumi.Output[dict]
    """
    A set of tags to apply to the Environment.
    """
    template_name: pulumi.Output[str]
    """
    The name of the Elastic Beanstalk Configuration
    template to use in deployment
    """
    tier: pulumi.Output[str]
    """
    Elastic Beanstalk Environment tier. Valid values are `Worker`
    or `WebServer`. If tier is left blank `WebServer` will be used.
    """
    triggers: pulumi.Output[list]
    """
    Autoscaling triggers in use by this environment.
    """
    version: pulumi.Output[str]
    """
    The name of the Elastic Beanstalk Application Version
    to use in deployment.
    """
    wait_for_ready_timeout: pulumi.Output[str]
    """
    The maximum
    [duration](https://golang.org/pkg/time/#ParseDuration) that Terraform should
    wait for an Elastic Beanstalk Environment to be in a ready state before timing
    out.
    """
    def __init__(__self__, resource_name, opts=None, application=None, cname_prefix=None, description=None, name=None, platform_arn=None, poll_interval=None, settings=None, solution_stack_name=None, tags=None, template_name=None, tier=None, version=None, wait_for_ready_timeout=None, __name__=None, __opts__=None):
        """
        Provides an Elastic Beanstalk Environment Resource. Elastic Beanstalk allows
        you to deploy and manage applications in the AWS cloud without worrying about
        the infrastructure that runs those applications.
        
        Environments are often things such as `development`, `integration`, or
        `production`.
        
        ## Option Settings
        
        Some options can be stack-specific, check [AWS Docs](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html)
        for supported options and examples.
        
        The `setting` and `all_settings` mappings support the following format:
        
        * `namespace` - unique namespace identifying the option's associated AWS resource
        * `name` - name of the configuration option
        * `value` - value for the configuration option
        * `resource` - (Optional) resource name for [scheduled action](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-autoscalingscheduledaction)
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application: Name of the application that contains the version
               to be deployed
        :param pulumi.Input[str] cname_prefix: Prefix to use for the fully qualified DNS name of
               the Environment.
        :param pulumi.Input[str] description: Short description of the Environment
        :param pulumi.Input[str] name: A unique name for this Environment. This name is used
               in the application URL
        :param pulumi.Input[str] platform_arn: The [ARN][2] of the Elastic Beanstalk [Platform][3]
               to use in deployment
        :param pulumi.Input[str] poll_interval: The time between polling the AWS API to
               check if changes have been applied. Use this to adjust the rate of API calls
               for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
               use the default behavior, which is an exponential backoff
        :param pulumi.Input[list] settings: Option settings to configure the new Environment. These
               override specific values that are set as defaults. The format is detailed
               below in Option Settings
        :param pulumi.Input[str] solution_stack_name: A solution stack to base your environment
               off of. Example stacks can be found in the [Amazon API documentation][1]
        :param pulumi.Input[dict] tags: A set of tags to apply to the Environment.
        :param pulumi.Input[str] template_name: The name of the Elastic Beanstalk Configuration
               template to use in deployment
        :param pulumi.Input[str] tier: Elastic Beanstalk Environment tier. Valid values are `Worker`
               or `WebServer`. If tier is left blank `WebServer` will be used.
        :param pulumi.Input[str] version: The name of the Elastic Beanstalk Application Version
               to use in deployment.
        :param pulumi.Input[str] wait_for_ready_timeout: The maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that Terraform should
               wait for an Elastic Beanstalk Environment to be in a ready state before timing
               out.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if application is None:
            raise TypeError("Missing required property 'application'")
        __props__['application'] = application

        __props__['cname_prefix'] = cname_prefix

        __props__['description'] = description

        __props__['name'] = name

        __props__['platform_arn'] = platform_arn

        __props__['poll_interval'] = poll_interval

        __props__['settings'] = settings

        __props__['solution_stack_name'] = solution_stack_name

        __props__['tags'] = tags

        __props__['template_name'] = template_name

        __props__['tier'] = tier

        __props__['version'] = version

        __props__['wait_for_ready_timeout'] = wait_for_ready_timeout

        __props__['all_settings'] = None
        __props__['arn'] = None
        __props__['autoscaling_groups'] = None
        __props__['cname'] = None
        __props__['instances'] = None
        __props__['launch_configurations'] = None
        __props__['load_balancers'] = None
        __props__['queues'] = None
        __props__['triggers'] = None

        super(Environment, __self__).__init__(
            'aws:elasticbeanstalk/environment:Environment',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

