# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Connection(pulumi.CustomResource):
    catalog_id: pulumi.Output[str]
    """
    The ID of the Data Catalog in which to create the connection. If none is supplied, the AWS account ID is used by default.
    """
    connection_properties: pulumi.Output[dict]
    """
    A map of key-value pairs used as parameters for this connection.
    """
    connection_type: pulumi.Output[str]
    """
    The type of the connection. Defaults to `JBDC`.
    """
    description: pulumi.Output[str]
    """
    Description of the connection.
    """
    match_criterias: pulumi.Output[list]
    """
    A list of criteria that can be used in selecting this connection.
    """
    name: pulumi.Output[str]
    """
    The name of the connection.
    """
    physical_connection_requirements: pulumi.Output[dict]
    """
    A map of physical connection requirements, such as VPC and SecurityGroup. Defined below.
    """
    def __init__(__self__, resource_name, opts=None, catalog_id=None, connection_properties=None, connection_type=None, description=None, match_criterias=None, name=None, physical_connection_requirements=None, __name__=None, __opts__=None):
        """
        Provides a Glue Connection resource.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] catalog_id: The ID of the Data Catalog in which to create the connection. If none is supplied, the AWS account ID is used by default.
        :param pulumi.Input[dict] connection_properties: A map of key-value pairs used as parameters for this connection.
        :param pulumi.Input[str] connection_type: The type of the connection. Defaults to `JBDC`.
        :param pulumi.Input[str] description: Description of the connection.
        :param pulumi.Input[list] match_criterias: A list of criteria that can be used in selecting this connection.
        :param pulumi.Input[str] name: The name of the connection.
        :param pulumi.Input[dict] physical_connection_requirements: A map of physical connection requirements, such as VPC and SecurityGroup. Defined below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['catalog_id'] = catalog_id

        if connection_properties is None:
            raise TypeError("Missing required property 'connection_properties'")
        __props__['connection_properties'] = connection_properties

        __props__['connection_type'] = connection_type

        __props__['description'] = description

        __props__['match_criterias'] = match_criterias

        __props__['name'] = name

        __props__['physical_connection_requirements'] = physical_connection_requirements

        super(Connection, __self__).__init__(
            'aws:glue/connection:Connection',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

