# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class TopicRule(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN of the topic rule
    """
    cloudwatch_alarm: pulumi.Output[dict]
    cloudwatch_metric: pulumi.Output[dict]
    description: pulumi.Output[str]
    """
    The description of the rule.
    """
    dynamodb: pulumi.Output[dict]
    elasticsearch: pulumi.Output[dict]
    enabled: pulumi.Output[bool]
    """
    Specifies whether the rule is enabled.
    """
    firehose: pulumi.Output[dict]
    kinesis: pulumi.Output[dict]
    lambda_: pulumi.Output[dict]
    name: pulumi.Output[str]
    """
    The name of the rule.
    """
    republish: pulumi.Output[dict]
    s3: pulumi.Output[dict]
    sns: pulumi.Output[dict]
    sql: pulumi.Output[str]
    """
    The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
    """
    sql_version: pulumi.Output[str]
    """
    The version of the SQL rules engine to use when evaluating the rule.
    """
    sqs: pulumi.Output[dict]
    def __init__(__self__, resource_name, opts=None, cloudwatch_alarm=None, cloudwatch_metric=None, description=None, dynamodb=None, elasticsearch=None, enabled=None, firehose=None, kinesis=None, lambda_=None, name=None, republish=None, s3=None, sns=None, sql=None, sql_version=None, sqs=None, __name__=None, __opts__=None):
        """
        Create a TopicRule resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the rule.
        :param pulumi.Input[bool] enabled: Specifies whether the rule is enabled.
        :param pulumi.Input[str] name: The name of the rule.
        :param pulumi.Input[str] sql: The SQL statement used to query the topic. For more information, see AWS IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference) in the AWS IoT Developer Guide.
        :param pulumi.Input[str] sql_version: The version of the SQL rules engine to use when evaluating the rule.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['cloudwatch_alarm'] = cloudwatch_alarm

        __props__['cloudwatch_metric'] = cloudwatch_metric

        __props__['description'] = description

        __props__['dynamodb'] = dynamodb

        __props__['elasticsearch'] = elasticsearch

        if enabled is None:
            raise TypeError("Missing required property 'enabled'")
        __props__['enabled'] = enabled

        __props__['firehose'] = firehose

        __props__['kinesis'] = kinesis

        __props__['lambda_'] = lambda_

        __props__['name'] = name

        __props__['republish'] = republish

        __props__['s3'] = s3

        __props__['sns'] = sns

        if sql is None:
            raise TypeError("Missing required property 'sql'")
        __props__['sql'] = sql

        if sql_version is None:
            raise TypeError("Missing required property 'sql_version'")
        __props__['sql_version'] = sql_version

        __props__['sqs'] = sqs

        __props__['arn'] = None

        super(TopicRule, __self__).__init__(
            'aws:iot/topicRule:TopicRule',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

