# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Account(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN for this account.
    """
    email: pulumi.Output[str]
    """
    The email address of the owner to assign to the new member account. This email address must not already be associated with another AWS account.
    """
    iam_user_access_to_billing: pulumi.Output[str]
    """
    If set to `ALLOW`, the new account enables IAM users to access account billing information if they have the required permissions. If set to `DENY`, then only the root user of the new account can access account billing information.
    """
    joined_method: pulumi.Output[str]
    joined_timestamp: pulumi.Output[str]
    name: pulumi.Output[str]
    """
    A friendly name for the member account.
    """
    role_name: pulumi.Output[str]
    """
    The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the master account, allowing users in the master account to assume the role, as permitted by the master account administrator. The role has administrator permissions in the new member account.
    """
    status: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, email=None, iam_user_access_to_billing=None, name=None, role_name=None, __name__=None, __opts__=None):
        """
        Provides a resource to create a member account in the current organization.
        
        > **Note:** Account management must be done from the organization's master account.
        
        !> **WARNING:** Deleting this Terraform resource will only remove an AWS account from an organization. Terraform will not close the account. The member account must be prepared to be a standalone account beforehand. See the [AWS Organizations documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html) for more information.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The email address of the owner to assign to the new member account. This email address must not already be associated with another AWS account.
        :param pulumi.Input[str] iam_user_access_to_billing: If set to `ALLOW`, the new account enables IAM users to access account billing information if they have the required permissions. If set to `DENY`, then only the root user of the new account can access account billing information.
        :param pulumi.Input[str] name: A friendly name for the member account.
        :param pulumi.Input[str] role_name: The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the master account, allowing users in the master account to assume the role, as permitted by the master account administrator. The role has administrator permissions in the new member account.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if email is None:
            raise TypeError("Missing required property 'email'")
        __props__['email'] = email

        __props__['iam_user_access_to_billing'] = iam_user_access_to_billing

        __props__['name'] = name

        __props__['role_name'] = role_name

        __props__['arn'] = None
        __props__['joined_method'] = None
        __props__['joined_timestamp'] = None
        __props__['status'] = None

        super(Account, __self__).__init__(
            'aws:organizations/account:Account',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

