# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class ResolverRule(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN (Amazon Resource Name) for the resolver rule.
    """
    domain_name: pulumi.Output[str]
    """
    DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
    """
    name: pulumi.Output[str]
    """
    A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
    """
    owner_id: pulumi.Output[str]
    """
    When a rule is shared with another AWS account, the account ID of the account that the rule is shared with.
    """
    resolver_endpoint_id: pulumi.Output[str]
    """
    The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
    This argument should only be specified for `FORWARD` type rules.
    """
    rule_type: pulumi.Output[str]
    """
    The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
    """
    share_status: pulumi.Output[str]
    """
    Whether the rules is shared and, if so, whether the current account is sharing the rule with another account, or another account is sharing the rule with the current account.
    Values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
    """
    tags: pulumi.Output[dict]
    """
    A mapping of tags to assign to the resource.
    """
    target_ips: pulumi.Output[list]
    """
    Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
    This argument should only be specified for `FORWARD` type rules.
    """
    def __init__(__self__, resource_name, opts=None, domain_name=None, name=None, resolver_endpoint_id=None, rule_type=None, tags=None, target_ips=None, __name__=None, __opts__=None):
        """
        Provides a Route53 Resolver rule.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
        :param pulumi.Input[str] name: A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
        :param pulumi.Input[str] resolver_endpoint_id: The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
               This argument should only be specified for `FORWARD` type rules.
        :param pulumi.Input[str] rule_type: The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
        :param pulumi.Input[dict] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[list] target_ips: Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
               This argument should only be specified for `FORWARD` type rules.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if domain_name is None:
            raise TypeError("Missing required property 'domain_name'")
        __props__['domain_name'] = domain_name

        __props__['name'] = name

        __props__['resolver_endpoint_id'] = resolver_endpoint_id

        if rule_type is None:
            raise TypeError("Missing required property 'rule_type'")
        __props__['rule_type'] = rule_type

        __props__['tags'] = tags

        __props__['target_ips'] = target_ips

        __props__['arn'] = None
        __props__['owner_id'] = None
        __props__['share_status'] = None

        super(ResolverRule, __self__).__init__(
            'aws:route53/resolverRule:ResolverRule',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

