# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class DomainIdentity(pulumi.CustomResource):
    arn: pulumi.Output[str]
    """
    The ARN of the domain identity.
    """
    domain: pulumi.Output[str]
    """
    The domain name to assign to SES
    """
    verification_token: pulumi.Output[str]
    """
    A code which when added to the domain as a TXT record
    will signal to SES that the owner of the domain has authorised SES to act on
    their behalf. The domain identity will be in state "verification pending"
    until this is done. See below for an example of how this might be achieved
    when the domain is hosted in Route 53 and managed by Terraform.  Find out
    more about verifying domains in Amazon SES in the [AWS SES
    docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html).
    """
    def __init__(__self__, resource_name, opts=None, domain=None, __name__=None, __opts__=None):
        """
        Provides an SES domain identity resource
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain: The domain name to assign to SES
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if domain is None:
            raise TypeError("Missing required property 'domain'")
        __props__['domain'] = domain

        __props__['arn'] = None
        __props__['verification_token'] = None

        super(DomainIdentity, __self__).__init__(
            'aws:ses/domainIdentity:DomainIdentity',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

