# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class StateMachine(pulumi.CustomResource):
    creation_date: pulumi.Output[str]
    """
    The date the state machine was created.
    """
    definition: pulumi.Output[str]
    """
    The Amazon States Language definition of the state machine.
    """
    name: pulumi.Output[str]
    """
    The name of the state machine.
    """
    role_arn: pulumi.Output[str]
    """
    The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
    """
    status: pulumi.Output[str]
    """
    The current status of the state machine. Either "ACTIVE" or "DELETING".
    """
    tags: pulumi.Output[dict]
    """
    Key-value mapping of resource tags
    """
    def __init__(__self__, resource_name, opts=None, definition=None, name=None, role_arn=None, tags=None, __name__=None, __opts__=None):
        """
        Provides a Step Function State Machine resource
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] definition: The Amazon States Language definition of the state machine.
        :param pulumi.Input[str] name: The name of the state machine.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
        :param pulumi.Input[dict] tags: Key-value mapping of resource tags
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if definition is None:
            raise TypeError("Missing required property 'definition'")
        __props__['definition'] = definition

        __props__['name'] = name

        if role_arn is None:
            raise TypeError("Missing required property 'role_arn'")
        __props__['role_arn'] = role_arn

        __props__['tags'] = tags

        __props__['creation_date'] = None
        __props__['status'] = None

        super(StateMachine, __self__).__init__(
            'aws:sfn/stateMachine:StateMachine',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

