eval("//# sourceURL=assets/ember-cli/loader.js");

;eval("define(\"arena/adapters/application\", \n  [\"ember-data\",\"ember\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n    var Ember = __dependency2__[\"default\"];\n\n    // export default DS.FixtureAdapter.extend({\n    //     queryFixtures: function(fixtures){\n    //         return fixtures;\n    //     }\n    // });\n\n    __exports__[\"default\"] = DS.RESTAdapter.extend({\n        host: ArenaENV.api_endpoint,\n        namespace: \'api/1\',\n        ajax: function(url, type, hash) {\n            if (Ember.isEmpty(hash)) {\n                hash = {};\n            }\n            if (Ember.isEmpty(hash.data)) {\n                hash.data = {};\n            }\n            hash.data.ts = Math.round(new Date().getTime()/10000);\n            return this._super(url, type, hash);\n        },\n        findMany: function(store, type, ids) {\n            var data = { where: \'_id==\"\' + ids.join(\'\" or _id==\"\') + \'\"\'};\n            return this.ajax(this.buildURL(type.typeKey), \'GET\', { data: data });\n        },\n    });\n  });//# sourceURL=arena/adapters/application.js");

;eval("define(\"arena/app\", \n  [\"ember\",\"ember/resolver\",\"ember/load-initializers\",\"exports\"],\n  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var Resolver = __dependency2__[\"default\"];\n    var loadInitializers = __dependency3__[\"default\"];\n\n    Ember.MODEL_FACTORY_INJECTIONS = true;\n\n    var App = Ember.Application.extend({\n      modulePrefix: \'arena\', // TODO: loaded via config\n      Resolver: Resolver\n    });\n\n    loadInitializers(App, \'arena\');\n\n    moment.lang(\'en\', {\n        longDateFormat : {\n            LT : \"HH:mm\",\n            L : \"DD/MM/YYYY\",\n            LL : \"D MMMM YYYY\",\n            LLL : \"D MMMM YYYY LT\",\n            LLLL : \"dddd D MMMM YYYY LT\"\n        },\n    });\n\n    __exports__[\"default\"] = App;\n  });//# sourceURL=arena/app.js");

;eval("define(\"arena/controllers/game\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.ObjectController.extend({\n    });\n  });//# sourceURL=arena/controllers/game.js");

;eval("define(\"arena/controllers/gamemaps\", \n  [\"ember\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var InfiniteScroll = __dependency2__[\"default\"];\n\n    __exports__[\"default\"] = Ember.ArrayController.extend(InfiniteScroll.ControllerMixin, {\n        sortProperties: [\'name\'],\n        sortAscending: true\n    });\n  });//# sourceURL=arena/controllers/gamemaps.js");

;eval("define(\"arena/infinite_scroll\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    var InfiniteScroll = {\n        PAGE:     1,  // default start page\n        PER_PAGE: 25 // default per page\n    };\n\n    InfiniteScroll.ControllerMixin = Ember.Mixin.create({\n        loadingMore: false,\n        page: InfiniteScroll.PAGE,\n        perPage: InfiniteScroll.PER_PAGE,\n\n        hasMore: function(){\n            return this.get(\'total\') > this.get(\'content.length\');\n        }.property(\'@each\'),\n\n        actions: {\n            getMore: function(){\n                if (this.get(\'loadingMore\')) {\n                    return;\n                }\n\n                this.set(\'loadingMore\', true);\n                this.get(\'target\').send(\'getMore\');\n            },\n\n            gotMore: function(items, nextPage){\n                this.set(\'loadingMore\', false);\n                this.pushObjects(items);\n                this.set(\'page\', nextPage);\n            }\n        }\n    });\n\n    InfiniteScroll.RouteMixin = Ember.Mixin.create({\n        actions: {\n            getMore: function(){\n                // disable polling when more items are being loaded\n                this.set(\'allowPoll\', false);\n\n                var newpage = this.controller.get(\'page\') + 1;\n                var more = this.model(newpage);\n                more.then(function(){\n                    this.get(\'controller\').send(\'gotMore\', more.content.content, newpage);\n                }.bind(this));\n\n            }\n        }\n    });\n\n    __exports__[\"default\"] = InfiniteScroll;\n  });//# sourceURL=arena/infinite_scroll.js");

;eval("define(\"arena/controllers/games\", \n  [\"ember\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var InfiniteScroll = __dependency2__[\"default\"];\n\n    __exports__[\"default\"] = Ember.ArrayController.extend(InfiniteScroll.ControllerMixin, {\n        sortProperties: [\'_updated\'],\n        sortAscending: false\n    });\n  });//# sourceURL=arena/controllers/games.js");

;eval("define(\"arena/controllers/players\", \n  [\"ember\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var InfiniteScroll = __dependency2__[\"default\"];\n\n    __exports__[\"default\"] = Ember.ArrayController.extend(InfiniteScroll.ControllerMixin, {\n        sortProperties: [\'online\', \'team\', \'score\', \'_updated\'],\n        sortAscending: false\n    });\n  });//# sourceURL=arena/controllers/players.js");

;eval("define(\"arena/controllers/playlistitems\", \n  [\"ember\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var InfiniteScroll = __dependency2__[\"default\"];\n\n    __exports__[\"default\"] = Ember.ArrayController.extend(InfiniteScroll.ControllerMixin, {\n        sortProperties: [\'score\'],\n        sortAscending: false\n    });\n  });//# sourceURL=arena/controllers/playlistitems.js");

;eval("define(\"arena/controllers/votes\", \n  [\"ember\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var InfiniteScroll = __dependency2__[\"default\"];\n\n    __exports__[\"default\"] = Ember.ArrayController.extend(InfiniteScroll.ControllerMixin, {\n        sortProperties: [\'_updated\'],\n        sortAscending: false\n    });\n  });//# sourceURL=arena/controllers/votes.js");

;eval("define(\"arena/helpers/calendar-date\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Handlebars.makeBoundHelper(function(value) {\n      return moment(value).calendar();\n    });\n  });//# sourceURL=arena/helpers/calendar-date.js");

;eval("define(\"arena/helpers/format-date\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Handlebars.makeBoundHelper(function(date, format) {\n        return moment(date).format(format);\n    });\n  });//# sourceURL=arena/helpers/format-date.js");

;eval("define(\"arena/helpers/fromnow-date\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Handlebars.makeBoundHelper(function(value) {\n      return moment(value).fromNow();\n    });\n  });//# sourceURL=arena/helpers/fromnow-date.js");

;eval("define(\"arena/helpers/game-type\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    var gametypes = [\'Deathmatch\',\'Tournament\',\'Single Player\',\'Team Deathmatch (TDM)\',\'Capture The Flag (CTF)\',\n    \'One Flag Capture\',\'Overload\',\'Harvester\',\'Elimination\',\'CTF Elimination\',\'Last Man Standing\',\n    \'Double Domination\',\'Domination\'];\n\n    __exports__[\"default\"] = Ember.Handlebars.makeBoundHelper(function(value) {\n      return gametypes[value];\n    });\n  });//# sourceURL=arena/helpers/game-type.js");

;eval("define(\"arena/helpers/quake-name\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    var helper = function(value) {\n        var escaped = Ember.Handlebars.Utils.escapeExpression(value);\n\n        escaped = escaped.replace(/\\^([0-9])/g,\'</span><span class=\"quake-color-$1\">\');\n        escaped = \'<span class=\"quake-color-0\">\' + escaped + \'</span>\';\n\n        return new Ember.Handlebars.SafeString(escaped);\n    };\n\n    var quakeName = Ember.Handlebars.makeBoundHelper(helper);\n    quakeName.helper = helper;\n\n    __exports__[\"default\"] = quakeName;\n  });//# sourceURL=arena/helpers/quake-name.js");

;eval("define(\"arena/models/game\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    var Game = DS.Model.extend({\n        mapname: DS.attr(\'string\'),\n        gamemap: DS.belongsTo(\'gamemap\', {async: true}),\n        gametype: DS.attr(\'number\'),\n        current: DS.attr(\'boolean\'),\n        start: DS.attr(\'epoch\'),\n        stop: DS.attr(\'epoch\'),\n        players: DS.hasMany(\'player\', {async: true}),\n        votes: DS.hasMany(\'vote\', {async: true}),\n        options: DS.attr(\'dict\'),\n        _updated: DS.attr(\'date\'),\n        _created: DS.attr(\'date\')\n    });\n\n    Game.reopenClass({\n        FIXTURES: [\n            {\n                id: 1,\n                gamemap: 1,\n                gametype: 0,\n                current: true,\n                players: [\n                    \'2394808AFSDFAFS\',\n                    \'23948ASDF08AFSDFAFS\'\n                ],\n                start: moment().toDate(),\n                stop: null\n            },\n            {\n                id: 2,\n                gamemap: 2,\n                gametype: 1,\n                current: false,\n                start: moment().subtract(\'hour\').toDate(),\n                stop: moment().toDate()\n            }\n        ]\n    });\n\n    __exports__[\"default\"] = Game;\n  });//# sourceURL=arena/models/game.js");

;eval("define(\"arena/models/gamemap\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    var Gamemap = DS.Model.extend({\n        name: DS.attr(\'string\'),\n        levelshot: DS.attr(\'string\'),\n        images: DS.attr(\'raw\'),\n        gametypes: DS.attr(\'raw\'),\n        min_players: DS.attr(\'number\'),\n        max_players: DS.attr(\'number\'),\n        times_played: DS.attr(\'number\'),\n        last_played: DS.attr(\'date\'),\n        _updated: DS.attr(\'date\'),\n        _created: DS.attr(\'date\')\n    });\n\n    Gamemap.reopenClass({\n        FIXTURES: [\n            {\n                id: 1,\n                name: \'awesomemap\',\n                levelshot: \'http://ws.q3df.org/images/levelshots/128x96/bubctf1.jpg\',\n                images: [\n                    \'http://ws.q3df.org/images/levelshots/512x384/bubctf1.jpg\',\n                    \'http://ws.q3df.org/images/topviews/512x384/bubctf1.jpg\'\n                ],\n                gametypes: [4,5]\n            },\n            {\n                id: 2,\n                name: \'lastmap\',\n                levelshot: \'http://ws.q3df.org/images/levelshots/128x96/\',\n                gametypes: [0]\n            }\n        ]\n    });\n\n    __exports__[\"default\"] = Gamemap;\n  });//# sourceURL=arena/models/gamemap.js");

;eval("define(\"arena/models/player\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    var Player = DS.Model.extend({\n        name: DS.attr(\'string\'),\n        team: DS.attr(\'string\'),\n        online: DS.attr(\'boolean\'),\n        score: DS.attr(\'number\'),\n        names: DS.attr(\'raw\'),\n        skill: DS.attr(\'number\'),    \n        bot: DS.attr(\'boolean\'),\n        headmodel: DS.attr(\'string\'),\n        last_seen: DS.attr(\'date\'),\n        _updated: DS.attr(\'date\'),\n        _created: DS.attr(\'date\')\n    });\n\n    Player.reopenClass({\n        FIXTURES: [\n            {\n                id: \'2394808AFSDFAFS\',\n                name: \'-[aequitas]-\',\n                team: \'red\',\n                online: true,\n                score: 42,\n                names: [\'old_nickname\']\n            },\n            {\n                id: \'23948ASDF08AFSDFAFS\',\n                name: \'n^100^0b\',\n                team: \'red\',\n                online: true,\n                score: 0\n            },\n            {\n                id: \'23948SFADFJKLASDF08AFSDFAFS\',\n                name: \'colors^11^22^33^44^55^66^77^0w00t\',\n                team: \'\',\n                online: false,\n                score: 0\n            }\n        ]\n    });\n\n    __exports__[\"default\"] = Player;\n  });//# sourceURL=arena/models/player.js");

;eval("define(\"arena/models/playlistitem\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.Model.extend({\n        gamemap: DS.belongsTo(\'gamemap\', {async: true}),\n        gametype: DS.attr(\'number\'),\n        votes: DS.hasMany(\'vote\', {async: true}),\n        modifiers: DS.attr(\'raw\'),\n        score: DS.attr(\'number\')\n    });\n  });//# sourceURL=arena/models/playlistitem.js");

;eval("define(\"arena/models/vote\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    var Vote = DS.Model.extend({\n        vote: DS.attr(\'number\'),\n        player: DS.belongsTo(\'player\', {async: true}),\n        game: DS.belongsTo(\'game\', {async: true}),\n        gamemap: DS.belongsTo(\'gamemap\', {async: true}),\n        gametype: DS.attr(\'number\'),\n        _updated: DS.attr(\'date\'),\n        _created: DS.attr(\'date\')\n    });\n\n    Vote.reopenClass({\n        FIXTURES: [\n            {\n                id: 1,\n                game: 1,\n                player: \'2394808AFSDFAFS\',\n                vote: 1\n            }\n        ]\n    });\n\n    __exports__[\"default\"] = Vote;\n  });//# sourceURL=arena/models/vote.js");

;eval("define(\"arena/router\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    var Router = Ember.Router.extend({\n      location: ArenaENV.locationType\n    });\n\n    Router.map(function() {\n      this.resource(\'games\');\n      this.resource(\'game\', { path: \'/games/:game_id\' });\n\n      this.resource(\'players\');\n      this.resource(\'player\', { path: \'/players/:player_id\' });\n      \n      this.resource(\'gamemaps\');\n      this.resource(\'gamemap\', { path: \'/gamemaps/:gamemap_id\' });\n\n      this.resource(\'votes\');\n\n      this.route(\'playlist\');\n    });\n\n    __exports__[\"default\"] = Router;\n  });//# sourceURL=arena/router.js");

;eval("define(\"arena/routes/application\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n        actions: {\n            // prevent loading screen when refreshing current page\n            loading: function(transition) {\n                if (transition.urlMethod === \'replace\'){\n                    return false;\n                }\n                return true;\n            }\n        }\n    });\n  });//# sourceURL=arena/routes/application.js");

;eval("define(\"arena/routes/game\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n    });\n  });//# sourceURL=arena/routes/game.js");

;eval("define(\"arena/routes/gamemap\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n    });\n  });//# sourceURL=arena/routes/gamemap.js");

;eval("define(\"arena/routes/gamemaps\", \n  [\"ember\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var InfiniteScroll = __dependency2__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend(InfiniteScroll.RouteMixin, {\n        setupController: function(controller) {\n            this.model(1).then(function(items){\n                controller.set(\'content\', items.get(\'content\'));\n                controller.set(\'total\', items.get(\'meta.total\'));\n            });\n        },\n        model: function(page){\n            return this.store.find(\'gamemap\', {\'sort\': \'[(\"name\",1)]\', \'page\': page});\n        }\n    });\n  });//# sourceURL=arena/routes/gamemaps.js");

;eval("define(\"arena/routes/games\", \n  [\"ember\",\"arena/routes/polling\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var PollingRouteMixin = __dependency2__[\"default\"];\n    var InfiniteScroll = __dependency3__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend(PollingRouteMixin, InfiniteScroll.RouteMixin, {\n        setupController: function(controller) {\n            this.model(1).then(function(items){\n                controller.set(\'content\', items.get(\'content\'));\n                controller.set(\'total\', items.get(\'meta.total\'));\n            });\n        },\n        model: function(page){\n            return this.store.find(\'game\', {\'sort\': \'[(\"updated\",-1)]\', \'page\': page});\n        }\n    });\n  });//# sourceURL=arena/routes/games.js");

;eval("define(\"arena/routes/polling\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Mixin.create({\n        poll_interval: 10000,\n        allowPoll: true,\n        activate: function(){\n            this.poll();\n        },\n        deactivate: function(){\n            Ember.run.cancel(this.get(\'poll_inst\'));\n        },\n        poll: function() {\n            var poll_inst = Ember.run.later( function() {\n                if (this.get(\'allowPoll\')){\n                    this.controller.set(\'isPolling\', true);\n                    this.refresh().then(function(){\n                        this.controller.set(\'isPolling\', false);\n                        this.poll();\n                    }.bind(this));\n                }\n            }.bind(this), this.get(\'poll_interval\'));\n            this.set(\'poll_inst\', poll_inst);\n        }\n    });\n  });//# sourceURL=arena/routes/polling.js");

;eval("define(\"arena/routes/index\", \n  [\"ember\",\"arena/routes/polling\",\"exports\"],\n  function(__dependency1__, __dependency2__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var PollingRouteMixin = __dependency2__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend(PollingRouteMixin, {\n        controllerName: \'game\',\n        setupController:function(controller, context){\n            controller.set(\'content\', context.content.get(\'firstObject\'));\n        },\n        model: function(){\n            return this.store.find(\'game\', {\'sort\': \'[(\"updated\",-1)]\'});\n        }\n    });\n  });//# sourceURL=arena/routes/index.js");

;eval("define(\"arena/routes/player\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend({\n        setupController: function(controller, model){\n            this._super(controller, model);\n            this.poll(model);\n        },\n        deactivate: function(){\n            Ember.run.cancel(this.get(\'poll_inst\'));\n        },\n        poll: function(model) {\n            var _this = this;\n            var poll_inst = Ember.run.later( function() {\n                model.reload();\n                _this.poll(model);\n            }, 5000 );\n            this.set(\'poll_inst\', poll_inst);\n        }\n    });\n  });//# sourceURL=arena/routes/player.js");

;eval("define(\"arena/routes/players\", \n  [\"ember\",\"arena/routes/polling\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var PollingRouteMixin = __dependency2__[\"default\"];\n    var InfiniteScroll = __dependency3__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend(PollingRouteMixin, InfiniteScroll.RouteMixin, {\n        setupController: function(controller) {\n            this.model(1).then(function(items){\n                controller.set(\'content\', items.get(\'content\'));\n                controller.set(\'total\', items.get(\'meta.total\'));\n            });\n        },\n        model: function(page){\n            return this.store.find(\'player\', {\'sort\': \'[(\"last_seen\",-1)]\', \'page\': page});\n        }\n    });\n  });//# sourceURL=arena/routes/players.js");

;eval("define(\"arena/routes/playlist\", \n  [\"ember\",\"arena/routes/polling\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var PollingRouteMixin = __dependency2__[\"default\"];\n    var InfiniteScroll = __dependency3__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend(PollingRouteMixin, InfiniteScroll.RouteMixin, {\n        controllerName: \'playlistitems\',\n\n        setupController: function(controller) {\n            this.model(1).then(function(items){\n                controller.set(\'content\', items.get(\'content\'));\n                controller.set(\'total\', items.get(\'meta.total\'));\n            });\n        },\n        model: function(page){\n            return this.store.find(\'playlistitem\', {\'sort\': \'[(\"score\",-1)]\', \'page\': page});\n        }\n    });\n  });//# sourceURL=arena/routes/playlist.js");

;eval("define(\"arena/routes/votes\", \n  [\"ember\",\"arena/routes/polling\",\"arena/infinite_scroll\",\"exports\"],\n  function(__dependency1__, __dependency2__, __dependency3__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    var PollingRouteMixin = __dependency2__[\"default\"];\n    var InfiniteScroll = __dependency3__[\"default\"];\n\n    __exports__[\"default\"] = Ember.Route.extend(PollingRouteMixin, InfiniteScroll.RouteMixin, {\n        setupController: function(controller) {\n            this.model(1).then(function(items){\n                controller.set(\'content\', items.get(\'content\'));\n                controller.set(\'total\', items.get(\'meta.total\'));\n            });\n        },\n        model: function(page){\n            return this.store.find(\'vote\', {\'sort\': \'[(\"updated\",-1)]\', \'page\': page});\n        }\n    });\n  });//# sourceURL=arena/routes/votes.js");

;eval("define(\"arena/serializers/application\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.RESTSerializer.extend({\n        extractArray: function(store, type, payload) {\n            payload[type.typeKey] = payload._items;\n            delete payload._items;\n            delete payload._links;\n\n            return this._super(store, type, payload);\n        },\n        extractSingle: function(store, type, payload, id) {\n            var _payload = {};\n            _payload[type.typeKey] = payload;\n\n            return this._super(store, type, _payload, id);\n        },\n        extractMeta: function(store, type, payload) {\n            if (payload._meta){\n                payload.meta = payload._meta;\n                delete payload._meta;        \n            }\n            return this._super(store, type, payload);\n        },\n        primaryKey: \'_id\'\n    });\n  });//# sourceURL=arena/serializers/application.js");

;eval("define(\"arena/templates/_navbar\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, self=this, helperMissing=helpers.helperMissing;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"players\", options) : helperMissing.call(depth0, \"link-to\", \"players\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Players\\n                \");\n      }\n\n    function program4(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"games\", options) : helperMissing.call(depth0, \"link-to\", \"games\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      return buffer;\n      }\n    function program5(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Played games\\n                \");\n      }\n\n    function program7(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(8, program8, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"votes\", options) : helperMissing.call(depth0, \"link-to\", \"votes\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      return buffer;\n      }\n    function program8(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Votes\\n                \");\n      }\n\n    function program10(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(11, program11, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"gamemaps\", options) : helperMissing.call(depth0, \"link-to\", \"gamemaps\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      return buffer;\n      }\n    function program11(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Maps\\n                \");\n      }\n\n    function program13(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'bubbles\': (false)\n      },hashTypes:{\'bubbles\': \"BOOLEAN\"},hashContexts:{\'bubbles\': depth0},inverse:self.noop,fn:self.program(14, program14, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"playlist\", options) : helperMissing.call(depth0, \"link-to\", \"playlist\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      return buffer;\n      }\n    function program14(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n                Playlist\\n                \");\n      }\n\n      data.buffer.push(\"<nav class=\\\"navbar navbar-default\\\" role=\\\"navigation\\\">\\n    <div class=\\\"container-fluid\\\">\\n        <!-- Brand and toggle get grouped for better mobile display -->\\n        <div class=\\\"navbar-header\\\">\\n            <button type=\\\"button\\\" class=\\\"navbar-toggle\\\" data-toggle=\\\"collapse\\\" data-target=\\\"#bs-example-navbar-collapse-1\\\">\\n                <span class=\\\"sr-only\\\">Toggle navigation</span>\\n                <span class=\\\"icon-bar\\\"></span>\\n                <span class=\\\"icon-bar\\\"></span>\\n                <span class=\\\"icon-bar\\\"></span>\\n            </button>\\n            <a class=\\\"navbar-brand\\\" href=\\\"#\\\">Munerator</a>\\n        </div>\\n\\n        <!-- Collect the nav links, forms, and other content for toggling -->\\n        <div class=\\\"collapse navbar-collapse in\\\" id=\\\"bs-example-navbar-collapse-1\\\">\\n            <ul class=\\\"nav navbar-nav\\\">\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"players\", options) : helperMissing.call(depth0, \"link-to\", \"players\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"games\", options) : helperMissing.call(depth0, \"link-to\", \"games\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(7, program7, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"votes\", options) : helperMissing.call(depth0, \"link-to\", \"votes\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(10, program10, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"gamemaps\", options) : helperMissing.call(depth0, \"link-to\", \"gamemaps\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n                \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"li\"),\n        \'href\': (false)\n      },hashTypes:{\'tagName\': \"STRING\",\'href\': \"BOOLEAN\"},hashContexts:{\'tagName\': depth0,\'href\': depth0},inverse:self.noop,fn:self.program(13, program13, data),contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"playlist\", options) : helperMissing.call(depth0, \"link-to\", \"playlist\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n\\n            </ul>\\n            <ul class=\\\"nav navbar-nav navbar-right\\\">\\n                <li>\\n                    <a href=\\\"/api/1/\\\" target=\\\"_blank\\\">API</a>\\n                </li>\\n            </ul>\\n        </div>\\n    </div><!-- /.container-fluid -->\\n</nav>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/_navbar.js");

;eval("define(\"arena/templates/application\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;\n\n\n      data.buffer.push(escapeExpression((helper = helpers.partial || (depth0 && depth0.partial),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"STRING\"],data:data},helper ? helper.call(depth0, \"navbar\", options) : helperMissing.call(depth0, \"partial\", \"navbar\", options))));\n      data.buffer.push(\"\\n\");\n      stack1 = helpers._triageMustache.call(depth0, \"outlet\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/application.js");

;eval("define(\"arena/templates/game\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var stack1;\n      stack1 = helpers._triageMustache.call(depth0, \"gamemap.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      else { data.buffer.push(\'\'); }\n      }\n\n    function program3(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n<li>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" \");\n      stack1 = helpers[\'if\'].call(depth0, \"bot\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(6, program6, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n\");\n      return buffer;\n      }\n    function program4(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      }\n\n    function program6(depth0,data) {\n      \n      \n      data.buffer.push(\"(bot)\");\n      }\n\n    function program8(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n<li>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(9, program9, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" - \");\n      stack1 = helpers._triageMustache.call(depth0, \"vote\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n\");\n      return buffer;\n      }\n    function program9(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"player.name\", options) : helperMissing.call(depth0, \"quake-name\", \"player.name\", options))));\n      }\n\n    function program11(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<li>\");\n      stack1 = helpers._triageMustache.call(depth0, \"option.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" - \");\n      stack1 = helpers._triageMustache.call(depth0, \"option.value\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n\");\n      return buffer;\n      }\n\n      data.buffer.push(\"<img \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'src\': (\"gamemap.levelshot\")\n      },hashTypes:{\'src\': \"ID\"},hashContexts:{\'src\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\" class=\\\"img-thumbnail\\\" alt=\\\"levelshot\\\" width=\\\"128\\\">\\n<p>map: \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"gamemap\", \"gamemap\", options) : helperMissing.call(depth0, \"link-to\", \"gamemap\", \"gamemap\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n<p>gametype: \");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"gametype\", options) : helperMissing.call(depth0, \"game-type\", \"gametype\", options))));\n      data.buffer.push(\"</p>\\n<p>players:</p>\\n<ul>\\n\");\n      stack1 = helpers.each.call(depth0, \"players\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(3, program3, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</ul>\\n<p>started: \");\n      stack1 = helpers._triageMustache.call(depth0, \"start\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n<p>ended: \");\n      stack1 = helpers._triageMustache.call(depth0, \"stop\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n<p>votes:</p>\\n<ul>\\n\");\n      stack1 = helpers.each.call(depth0, \"votes\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(8, program8, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</ul>\\n<p>game options:</p>\\n<ul>\\n\");\n      stack1 = helpers.each.call(depth0, \"option\", \"in\", \"options\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(11, program11, data),contexts:[depth0,depth0,depth0],types:[\"ID\",\"ID\",\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</ul>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/game.js");

;eval("define(\"arena/templates/gamemap\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', helper, options;\n      data.buffer.push(\"\\n    <li>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"\", options) : helperMissing.call(depth0, \"game-type\", \"\", options))));\n      data.buffer.push(\"</li>\\n    \");\n      return buffer;\n      }\n\n    function program3(depth0,data) {\n      \n      var buffer = \'\';\n      data.buffer.push(\"\\n    <img \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'src\': (\"\")\n      },hashTypes:{\'src\': \"ID\"},hashContexts:{\'src\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\" alt=\\\"map image\\\" class=\\\"img-rounded\\\">\\n    \");\n      return buffer;\n      }\n\n      data.buffer.push(\"<img \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'src\': (\"levelshot\")\n      },hashTypes:{\'src\': \"ID\"},hashContexts:{\'src\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\" class=\\\"img-thumbnail\\\" alt=\\\"levelshot\\\" width=\\\"128\\\">\\n<p>map: \");\n      stack1 = helpers._triageMustache.call(depth0, \"name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n<p>gametypes:</p>\\n<ul>\\n    \");\n      stack1 = helpers.each.call(depth0, \"gametypes\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</ul>\\n<p>min players: \");\n      stack1 = helpers._triageMustache.call(depth0, \"min_players\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n<p>max players: \");\n      stack1 = helpers._triageMustache.call(depth0, \"max_players\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n<p>last played: \");\n      stack1 = helpers._triageMustache.call(depth0, \"last_played\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" (\");\n      data.buffer.push(escapeExpression((helper = helpers[\'fromnow-date\'] || (depth0 && depth0[\'fromnow-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0,depth0],types:[\"ID\",\"STRING\"],data:data},helper ? helper.call(depth0, \"last_played\", \"DD\", options) : helperMissing.call(depth0, \"fromnow-date\", \"last_played\", \"DD\", options))));\n      data.buffer.push(\")</p>\\n<p>times played: \");\n      stack1 = helpers._triageMustache.call(depth0, \"times_played\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n<p>images:</p>\\n<div>\\n    \");\n      stack1 = helpers.each.call(depth0, \"images\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(3, program3, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</div>\\n\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/gamemap.js");

;eval("define(\"arena/templates/gamemaps\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n    \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"tr\"),\n        \'class\': (\"clickable\")\n      },hashTypes:{\'tagName\': \"STRING\",\'class\': \"STRING\"},hashContexts:{\'tagName\': depth0,\'class\': depth0},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"gamemap\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"gamemap\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n    \");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n    <td><img \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'src\': (\"levelshot\")\n      },hashTypes:{\'src\': \"ID\"},hashContexts:{\'src\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\" alt=\\\"levelshot\\\" class=\\\"img-thumbnail\\\" width=\\\"128\\\"></td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\\n        <ul>\\n            \");\n      stack1 = helpers.each.call(depth0, \"gametypes\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(3, program3, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        </ul>\\n    </td>\\n    <td>\\n        \");\n      stack1 = helpers._triageMustache.call(depth0, \"min_players\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" - \");\n      stack1 = helpers._triageMustache.call(depth0, \"max_players\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n    </td>\\n    <td>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'format-date\'] || (depth0 && depth0[\'format-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0,depth0],types:[\"ID\",\"STRING\"],data:data},helper ? helper.call(depth0, \"last_played\", \"LLL\", options) : helperMissing.call(depth0, \"format-date\", \"last_played\", \"LLL\", options))));\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"times_played\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    \");\n      return buffer;\n      }\n    function program3(depth0,data) {\n      \n      var buffer = \'\', helper, options;\n      data.buffer.push(\"\\n            <li>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"\", options) : helperMissing.call(depth0, \"game-type\", \"\", options))));\n      data.buffer.push(\"</li>\\n            \");\n      return buffer;\n      }\n\n    function program5(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<button \");\n      data.buffer.push(escapeExpression(helpers.action.call(depth0, \"getMore\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"STRING\"],data:data})));\n      data.buffer.push(\" type=\\\"button\\\" class=\\\"btn btn-primary btn-xs btn-block\\\">\\n    \");\n      stack1 = helpers[\'if\'].call(depth0, \"loadingMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.program(8, program8, data),fn:self.program(6, program6, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</button>\\n\");\n      return buffer;\n      }\n    function program6(depth0,data) {\n      \n      \n      data.buffer.push(\"Loading more...\");\n      }\n\n    function program8(depth0,data) {\n      \n      \n      data.buffer.push(\"Load more\");\n      }\n\n      data.buffer.push(\"<div class=\\\"pull-right\\\">\\n    (\");\n      stack1 = helpers._triageMustache.call(depth0, \"length\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" of total: \");\n      stack1 = helpers._triageMustache.call(depth0, \"total\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\")\\n</div>\\n<table class=\\\"table\\\">\\n    <tr>\\n        <th>&nbsp;</th>\\n        <th>Map name</th>\\n        <th>Gametypes</th>\\n        <th>Num. players</th>\\n        <th>Last played</th>\\n        <th>Times played</th>\\n    </tr>\\n    \");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\\n\");\n      stack1 = helpers[\'if\'].call(depth0, \"hasMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/gamemaps.js");

;eval("define(\"arena/templates/games\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n    \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"tr\"),\n        \'class\': (\"clickable\")\n      },hashTypes:{\'tagName\': \"STRING\",\'class\': \"STRING\"},hashContexts:{\'tagName\': depth0,\'class\': depth0},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"game\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"game\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n    \");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n    <td>\\n        <img \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'src\': (\"gamemap.levelshot\")\n      },hashTypes:{\'src\': \"ID\"},hashContexts:{\'src\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\" alt=\\\"levelshot\\\" class=\\\"img-thumbnail\\\" width=\\\"64\\\" height=\\\"64\\\">\\n    </td>\\n    <td>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(3, program3, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"gamemap\", \"gamemap\", options) : helperMissing.call(depth0, \"link-to\", \"gamemap\", \"gamemap\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"gametype\", options) : helperMissing.call(depth0, \"game-type\", \"gametype\", options))));\n      data.buffer.push(\"</td>\\n    <td>\\n        <ul>\\n            \");\n      stack1 = helpers.each.call(depth0, \"players\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        </ul>\\n    </td>\\n    <td>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'fromnow-date\'] || (depth0 && depth0[\'fromnow-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0,depth0],types:[\"ID\",\"STRING\"],data:data},helper ? helper.call(depth0, \"start\", \"DD\", options) : helperMissing.call(depth0, \"fromnow-date\", \"start\", \"DD\", options))));\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers.unless.call(depth0, \"current\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(10, program10, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\\n        \");\n      stack1 = helpers[\'if\'].call(depth0, \"current\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(12, program12, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        &nbsp;\\n    </td>\\n    \");\n      return buffer;\n      }\n    function program3(depth0,data) {\n      \n      var stack1;\n      stack1 = helpers._triageMustache.call(depth0, \"gamemap.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      else { data.buffer.push(\'\'); }\n      }\n\n    function program5(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n            <li \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'class\': (\"online::circle\")\n      },hashTypes:{\'class\': \"STRING\"},hashContexts:{\'class\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\">\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(6, program6, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" \");\n      stack1 = helpers[\'if\'].call(depth0, \"bot\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(8, program8, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n            \");\n      return buffer;\n      }\n    function program6(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      }\n\n    function program8(depth0,data) {\n      \n      \n      data.buffer.push(\"(bot)\");\n      }\n\n    function program10(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'fromnow-date\'] || (depth0 && depth0[\'fromnow-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"stop\", options) : helperMissing.call(depth0, \"fromnow-date\", \"stop\", options))));\n      }\n\n    function program12(depth0,data) {\n      \n      \n      data.buffer.push(\"<span class=\\\"glyphicon glyphicon-ok\\\"></span>\");\n      }\n\n    function program14(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<button \");\n      data.buffer.push(escapeExpression(helpers.action.call(depth0, \"getMore\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"STRING\"],data:data})));\n      data.buffer.push(\" type=\\\"button\\\" class=\\\"btn btn-primary btn-xs btn-block\\\">\\n    \");\n      stack1 = helpers[\'if\'].call(depth0, \"loadingMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.program(17, program17, data),fn:self.program(15, program15, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</button>\\n\");\n      return buffer;\n      }\n    function program15(depth0,data) {\n      \n      \n      data.buffer.push(\"Loading more...\");\n      }\n\n    function program17(depth0,data) {\n      \n      \n      data.buffer.push(\"Load more\");\n      }\n\n      data.buffer.push(\"<div class=\\\"pull-right\\\">\\n    (\");\n      stack1 = helpers._triageMustache.call(depth0, \"length\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" of total: \");\n      stack1 = helpers._triageMustache.call(depth0, \"total\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\")\\n</div>\\n<table class=\\\"table\\\">\\n    <tr>\\n        <th>&nbsp;</th>\\n        <th>Map name</th>\\n        <th>Gametype</th>\\n        <th>Players</th>\\n        <th>Start</th>\\n        <th>Stop</th>\\n        <th><span \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'class\': (\"isPolling::invisible :glyphicon :glyphicon-refresh\")\n      },hashTypes:{\'class\': \"STRING\"},hashContexts:{\'class\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\"></span></th>\\n    </tr>\\n    \");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\\n\");\n      stack1 = helpers[\'if\'].call(depth0, \"hasMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(14, program14, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/games.js");

;eval("define(\"arena/templates/games/loading\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      \n\n\n      data.buffer.push(\"2 loading...\");\n      \n    });\n  });//# sourceURL=arena/templates/games/loading.js");

;eval("define(\"arena/templates/index\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n        <span \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'class\': (\"isPolling::invisible :glyphicon :glyphicon-refresh\")\n      },hashTypes:{\'class\': \"STRING\"},hashContexts:{\'class\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\"></span>\\n        <p>Current game:</p>\\n        <img \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'src\': (\"gamemap.levelshot\")\n      },hashTypes:{\'src\': \"ID\"},hashContexts:{\'src\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\" alt=\\\"levelshot\\\" class=\\\"img-thumbnail\\\" width=\\\"128\\\" height=\\\"128\\\">\\n        <p>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"gamemap\", \"gamemap\", options) : helperMissing.call(depth0, \"link-to\", \"gamemap\", \"gamemap\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" - \");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"gametype\", options) : helperMissing.call(depth0, \"game-type\", \"gametype\", options))));\n      data.buffer.push(\"</p>\\n        <p>Started: \");\n      data.buffer.push(escapeExpression((helper = helpers[\'fromnow-date\'] || (depth0 && depth0[\'fromnow-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0,depth0],types:[\"ID\",\"STRING\"],data:data},helper ? helper.call(depth0, \"start\", \"DD\", options) : helperMissing.call(depth0, \"fromnow-date\", \"start\", \"DD\", options))));\n      data.buffer.push(\"</p>\\n        <p>players:</p>\\n        <ul>\\n            \");\n      stack1 = helpers.each.call(depth0, \"players\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.program(10, program10, data),fn:self.program(4, program4, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n        </ul>\\n    \");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      var stack1;\n      stack1 = helpers._triageMustache.call(depth0, \"gamemap.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      else { data.buffer.push(\'\'); }\n      }\n\n    function program4(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n            \");\n      stack1 = helpers[\'if\'].call(depth0, \"online\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n            \");\n      return buffer;\n      }\n    function program5(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n            <li>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(6, program6, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" \");\n      stack1 = helpers[\'if\'].call(depth0, \"bot\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(8, program8, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" - \");\n      stack1 = helpers._triageMustache.call(depth0, \"score\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n            \");\n      return buffer;\n      }\n    function program6(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      }\n\n    function program8(depth0,data) {\n      \n      \n      data.buffer.push(\"(bot)\");\n      }\n\n    function program10(depth0,data) {\n      \n      \n      data.buffer.push(\"\\n            <li>no players</li>\\n            \");\n      }\n\n      data.buffer.push(\"<div class=\\\"row\\\">\\n    <div class=\\\"col-md-6\\\">\\n        <p><a href=\\\"https://quake.ijohan.nl\\\">Game Manager</a></p>\\n        <p><a href=\\\"http://quake.brensen.com/api/1\\\">API</a></p>\\n        <p><a href=\\\"/stats\\\">Stats</a></p>\\n\\n        <p>Join us every day around 12:30 at: quake.brensen.com, port 1200.</p>\\n        <p>OpenArena version: 0.8.8 (<a href=\\\"http://www.openarena.ws/download.php?list.61\\\">download</a>)</p>\\n        <p>Be sure to enable downloading in your settings or some maps will not load <a target=\\\"_blank\\\" href=\\\"http://openarena.wikia.com/wiki/Manual/Automatic_downloading#How_to_setup\\\">instructions</a></p>\\n    </div>\\n    \");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{\n        \'tagName\': (\"div\"),\n        \'class\': (\"clickable col-md-6\")\n      },hashTypes:{\'tagName\': \"STRING\",\'class\': \"STRING\"},hashContexts:{\'tagName\': depth0,\'class\': depth0},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"game\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"game\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</div>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/index.js");

;eval("define(\"arena/templates/loading\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      \n\n\n      data.buffer.push(\"loading...\");\n      \n    });\n  });//# sourceURL=arena/templates/loading.js");

;eval("define(\"arena/templates/player\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helper, options, escapeExpression=this.escapeExpression, helperMissing=helpers.helperMissing, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\';\n      data.buffer.push(\"\\n<img src=\\\"/assets/headmodels/\");\n      data.buffer.push(escapeExpression(helpers.unbound.call(depth0, \"headmodel\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data})));\n      data.buffer.push(\".png\\\">\\n\");\n      return buffer;\n      }\n\n    function program3(depth0,data) {\n      \n      \n      data.buffer.push(\"(bot)\");\n      }\n\n    function program5(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<p>Previous nicknames:</p>\\n<ul>\\n\");\n      stack1 = helpers.each.call(depth0, \"names\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(6, program6, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</ul>\\n\");\n      return buffer;\n      }\n    function program6(depth0,data) {\n      \n      var buffer = \'\', helper, options;\n      data.buffer.push(\"\\n<li>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"\", options) : helperMissing.call(depth0, \"quake-name\", \"\", options))));\n      data.buffer.push(\"</li>\\n\");\n      return buffer;\n      }\n\n      stack1 = helpers[\'if\'].call(depth0, \"headmodel\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n\\n<p>Nickname: \");\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      data.buffer.push(\" \");\n      stack1 = helpers[\'if\'].call(depth0, \"bot\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(3, program3, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</p>\\n\");\n      stack1 = helpers[\'if\'].call(depth0, \"names\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n<p>Last seen: \");\n      stack1 = helpers._triageMustache.call(depth0, \"last_seen\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" (\");\n      data.buffer.push(escapeExpression((helper = helpers[\'fromnow-date\'] || (depth0 && depth0[\'fromnow-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0,depth0],types:[\"ID\",\"STRING\"],data:data},helper ? helper.call(depth0, \"last_seen\", \"DD\", options) : helperMissing.call(depth0, \"fromnow-date\", \"last_seen\", \"DD\", options))));\n      data.buffer.push(\")</p>\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/player.js");

;eval("define(\"arena/templates/players\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, escapeExpression=this.escapeExpression, helperMissing=helpers.helperMissing, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n<tr>\\n    <td>\\n        <span \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'class\': (\"online::invisible :glyphicon :glyphicon-ok\")\n      },hashTypes:{\'class\': \"STRING\"},hashContexts:{\'class\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\"></span>\\n        \");\n      stack1 = helpers[\'if\'].call(depth0, \"headmodel\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n    </td>\\n    <td>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" \");\n      stack1 = helpers[\'if\'].call(depth0, \"bot\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(6, program6, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"team\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"score\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'fromnow-date\'] || (depth0 && depth0[\'fromnow-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0,depth0],types:[\"ID\",\"STRING\"],data:data},helper ? helper.call(depth0, \"last_seen\", \"DD\", options) : helperMissing.call(depth0, \"fromnow-date\", \"last_seen\", \"DD\", options))));\n      data.buffer.push(\"</td>\\n    <td>&nbsp;</td>\\n</tr>\\n\");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      var buffer = \'\';\n      data.buffer.push(\"\\n        <img src=\\\"/assets/headmodels/\");\n      data.buffer.push(escapeExpression(helpers.unbound.call(depth0, \"headmodel\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data})));\n      data.buffer.push(\".png\\\" alt=\\\"headmodel\\\" width=\\\"32\\\">\\n        \");\n      return buffer;\n      }\n\n    function program4(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"name\", options) : helperMissing.call(depth0, \"quake-name\", \"name\", options))));\n      }\n\n    function program6(depth0,data) {\n      \n      \n      data.buffer.push(\"(bot)\");\n      }\n\n    function program8(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<button \");\n      data.buffer.push(escapeExpression(helpers.action.call(depth0, \"getMore\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"STRING\"],data:data})));\n      data.buffer.push(\" type=\\\"button\\\" class=\\\"btn btn-primary btn-xs btn-block\\\">\\n    \");\n      stack1 = helpers[\'if\'].call(depth0, \"loadingMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.program(11, program11, data),fn:self.program(9, program9, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</button>\\n\");\n      return buffer;\n      }\n    function program9(depth0,data) {\n      \n      \n      data.buffer.push(\"Loading more...\");\n      }\n\n    function program11(depth0,data) {\n      \n      \n      data.buffer.push(\"Load more\");\n      }\n\n      data.buffer.push(\"<div class=\\\"pull-right\\\">\\n    (\");\n      stack1 = helpers._triageMustache.call(depth0, \"length\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" of total: \");\n      stack1 = helpers._triageMustache.call(depth0, \"total\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\")\\n</div>\\n<table class=\\\"table\\\">\\n<tr>\\n    <th>&nbsp;</th>\\n    <th>Name</th>\\n    <th>Team</th>\\n    <th>Score</th>\\n    <th>Last seen</th>\\n    <th><span \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'class\': (\"isPolling::invisible :glyphicon :glyphicon-refresh\")\n      },hashTypes:{\'class\': \"STRING\"},hashContexts:{\'class\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\"></span></th>\\n</tr>\\n\");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\\n\");\n      stack1 = helpers[\'if\'].call(depth0, \"hasMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(8, program8, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/players.js");

;eval("define(\"arena/templates/playlist\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n    <tr>\\n        <td>\\n            <img \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'src\': (\"gamemap.levelshot\")\n      },hashTypes:{\'src\': \"ID\"},hashContexts:{\'src\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\" alt=\\\"levelshot\\\" class=\\\"img-thumbnail\\\" width=\\\"64\\\" height=\\\"64\\\">\\n        </td>\\n        <td>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"gamemap\", \"gamemap\", options) : helperMissing.call(depth0, \"link-to\", \"gamemap\", \"gamemap\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n        <td>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"gametype\", options) : helperMissing.call(depth0, \"game-type\", \"gametype\", options))));\n      data.buffer.push(\"</td>\\n        <td>\\n            <ul>\\n                \");\n      stack1 = helpers.each.call(depth0, \"votes\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n            </ul>\\n        </td>\\n        <td>\\n            <ul>\\n                \");\n      stack1 = helpers.each.call(depth0, \"modifiers\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(7, program7, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n            </ul>\\n        </td>\\n        <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"score\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n        <td>\\n            &nbsp;\\n        </td>\\n    </tr>\\n    \");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      var stack1;\n      stack1 = helpers._triageMustache.call(depth0, \"gamemap.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      else { data.buffer.push(\'\'); }\n      }\n\n    function program4(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n                <li>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(5, program5, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"player\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"player\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\": \");\n      stack1 = helpers._triageMustache.call(depth0, \"vote\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n                \");\n      return buffer;\n      }\n    function program5(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"player.name\", options) : helperMissing.call(depth0, \"quake-name\", \"player.name\", options))));\n      }\n\n    function program7(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n                <li>\");\n      stack1 = helpers._triageMustache.call(depth0, \"name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\": \");\n      stack1 = helpers._triageMustache.call(depth0, \"factor\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</li>\\n                \");\n      return buffer;\n      }\n\n    function program9(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<button \");\n      data.buffer.push(escapeExpression(helpers.action.call(depth0, \"getMore\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"STRING\"],data:data})));\n      data.buffer.push(\" type=\\\"button\\\" class=\\\"btn btn-primary btn-xs btn-block\\\">\\n    \");\n      stack1 = helpers[\'if\'].call(depth0, \"loadingMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.program(12, program12, data),fn:self.program(10, program10, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</button>\\n\");\n      return buffer;\n      }\n    function program10(depth0,data) {\n      \n      \n      data.buffer.push(\"Loading more...\");\n      }\n\n    function program12(depth0,data) {\n      \n      \n      data.buffer.push(\"Load more\");\n      }\n\n      data.buffer.push(\"<div class=\\\"well-sm well\\\">\\n    <strong>Playlist generation</strong>\\n    <p>Playlist is generated every time a player joins/leaves. Maps are ordered on score. Highest scoring game will be played next. Scores are based on sum of current online players votes for map/gametype combo, multiplied by modifiers.</p>\\n    <p>Consecutive player votes count less every time until they reach 2. One +1 vote counts as 1, two as 1.5, three as 1.75 etc.</p>\\n    <p>Current possible modifiers are:</p>\\n    <ul>\\n    <li>recently played: don\'t favor maps which have been played recently (24 hours ago).</li>\\n    <li>played lt. avg.: boost maps which haven\'t been played a lot.</li>\\n    <li>no team games: don\'t play team games with uneven number of players</li>\\n    <li>less team games: play less team games when low number of players</li>\\n    </ul>\\n</div>\\n<div class=\\\"pull-right\\\">\\n    (\");\n      stack1 = helpers._triageMustache.call(depth0, \"length\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" of total: \");\n      stack1 = helpers._triageMustache.call(depth0, \"total\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\")\\n</div>\\n<table class=\\\"table\\\">\\n    <tr>\\n        <th>&nbsp;</th>\\n        <th>Map name</th>\\n        <th>Gametypes</th>\\n        <th>Votes</th>\\n        <th>Modifiers</th>\\n        <th>Score</th>\\n        <th><span \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'class\': (\"isPolling::invisible :glyphicon :glyphicon-refresh\")\n      },hashTypes:{\'class\': \"STRING\"},hashContexts:{\'class\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\"></span></th>\\n    </tr>\\n    \");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\\n\");\n      stack1 = helpers[\'if\'].call(depth0, \"hasMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(9, program9, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/playlist.js");

;eval("define(\"arena/templates/votes\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Ember = __dependency1__[\"default\"];\n    __exports__[\"default\"] = Ember.Handlebars.template(function anonymous(Handlebars,depth0,helpers,partials,data) {\n    this.compilerInfo = [4,\'>= 1.0.0\'];\n    helpers = this.merge(helpers, Ember.Handlebars.helpers); data = data || {};\n      var buffer = \'\', stack1, helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression, self=this;\n\n    function program1(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      data.buffer.push(\"\\n<tr>\\n    <td>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(2, program2, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"player\", \"player\", options) : helperMissing.call(depth0, \"link-to\", \"player\", \"player\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(4, program4, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"game\", \"game\", options) : helperMissing.call(depth0, \"link-to\", \"game\", \"game\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = (helper = helpers[\'link-to\'] || (depth0 && depth0[\'link-to\']),options={hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(6, program6, data),contexts:[depth0,depth0],types:[\"STRING\",\"ID\"],data:data},helper ? helper.call(depth0, \"gamemap\", \"gamemap\", options) : helperMissing.call(depth0, \"link-to\", \"gamemap\", \"gamemap\", options));\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"gametype\", options) : helperMissing.call(depth0, \"game-type\", \"gametype\", options))));\n      data.buffer.push(\"</td>\\n    <td>\");\n      stack1 = helpers._triageMustache.call(depth0, \"vote\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"</td>\\n    <td>\");\n      data.buffer.push(escapeExpression((helper = helpers[\'format-date\'] || (depth0 && depth0[\'format-date\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0,depth0],types:[\"ID\",\"STRING\"],data:data},helper ? helper.call(depth0, \"_created\", \"LLL\", options) : helperMissing.call(depth0, \"format-date\", \"_created\", \"LLL\", options))));\n      data.buffer.push(\"</td>\\n    <td>&nbsp;</td>\\n</tr>\\n\");\n      return buffer;\n      }\n    function program2(depth0,data) {\n      \n      var helper, options;\n      data.buffer.push(escapeExpression((helper = helpers[\'quake-name\'] || (depth0 && depth0[\'quake-name\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"player.name\", options) : helperMissing.call(depth0, \"quake-name\", \"player.name\", options))));\n      }\n\n    function program4(depth0,data) {\n      \n      var buffer = \'\', stack1, helper, options;\n      stack1 = helpers._triageMustache.call(depth0, \"game.gamemap.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" (\");\n      data.buffer.push(escapeExpression((helper = helpers[\'game-type\'] || (depth0 && depth0[\'game-type\']),options={hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data},helper ? helper.call(depth0, \"game.gametype\", options) : helperMissing.call(depth0, \"game-type\", \"game.gametype\", options))));\n      data.buffer.push(\")\");\n      return buffer;\n      }\n\n    function program6(depth0,data) {\n      \n      var stack1;\n      stack1 = helpers._triageMustache.call(depth0, \"gamemap.name\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      else { data.buffer.push(\'\'); }\n      }\n\n    function program8(depth0,data) {\n      \n      var buffer = \'\', stack1;\n      data.buffer.push(\"\\n<button \");\n      data.buffer.push(escapeExpression(helpers.action.call(depth0, \"getMore\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"STRING\"],data:data})));\n      data.buffer.push(\" type=\\\"button\\\" class=\\\"btn btn-primary btn-xs btn-block\\\">\\n    \");\n      stack1 = helpers[\'if\'].call(depth0, \"loadingMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.program(11, program11, data),fn:self.program(9, program9, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</button>\\n\");\n      return buffer;\n      }\n    function program9(depth0,data) {\n      \n      \n      data.buffer.push(\"Loading more...\");\n      }\n\n    function program11(depth0,data) {\n      \n      \n      data.buffer.push(\"Load more\");\n      }\n\n      data.buffer.push(\"<div class=\\\"pull-right\\\">\\n    (\");\n      stack1 = helpers._triageMustache.call(depth0, \"length\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\" of total: \");\n      stack1 = helpers._triageMustache.call(depth0, \"total\", {hash:{},hashTypes:{},hashContexts:{},contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\")\\n</div>\\n<table class=\\\"table\\\">\\n<tr>\\n    <th>Player</th>\\n    <th>Game</th>\\n    <th>Map</th>\\n    <th>Gametype</th>\\n    <th>Vote</th>\\n    <th>Created</th>\\n    <th><span \");\n      data.buffer.push(escapeExpression(helpers[\'bind-attr\'].call(depth0, {hash:{\n        \'class\': (\"isPolling::invisible :glyphicon :glyphicon-refresh\")\n      },hashTypes:{\'class\': \"STRING\"},hashContexts:{\'class\': depth0},contexts:[],types:[],data:data})));\n      data.buffer.push(\"></span></th>\\n</tr>\\n\");\n      stack1 = helpers.each.call(depth0, {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(1, program1, data),contexts:[],types:[],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n</table>\\n\");\n      stack1 = helpers[\'if\'].call(depth0, \"hasMore\", {hash:{},hashTypes:{},hashContexts:{},inverse:self.noop,fn:self.program(8, program8, data),contexts:[depth0],types:[\"ID\"],data:data});\n      if(stack1 || stack1 === 0) { data.buffer.push(stack1); }\n      data.buffer.push(\"\\n\");\n      return buffer;\n      \n    });\n  });//# sourceURL=arena/templates/votes.js");

;eval("define(\"arena/tests/arena/adapters/application.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/adapters\');\n    test(\'arena/adapters/application.js should pass jshint\', function() { \n      ok(true, \'arena/adapters/application.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/adapters/application.jshint.js");

;eval("define(\"arena/tests/arena/app.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena\');\n    test(\'arena/app.js should pass jshint\', function() { \n      ok(true, \'arena/app.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/app.jshint.js");

;eval("define(\"arena/tests/arena/controllers/game.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/controllers\');\n    test(\'arena/controllers/game.js should pass jshint\', function() { \n      ok(true, \'arena/controllers/game.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/controllers/game.jshint.js");

;eval("define(\"arena/tests/arena/controllers/gamemaps.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/controllers\');\n    test(\'arena/controllers/gamemaps.js should pass jshint\', function() { \n      ok(true, \'arena/controllers/gamemaps.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/controllers/gamemaps.jshint.js");

;eval("define(\"arena/tests/arena/controllers/games.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/controllers\');\n    test(\'arena/controllers/games.js should pass jshint\', function() { \n      ok(true, \'arena/controllers/games.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/controllers/games.jshint.js");

;eval("define(\"arena/tests/arena/controllers/players.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/controllers\');\n    test(\'arena/controllers/players.js should pass jshint\', function() { \n      ok(true, \'arena/controllers/players.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/controllers/players.jshint.js");

;eval("define(\"arena/tests/arena/controllers/playlistitems.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/controllers\');\n    test(\'arena/controllers/playlistitems.js should pass jshint\', function() { \n      ok(true, \'arena/controllers/playlistitems.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/controllers/playlistitems.jshint.js");

;eval("define(\"arena/tests/arena/controllers/votes.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/controllers\');\n    test(\'arena/controllers/votes.js should pass jshint\', function() { \n      ok(true, \'arena/controllers/votes.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/controllers/votes.jshint.js");

;eval("define(\"arena/tests/arena/helpers/calendar-date.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/helpers\');\n    test(\'arena/helpers/calendar-date.js should pass jshint\', function() { \n      ok(true, \'arena/helpers/calendar-date.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/helpers/calendar-date.jshint.js");

;eval("define(\"arena/tests/arena/helpers/format-date.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/helpers\');\n    test(\'arena/helpers/format-date.js should pass jshint\', function() { \n      ok(true, \'arena/helpers/format-date.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/helpers/format-date.jshint.js");

;eval("define(\"arena/tests/arena/helpers/fromnow-date.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/helpers\');\n    test(\'arena/helpers/fromnow-date.js should pass jshint\', function() { \n      ok(true, \'arena/helpers/fromnow-date.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/helpers/fromnow-date.jshint.js");

;eval("define(\"arena/tests/arena/helpers/game-type.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/helpers\');\n    test(\'arena/helpers/game-type.js should pass jshint\', function() { \n      ok(true, \'arena/helpers/game-type.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/helpers/game-type.jshint.js");

;eval("define(\"arena/tests/arena/helpers/quake-name.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/helpers\');\n    test(\'arena/helpers/quake-name.js should pass jshint\', function() { \n      ok(true, \'arena/helpers/quake-name.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/helpers/quake-name.jshint.js");

;eval("define(\"arena/tests/arena/infinite_scroll.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena\');\n    test(\'arena/infinite_scroll.js should pass jshint\', function() { \n      ok(true, \'arena/infinite_scroll.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/infinite_scroll.jshint.js");

;eval("define(\"arena/tests/arena/models/game.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/game.js should pass jshint\', function() { \n      ok(true, \'arena/models/game.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/game.jshint.js");

;eval("define(\"arena/tests/arena/models/gamemap.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/gamemap.js should pass jshint\', function() { \n      ok(true, \'arena/models/gamemap.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/gamemap.jshint.js");

;eval("define(\"arena/tests/arena/models/player.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/player.js should pass jshint\', function() { \n      ok(true, \'arena/models/player.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/player.jshint.js");

;eval("define(\"arena/tests/arena/models/playlistitem.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/playlistitem.js should pass jshint\', function() { \n      ok(true, \'arena/models/playlistitem.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/playlistitem.jshint.js");

;eval("define(\"arena/tests/arena/models/vote.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/models\');\n    test(\'arena/models/vote.js should pass jshint\', function() { \n      ok(true, \'arena/models/vote.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/models/vote.jshint.js");

;eval("define(\"arena/tests/arena/router.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena\');\n    test(\'arena/router.js should pass jshint\', function() { \n      ok(true, \'arena/router.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/router.jshint.js");

;eval("define(\"arena/tests/arena/routes/application.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/application.js should pass jshint\', function() { \n      ok(true, \'arena/routes/application.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/application.jshint.js");

;eval("define(\"arena/tests/arena/routes/game.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/game.js should pass jshint\', function() { \n      ok(true, \'arena/routes/game.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/game.jshint.js");

;eval("define(\"arena/tests/arena/routes/gamemap.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/gamemap.js should pass jshint\', function() { \n      ok(true, \'arena/routes/gamemap.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/gamemap.jshint.js");

;eval("define(\"arena/tests/arena/routes/gamemaps.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/gamemaps.js should pass jshint\', function() { \n      ok(true, \'arena/routes/gamemaps.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/gamemaps.jshint.js");

;eval("define(\"arena/tests/arena/routes/games.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/games.js should pass jshint\', function() { \n      ok(true, \'arena/routes/games.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/games.jshint.js");

;eval("define(\"arena/tests/arena/routes/index.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/index.js should pass jshint\', function() { \n      ok(true, \'arena/routes/index.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/index.jshint.js");

;eval("define(\"arena/tests/arena/routes/player.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/player.js should pass jshint\', function() { \n      ok(true, \'arena/routes/player.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/player.jshint.js");

;eval("define(\"arena/tests/arena/routes/players.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/players.js should pass jshint\', function() { \n      ok(true, \'arena/routes/players.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/players.jshint.js");

;eval("define(\"arena/tests/arena/routes/playlist.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/playlist.js should pass jshint\', function() { \n      ok(true, \'arena/routes/playlist.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/playlist.jshint.js");

;eval("define(\"arena/tests/arena/routes/polling.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/polling.js should pass jshint\', function() { \n      ok(true, \'arena/routes/polling.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/polling.jshint.js");

;eval("define(\"arena/tests/arena/routes/votes.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/routes\');\n    test(\'arena/routes/votes.js should pass jshint\', function() { \n      ok(true, \'arena/routes/votes.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/routes/votes.jshint.js");

;eval("define(\"arena/tests/arena/serializers/application.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/serializers\');\n    test(\'arena/serializers/application.js should pass jshint\', function() { \n      ok(true, \'arena/serializers/application.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/serializers/application.jshint.js");

;eval("define(\"arena/tests/arena/tests/helpers/resolver.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/helpers\');\n    test(\'arena/tests/helpers/resolver.js should pass jshint\', function() { \n      ok(true, \'arena/tests/helpers/resolver.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/helpers/resolver.jshint.js");

;eval("define(\"arena/tests/arena/tests/helpers/start-app.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/helpers\');\n    test(\'arena/tests/helpers/start-app.js should pass jshint\', function() { \n      ok(true, \'arena/tests/helpers/start-app.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/helpers/start-app.jshint.js");

;eval("define(\"arena/tests/arena/tests/test-helper.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests\');\n    test(\'arena/tests/test-helper.js should pass jshint\', function() { \n      ok(true, \'arena/tests/test-helper.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/test-helper.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/controllers/gamemaps-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/controllers\');\n    test(\'arena/tests/unit/controllers/gamemaps-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/controllers/gamemaps-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/controllers/gamemaps-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/controllers/games-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/controllers\');\n    test(\'arena/tests/unit/controllers/games-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/controllers/games-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/controllers/games-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/controllers/playlistitems-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/controllers\');\n    test(\'arena/tests/unit/controllers/playlistitems-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/controllers/playlistitems-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/controllers/playlistitems-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/helpers/quake-name-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/helpers\');\n    test(\'arena/tests/unit/helpers/quake-name-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/helpers/quake-name-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/helpers/quake-name-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/models/gamemap-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/models\');\n    test(\'arena/tests/unit/models/gamemap-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/models/gamemap-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/models/gamemap-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/models/playlistitem-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/models\');\n    test(\'arena/tests/unit/models/playlistitem-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/models/playlistitem-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/models/playlistitem-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/models/vote-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/models\');\n    test(\'arena/tests/unit/models/vote-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/models/vote-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/models/vote-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/application-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/application-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/application-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/application-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/game-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/game-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/game-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/game-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/gamemap-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/gamemap-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/gamemap-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/gamemap-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/gamemaps-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/gamemaps-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/gamemaps-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/gamemaps-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/index-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/index-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/index-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/index-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/player-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/player-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/player-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/player-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/playlist-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/playlist-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/playlist-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/playlist-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/routes/votes-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/routes\');\n    test(\'arena/tests/unit/routes/votes-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/routes/votes-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/routes/votes-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/serializers/applications-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/serializers\');\n    test(\'arena/tests/unit/serializers/applications-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/serializers/applications-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/serializers/applications-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/transforms/dict-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/transforms\');\n    test(\'arena/tests/unit/transforms/dict-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/transforms/dict-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/transforms/dict-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/transforms/epoch-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/transforms\');\n    test(\'arena/tests/unit/transforms/epoch-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/transforms/epoch-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/transforms/epoch-test.jshint.js");

;eval("define(\"arena/tests/arena/tests/unit/transforms/raw-test.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/tests/unit/transforms\');\n    test(\'arena/tests/unit/transforms/raw-test.js should pass jshint\', function() { \n      ok(true, \'arena/tests/unit/transforms/raw-test.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/tests/unit/transforms/raw-test.jshint.js");

;eval("define(\"arena/tests/arena/transforms/dict.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/transforms\');\n    test(\'arena/transforms/dict.js should pass jshint\', function() { \n      ok(true, \'arena/transforms/dict.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/transforms/dict.jshint.js");

;eval("define(\"arena/tests/arena/transforms/epoch.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/transforms\');\n    test(\'arena/transforms/epoch.js should pass jshint\', function() { \n      ok(true, \'arena/transforms/epoch.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/transforms/epoch.jshint.js");

;eval("define(\"arena/tests/arena/transforms/raw.jshint\", \n  [],\n  function() {\n    \"use strict\";\n    module(\'JSHint - arena/transforms\');\n    test(\'arena/transforms/raw.js should pass jshint\', function() { \n      ok(true, \'arena/transforms/raw.js should pass jshint.\'); \n    });\n  });//# sourceURL=arena/tests/arena/transforms/raw.jshint.js");

;eval("define(\"arena/tests/helpers/resolver\", \n  [\"ember/resolver\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var Resolver = __dependency1__[\"default\"];\n\n    var resolver = Resolver.create();\n\n    resolver.namespace = {\n      modulePrefix: \'arena\'\n    };\n\n    __exports__[\"default\"] = resolver;\n  });//# sourceURL=arena/tests/helpers/resolver.js");

;eval("define(\"arena/tests/helpers/start-app\", \n  [\"ember\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    /* global require */\n\n    var Application = require(\'arena/app\')[\'default\'];\n    var Router = require(\'arena/router\')[\'default\'];\n    var Ember = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = function startApp(attrs) {\n      var App;\n\n      var attributes = Ember.merge({\n        // useful Test defaults\n        rootElement: \'#ember-testing\',\n        LOG_ACTIVE_GENERATION:false,\n        LOG_VIEW_LOOKUPS: false\n      }, attrs); // but you can override;\n\n      Router.reopen({\n        location: \'none\'\n      });\n\n      Ember.run(function(){\n        App = Application.create(attributes);\n        App.setupForTesting();\n        App.injectTestHelpers();\n      });\n\n      App.reset(); // this shouldn\'t be needed, i want to be able to \"start an app at a specific URL\"\n\n      return App;\n    }\n  });//# sourceURL=arena/tests/helpers/start-app.js");

;eval("define(\"arena/tests/test-helper\", \n  [\"arena/tests/helpers/resolver\",\"ember-qunit\"],\n  function(__dependency1__, __dependency2__) {\n    \"use strict\";\n    var resolver = __dependency1__[\"default\"];\n    var setResolver = __dependency2__.setResolver;\n\n    setResolver(resolver);\n\n    document.write(\'<div id=\"ember-testing-container\"><div id=\"ember-testing\"></div></div>\');\n  });//# sourceURL=arena/tests/test-helper.js");

;eval("define(\"arena/tests/unit/controllers/gamemaps-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'controller:gamemaps\', \'GamemapsController\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var controller = this.subject();\n      ok(controller);\n    });\n  });//# sourceURL=arena/tests/unit/controllers/gamemaps-test.js");

;eval("define(\"arena/tests/unit/controllers/games-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'controller:games\', \'GamesController\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var controller = this.subject();\n      ok(controller);\n    });\n  });//# sourceURL=arena/tests/unit/controllers/games-test.js");

;eval("define(\"arena/tests/unit/controllers/playlistitems-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'controller:playlistitems\', \'PlaylistitemsController\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var controller = this.subject();\n      ok(controller);\n    });\n  });//# sourceURL=arena/tests/unit/controllers/playlistitems-test.js");

;eval("define(\"arena/tests/unit/helpers/quake-name-test\", \n  [\"ember-qunit\",\"arena/helpers/quake-name\"],\n  function(__dependency1__, __dependency2__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    var quakeName = __dependency2__[\"default\"];\n\n    test(\'quake name should be converted to colored html\', function() {\n        equal(quakeName.helper(\'colors^11^22^33^44^55^66^77^0w00t\'), \'<span class=\"quake-color-0\">colors</span><span class=\"quake-color-1\">1</span><span class=\"quake-color-2\">2</span><span class=\"quake-color-3\">3</span><span class=\"quake-color-4\">4</span><span class=\"quake-color-5\">5</span><span class=\"quake-color-6\">6</span><span class=\"quake-color-7\">7</span><span class=\"quake-color-0\">w00t</span>\');\n    });\n  });//# sourceURL=arena/tests/unit/helpers/quake-name-test.js");

;eval("define(\"arena/tests/unit/models/gamemap-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleForModel = __dependency1__.moduleForModel;\n\n    moduleForModel(\'gamemap\', \'Gamemap\', {\n      // Specify the other units that are required for this test.\n      needs: []\n    });\n\n    test(\'it exists\', function() {\n      var model = this.subject();\n      // var store = this.store();\n      ok(model);\n    });\n  });//# sourceURL=arena/tests/unit/models/gamemap-test.js");

;eval("define(\"arena/tests/unit/models/playlistitem-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleForModel = __dependency1__.moduleForModel;\n\n    moduleForModel(\'playlistitem\', \'Playlistitem\', {\n      // Specify the other units that are required for this test.\n      needs: [\'model:vote\', \'model:gamemap\']\n    });\n\n    test(\'it exists\', function() {\n      var model = this.subject();\n      // var store = this.store();\n      ok(model);\n    });\n  });//# sourceURL=arena/tests/unit/models/playlistitem-test.js");

;eval("define(\"arena/tests/unit/models/vote-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleForModel = __dependency1__.moduleForModel;\n\n    moduleForModel(\'vote\', \'Vote\', {\n      // Specify the other units that are required for this test.\n      needs: [\'model:player\', \'model:game\', \'model:gamemap\']\n    });\n\n    test(\'it exists\', function() {\n      var model = this.subject();\n      // var store = this.store();\n      ok(model);\n    });\n  });//# sourceURL=arena/tests/unit/models/vote-test.js");

;eval("define(\"arena/tests/unit/routes/application-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:application\', \'ApplicationRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/application-test.js");

;eval("define(\"arena/tests/unit/routes/game-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:game\', \'GameRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/game-test.js");

;eval("define(\"arena/tests/unit/routes/gamemap-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:gamemap\', \'GamemapRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/gamemap-test.js");

;eval("define(\"arena/tests/unit/routes/gamemaps-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:gamemaps\', \'GamemapsRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/gamemaps-test.js");

;eval("define(\"arena/tests/unit/routes/index-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:index\', \'IndexRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/index-test.js");

;eval("define(\"arena/tests/unit/routes/player-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:player\', \'PlayerRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/player-test.js");

;eval("define(\"arena/tests/unit/routes/playlist-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:playlist\', \'PlaylistRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/playlist-test.js");

;eval("define(\"arena/tests/unit/routes/votes-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'route:votes\', \'VotesRoute\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'controller:foo\']\n    });\n\n    test(\'it exists\', function() {\n      var route = this.subject();\n      ok(route);\n    });\n  });//# sourceURL=arena/tests/unit/routes/votes-test.js");

;eval("define(\"arena/tests/unit/serializers/applications-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'serializer:application\', \'ApplicationSerializer\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'adapter:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var adapter = this.subject();\n      ok(adapter);\n    });\n  });//# sourceURL=arena/tests/unit/serializers/applications-test.js");

;eval("define(\"arena/tests/unit/transforms/dict-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'transform:dict\', \'DictTransform\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'serializer:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var transform = this.subject();\n      ok(transform);\n    });\n  });//# sourceURL=arena/tests/unit/transforms/dict-test.js");

;eval("define(\"arena/tests/unit/transforms/epoch-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'transform:epoch\', \'EpochTransform\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'serializer:foo\']\n    });\n\n    test(\'converts python epoch to date\', function() {\n      var transform = this.subject();\n\n      var epoch = \'1403268702.480765\';\n\n      var date = moment.unix(epoch).toDate();\n\n      deepEqual(transform.deserialize(epoch), date, \'Epoch should deserialize to Date\');\n    });\n  });//# sourceURL=arena/tests/unit/transforms/epoch-test.js");

;eval("define(\"arena/tests/unit/transforms/raw-test\", \n  [\"ember-qunit\"],\n  function(__dependency1__) {\n    \"use strict\";\n    var test = __dependency1__.test;\n    var moduleFor = __dependency1__.moduleFor;\n\n    moduleFor(\'transform:raw\', \'RawTransform\', {\n      // Specify the other units that are required for this test.\n      // needs: [\'serializer:foo\']\n    });\n\n    // Replace this with your real tests.\n    test(\'it exists\', function() {\n      var transform = this.subject();\n      ok(transform);\n    });\n  });//# sourceURL=arena/tests/unit/transforms/raw-test.js");

;eval("define(\"arena/transforms/dict\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.Transform.extend({\n      deserialize: function(serialized) {\n        var data = [];\n\n        for (var item in serialized){\n            data.push({name: item, value: serialized[item]});\n        }\n\n        return data;\n      },\n\n      serialize: function(deserialized) {\n        return deserialized;\n      }\n    });\n  });//# sourceURL=arena/transforms/dict.js");

;eval("define(\"arena/transforms/epoch\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.Transform.extend({\n      deserialize: function(serialized) {\n        if (serialized){\n            return moment.unix(serialized).toDate();\n        } else {\n            return null;\n        }\n      },\n\n      serialize: function(deserialized) {\n        return moment(deserialized).format(\'X.SS\');\n      }\n    });\n  });//# sourceURL=arena/transforms/epoch.js");

;eval("define(\"arena/transforms/raw\", \n  [\"ember-data\",\"exports\"],\n  function(__dependency1__, __exports__) {\n    \"use strict\";\n    var DS = __dependency1__[\"default\"];\n\n    __exports__[\"default\"] = DS.Transform.extend({\n      deserialize: function(serialized) {\n        return serialized;\n      },\n\n      serialize: function(deserialized) {\n        return deserialized;\n      }\n    });\n  });//# sourceURL=arena/transforms/raw.js");
