#!/usr/bin/env python3
"""
Spimind包安装脚本
"""

from setuptools import setup, find_packages

# 读取README文件
with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="spimind",
    version="0.1.0",
    author="Spimind Team",
    author_email="team@spimind.dev",
    description="Event stream logging system for Spiking Neural Networks",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/mini-mind/spimind",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
    ],
    python_requires=">=3.8",
    install_requires=[
        "tinydb>=4.0.0",
    ],
    extras_require={
        "dev": [
            "twine",
            "wheel",
            "setuptools",
        ],
    },
)
