<PROBLEM>
Read @external/ext/repo-tldr.txt

Then analyze:

- @external/ext/ai-sdk-provider-claude-code.txt
- @external/ext/ai-sdk-provider-gemini-cli.txt
- @external/ext/cloud-code-ai-provider.txt
- @external/ext/codex-ai-provider.txt

Then look at current codebase snapshot in @llms.txt 

Look at @PLAN.md and @TODO.md 

I wanted 'uutel', a Python package that uses the 'litellm' infrastructure to expose LLM inferencing API/Python code based on Claude Code, Gemini CLI and OpenAI Codex. The 'ai-provider' folders implement such functionality as provider plugins for the Vercel AI SDK (JS/TS). You need to "port" that functionality into Python in a 'litellm'-compatible way.

I had asked another code agent to do this, but that agent kept beating around the bush and not doing the work. It had created fake @src/uutel/providers with no real implementation, and kept pretending to be doing the work.


```
$ uutel complete --prompt "Explain machine learning"
This is a mock response from Codex provider for model codex-large. Received 1 messages. In a real implementation, this would call the actual Codex API.
This is a mock response from Codex provider for model codex-large. Received 1 messages. In a real implementation, this would call the actual Codex API.
```

```
 $ uutel list_engines
🔧 UUTEL Available Engines
==================================================

  my-custom-llm/codex-large
    Large Codex model (default)

  my-custom-llm/codex-mini
    Mini Codex model - faster responses

  my-custom-llm/codex-turbo
    Turbo Codex model - balanced speed/quality

  my-custom-llm/codex-fast
    Fast Codex model - quick responses

  my-custom-llm/codex-preview
    Preview Codex model - latest features

📝 Usage Examples:
  uutel complete "Hello" --engine my-custom-llm/codex-mini
  uutel test --engine my-custom-llm/codex-fast
```
</PROBLEM>

<TASK>
Make an actionable /plan and /work to ACTUALLY implement this! 
</TASK>

