Analyze @llms.txt codebase. It’s supposed to be a Python port of these Vercel AI SDK provider plugins:

- @external/ext/ai-sdk-provider-claude-code.txt
- @external/ext/ai-sdk-provider-gemini-cli.txt
- @external/ext/cloud-code-ai-provider.txt
- @external/ext/codex-ai-provider.txt

Think hard about how good the current code is. 

Check @PLAN.md and @TODO.md for the plan and TODO list.

```sh
$ uutel test
🧪 Testing engine: my-custom-llm/codex-large
────────────────────────────────────────
🔧 Verbose mode enabled
🎯 Using engine: my-custom-llm/codex-large
⚙️  Parameters: max_tokens=50, temperature=0.7
⏳ Generating completion...
21:58:06 - LiteLLM:WARNING: utils.py:539 - `litellm.set_verbose` is deprecated. Please set `os.environ['LITELLM_LOG'] = 'DEBUG'` for debug logs.
SYNC kwargs[caching]: False; litellm.cache: None; kwargs.get('cache')['no-cache']: False
Final returned optional params: {'temperature': 0.7, 'max_tokens': 50}
This is a mock response from Codex provider for model codex-large. Received 1 messages. In a real implementation, this would call the actual Codex API.
✅ Completion successful (151 characters)
────────────────────────────────────────
✅ Test completed successfully!
💡 Engine 'my-custom-llm/codex-large' is working correctly
This is a mock response from Codex provider for model codex-large. Received 1 messages. In a real implementation, this would call the actual Codex API.
```

We don’t want mock responses. We want actual real responses.

```
$ python ./examples/basic_usage.py
🚀 UUTEL Basic Usage Example
==================================================

1️⃣ Model Name Validation
   example-model-1.0: ✅ Valid
   uutel/claude-code/claude-3-5-sonnet: ✅ Valid
   invalid/model: ❌ Invalid
   model with spaces: ❌ Invalid

2️⃣ Provider/Model Extraction
   uutel/claude-code/claude-3-5-sonnet → Provider: claude-code, Model: claude-3-5-sonnet
   uutel/gemini-cli/gemini-2.0-flash → Provider: gemini-cli, Model: gemini-2.0-flash
   simple-model → Provider: unknown, Model: simple-model

3️⃣ Message Transformation
   Original messages: 2
   After round-trip: 2
   Content preserved: True

4️⃣ HTTP Client Creation
   Sync client type: _SyncRetryClient
   Async client type: _AsyncRetryClient

5️⃣ Authentication Framework
🔑 Authenticating with example using api-key
   ✅ Auth successful: True
   🔑 Headers: 2 headers

6️⃣ Provider Usage
   📡 Provider: example
   🎯 Supported models: 2
🤖 Making completion request to example-model-1.0
📝 Messages: 2 messages
   💬 Response ID: example-123
   📊 Token usage: 25

7️⃣ Error Handling
🔑 Authenticating with example using api-key
   🚫 Caught AuthenticationError: Invalid API key | Provider: example | Code: AUTH_001
   📍 Provider: example
   🔢 Error code: AUTH_001

✨ Example completed successfully!

8️⃣ Claude Code Fixture Replay
   📁 Fixture: tests/data/providers/claude/simple_completion.json
   🧠 Text: Hi! I'm ready to help you with your software engineering tasks. Let me know what you'd like to work on.
   📊 Tokens: input=4, output=28, total=32
   🔄 To run live: npm install -g @anthropic-ai/claude-code && claude login
              uutel complete --engine uutel/claude-code/claude-sonnet-4 --stream

🔄 Async Functionality Demo
   Created async client: _AsyncRetryClient
   ✅ Async operation completed
```

We actually also want more realistic responses in the examples. Made after probing real possible model names and configs! (Also we want to be able to just select the engine like claude or gemini or codex without specifying the model name!)

Continue to update the /plan and then to /work —— improve the implementation. We want fully functioning code! 
