# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from jfjoch_client.models.detector_type import DetectorType
from typing import Optional, Set
from typing_extensions import Self

class DetectorListElement(BaseModel):
    """
    DetectorListElement
    """ # noqa: E501
    id: Annotated[int, Field(strict=True, ge=0)]
    description: StrictStr
    serial_number: StrictStr
    base_ipv4_addr: StrictStr
    udp_interface_count: StrictInt = Field(description="Number of UDP interfaces per detector module")
    nmodules: StrictInt
    width: StrictInt
    height: StrictInt
    pixel_size_mm: Optional[Union[StrictFloat, StrictInt]] = None
    readout_time_us: StrictInt
    min_frame_time_us: StrictInt
    min_count_time_us: StrictInt
    type: Optional[DetectorType] = None
    __properties: ClassVar[List[str]] = ["id", "description", "serial_number", "base_ipv4_addr", "udp_interface_count", "nmodules", "width", "height", "pixel_size_mm", "readout_time_us", "min_frame_time_us", "min_count_time_us", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetectorListElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetectorListElement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "description": obj.get("description"),
            "serial_number": obj.get("serial_number"),
            "base_ipv4_addr": obj.get("base_ipv4_addr"),
            "udp_interface_count": obj.get("udp_interface_count"),
            "nmodules": obj.get("nmodules"),
            "width": obj.get("width"),
            "height": obj.get("height"),
            "pixel_size_mm": obj.get("pixel_size_mm"),
            "readout_time_us": obj.get("readout_time_us"),
            "min_frame_time_us": obj.get("min_frame_time_us"),
            "min_count_time_us": obj.get("min_count_time_us"),
            "type": obj.get("type")
        })
        return _obj


