# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class GridScan(BaseModel):
    """
    Definition of a grid scan (mutually exclusive with `rotation_axis`)
    """ # noqa: E501
    n_fast: Annotated[int, Field(strict=True, ge=1)] = Field(description="Number of elements in the fast direction")
    step_x_um: Union[StrictFloat, StrictInt] = Field(description="Step in grid along the fast direction. Can be negative.  Positive number: left to right Negative number: right to left ")
    step_y_um: Union[StrictFloat, StrictInt] = Field(description="Step in grid along the slow direction. Can be negative.  Positive number: top to bottom Negative number: bottom to top ")
    vertical: Optional[StrictBool] = Field(default=False, description="If disabled: fast direction = X, slow direction = Y If enabled: fast direction = Y, slow direction = X ")
    snake: Optional[StrictBool] = Field(default=False, description="Flip fast direction for every second row ")
    __properties: ClassVar[List[str]] = ["n_fast", "step_x_um", "step_y_um", "vertical", "snake"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GridScan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GridScan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "n_fast": obj.get("n_fast"),
            "step_x_um": obj.get("step_x_um"),
            "step_y_um": obj.get("step_y_um"),
            "vertical": obj.get("vertical") if obj.get("vertical") is not None else False,
            "snake": obj.get("snake") if obj.get("snake") is not None else False
        })
        return _obj


