# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ImageBufferStatus(BaseModel):
    """
    ImageBufferStatus
    """ # noqa: E501
    min_image_number: Annotated[int, Field(strict=True, ge=0)] = Field(description="Smallest image number available in the buffer")
    max_image_number: Annotated[int, Field(strict=True, ge=0)] = Field(description="Largest image number available in the buffer")
    image_numbers: List[StrictInt] = Field(description="Image numbers currently present in the buffer.")
    total_slots: StrictInt = Field(description="Number of slots in the image buffer. This number, compared to number of images in data collection and frame rate will determine \"retention\" rate of the image buffer. ")
    available_slots: StrictInt = Field(description="Slots available for the data collection")
    __properties: ClassVar[List[str]] = ["min_image_number", "max_image_number", "image_numbers", "total_slots", "available_slots"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImageBufferStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImageBufferStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "min_image_number": obj.get("min_image_number"),
            "max_image_number": obj.get("max_image_number"),
            "image_numbers": obj.get("image_numbers"),
            "total_slots": obj.get("total_slots"),
            "available_slots": obj.get("available_slots")
        })
        return _obj


