# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from jfjoch_client.models.roi_azim_list import RoiAzimList
from jfjoch_client.models.roi_box_list import RoiBoxList
from jfjoch_client.models.roi_circle_list import RoiCircleList
from typing import Optional, Set
from typing_extensions import Self

class RoiDefinitions(BaseModel):
    """
    ROI defintions
    """ # noqa: E501
    box: RoiBoxList
    circle: RoiCircleList
    azim: RoiAzimList
    __properties: ClassVar[List[str]] = ["box", "circle", "azim"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RoiDefinitions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of box
        if self.box:
            _dict['box'] = self.box.to_dict()
        # override the default output from pydantic by calling `to_dict()` of circle
        if self.circle:
            _dict['circle'] = self.circle.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azim
        if self.azim:
            _dict['azim'] = self.azim.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RoiDefinitions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "box": RoiBoxList.from_dict(obj["box"]) if obj.get("box") is not None else None,
            "circle": RoiCircleList.from_dict(obj["circle"]) if obj.get("circle") is not None else None,
            "azim": RoiAzimList.from_dict(obj["azim"]) if obj.get("azim") is not None else None
        })
        return _obj


