# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from jfjoch_client.models.unit_cell import UnitCell
from typing import Optional, Set
from typing_extensions import Self

class ScanResultImagesInner(BaseModel):
    """
    ScanResultImagesInner
    """ # noqa: E501
    efficiency: Union[StrictFloat, StrictInt]
    number: StrictInt = Field(description="Detector image number for a given cell")
    bkg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Background estimate")
    spots: Optional[StrictInt] = Field(default=None, description="Spot count")
    spots_low_res: Optional[StrictInt] = Field(default=None, description="Spot count in low resolution range")
    spots_indexed: Optional[StrictInt] = Field(default=None, description="Spot count within indexing tolerance")
    spots_ice: Optional[StrictInt] = Field(default=None, description="Spot count within common ice ring resolutions")
    index: Optional[StrictInt] = Field(default=None, description="Indexing solution")
    mos: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Mosaicity estimate")
    b: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="B-Factor estimate")
    uc: Optional[UnitCell] = None
    xfel_pulseid: Optional[StrictInt] = Field(default=None, description="XFEL pulse ID")
    pixel_sum: Optional[StrictInt] = Field(default=None, description="Total sum of all pixels")
    max: Optional[StrictInt] = Field(default=None, description="Max viable pixel")
    sat: Optional[StrictInt] = Field(default=None, description="Number of saturated pixels")
    err: Optional[StrictInt] = Field(default=None, description="Number of error pixels")
    res: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Resolution estimate from ML algorithm")
    __properties: ClassVar[List[str]] = ["efficiency", "number", "bkg", "spots", "spots_low_res", "spots_indexed", "spots_ice", "index", "mos", "b", "uc", "xfel_pulseid", "pixel_sum", "max", "sat", "err", "res"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScanResultImagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of uc
        if self.uc:
            _dict['uc'] = self.uc.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScanResultImagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "efficiency": obj.get("efficiency"),
            "number": obj.get("number"),
            "bkg": obj.get("bkg"),
            "spots": obj.get("spots"),
            "spots_low_res": obj.get("spots_low_res"),
            "spots_indexed": obj.get("spots_indexed"),
            "spots_ice": obj.get("spots_ice"),
            "index": obj.get("index"),
            "mos": obj.get("mos"),
            "b": obj.get("b"),
            "uc": UnitCell.from_dict(obj["uc"]) if obj.get("uc") is not None else None,
            "xfel_pulseid": obj.get("xfel_pulseid"),
            "pixel_sum": obj.get("pixel_sum"),
            "max": obj.get("max"),
            "sat": obj.get("sat"),
            "err": obj.get("err"),
            "res": obj.get("res")
        })
        return _obj


