# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ZeromqPreviewSettings(BaseModel):
    """
    ZeromqPreviewSettings
    """ # noqa: E501
    enabled: StrictBool = Field(description="ZeroMQ preview socket is enabled.")
    period_ms: StrictInt = Field(description="Period for generating preview image sent to the ZeroMQ interface in milliseconds. Default is 1 second.  If set to zero, all images will be sent ZeroMQ (should be used only in case of relatively slow data collection). This has no effect on HTTP based preview, which updates always at rate of 1 second. ")
    socket_address: Optional[StrictStr] = Field(default=None, description="PUB ZeroMQ socket for preview images. This socket operates at a reduced frame rate. Images are serialized using CBOR. Address follows ZeroMQ convention for sockets - in practice ipc://<socket file> and tcp://<IP address>:<port> sockets are OK. 0.0.0.0 instead of IP address is accepted and means listening on all network interfaces. ")
    __properties: ClassVar[List[str]] = ["enabled", "period_ms", "socket_address"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ZeromqPreviewSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ZeromqPreviewSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "period_ms": obj.get("period_ms") if obj.get("period_ms") is not None else 1000,
            "socket_address": obj.get("socket_address")
        })
        return _obj


