# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from jfjoch_client.models.dataset_settings import DatasetSettings

class TestDatasetSettings(unittest.TestCase):
    """DatasetSettings unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> DatasetSettings:
        """Test DatasetSettings
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `DatasetSettings`
        """
        model = DatasetSettings()
        if include_optional:
            return DatasetSettings(
                images_per_trigger = 1,
                ntrigger = 1,
                image_time_us = 0,
                beam_x_pxl = 1.337,
                beam_y_pxl = 1.337,
                detector_distance_mm = 0,
                incident_energy_ke_v = 0.001,
                file_prefix = '',
                images_per_file = 0,
                space_group_number = 0,
                sample_name = '',
                compression = 'bslz4',
                total_flux = 1.337,
                transmission = 0.0,
                goniometer = jfjoch_client.models.rotation_axis.rotation_axis(
                    name = 'omega', 
                    step = 0.1, 
                    start = 50, 
                    vector = [1,0,0], 
                    helical_step_um = [-5,-2,0], 
                    screening_wedge_deg = 1.337, ),
                grid_scan = jfjoch_client.models.grid_scan.grid_scan(
                    n_fast = 20, 
                    step_x_um = 5.0, 
                    step_y_um = -3.0, 
                    vertical = True, 
                    snake = True, ),
                header_appendix = None,
                image_appendix = None,
                data_reduction_factor_serialmx = 0.0,
                pixel_value_low_threshold = 0,
                run_number = 0,
                run_name = '',
                experiment_group = '',
                poisson_compression = 0,
                write_nxmx_hdf5_master = True,
                save_calibration = True,
                polarization_factor = -1.0,
                ring_current_m_a = 0.0,
                sample_temperature_k = 0.0,
                poni_rot1_rad = -6.28318530718,
                poni_rot2_rad = -6.28318530718,
                poni_rot3_rad = -6.28318530718,
                unit_cell = jfjoch_client.models.unit_cell.unit_cell(
                    a = 37, 
                    b = 37, 
                    c = 78, 
                    alpha = 90, 
                    beta = 90, 
                    gamma = 90, )
            )
        else:
            return DatasetSettings(
                beam_x_pxl = 1.337,
                beam_y_pxl = 1.337,
                detector_distance_mm = 0,
                incident_energy_ke_v = 0.001,
        )
        """

    def testDatasetSettings(self):
        """Test DatasetSettings"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
