# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from jfjoch_client.api.default_api import DefaultApi


class TestDefaultApi(unittest.TestCase):
    """DefaultApi unit test stubs"""

    def setUp(self) -> None:
        self.api = DefaultApi()

    def tearDown(self) -> None:
        pass

    def test_cancel_post(self) -> None:
        """Test case for cancel_post

        Cancel running data collection
        """
        pass

    def test_config_azim_int_get(self) -> None:
        """Test case for config_azim_int_get

        Get radial integration configuration
        """
        pass

    def test_config_azim_int_put(self) -> None:
        """Test case for config_azim_int_put

        Configure radial integration
        """
        pass

    def test_config_detector_get(self) -> None:
        """Test case for config_detector_get

        Get detector configuration
        """
        pass

    def test_config_detector_put(self) -> None:
        """Test case for config_detector_put

        Change detector configuration
        """
        pass

    def test_config_file_writer_get(self) -> None:
        """Test case for config_file_writer_get

        Get file writer settings
        """
        pass

    def test_config_file_writer_put(self) -> None:
        """Test case for config_file_writer_put

        Change file writer settings
        """
        pass

    def test_config_image_format_conversion_post(self) -> None:
        """Test case for config_image_format_conversion_post

        Configure format for data collection with full conversion
        """
        pass

    def test_config_image_format_get(self) -> None:
        """Test case for config_image_format_get

        Get image output format
        """
        pass

    def test_config_image_format_put(self) -> None:
        """Test case for config_image_format_put

        Change image output format
        """
        pass

    def test_config_image_format_raw_post(self) -> None:
        """Test case for config_image_format_raw_post

        Configure format for raw data collection
        """
        pass

    def test_config_indexing_get(self) -> None:
        """Test case for config_indexing_get

        Get indexing configuration
        """
        pass

    def test_config_indexing_put(self) -> None:
        """Test case for config_indexing_put

        Change indexing algorithm settings
        """
        pass

    def test_config_instrument_get(self) -> None:
        """Test case for config_instrument_get

        Get instrument metadata
        """
        pass

    def test_config_instrument_put(self) -> None:
        """Test case for config_instrument_put

        Change instrument metadata
        """
        pass

    def test_config_internal_generator_image_put(self) -> None:
        """Test case for config_internal_generator_image_put

        Load binary image for internal FPGA generator
        """
        pass

    def test_config_internal_generator_image_tiff_put(self) -> None:
        """Test case for config_internal_generator_image_tiff_put

        Load TIFF image for internal FPGA generator
        """
        pass

    def test_config_mask_get(self) -> None:
        """Test case for config_mask_get

        Get mask of the detector (binary)
        """
        pass

    def test_config_mask_tiff_get(self) -> None:
        """Test case for config_mask_tiff_get

        Get mask of the detector (TIFF)
        """
        pass

    def test_config_roi_get(self) -> None:
        """Test case for config_roi_get

        Get ROI definitions
        """
        pass

    def test_config_roi_put(self) -> None:
        """Test case for config_roi_put

        Upload ROI definitions
        """
        pass

    def test_config_select_detector_get(self) -> None:
        """Test case for config_select_detector_get

        List available detectors
        """
        pass

    def test_config_select_detector_put(self) -> None:
        """Test case for config_select_detector_put

        Select detector
        """
        pass

    def test_config_spot_finding_get(self) -> None:
        """Test case for config_spot_finding_get

        Get data processing configuration
        """
        pass

    def test_config_spot_finding_put(self) -> None:
        """Test case for config_spot_finding_put

        Configure spot finding
        """
        pass

    def test_config_user_mask_get(self) -> None:
        """Test case for config_user_mask_get

        Detector must be Initialized. Get user mask of the detector (binary) 
        """
        pass

    def test_config_user_mask_put(self) -> None:
        """Test case for config_user_mask_put

        Upload user mask of the detector (binary)
        """
        pass

    def test_config_user_mask_tiff_get(self) -> None:
        """Test case for config_user_mask_tiff_get

        Detector must be Initialized. Get user mask of the detector (TIFF) 
        """
        pass

    def test_config_user_mask_tiff_put(self) -> None:
        """Test case for config_user_mask_tiff_put

        Upload user mask of the detector
        """
        pass

    def test_config_zeromq_metadata_get(self) -> None:
        """Test case for config_zeromq_metadata_get

        Get ZeroMQ metadata socket settings
        """
        pass

    def test_config_zeromq_metadata_put(self) -> None:
        """Test case for config_zeromq_metadata_put

        Set ZeroMQ metadata settings
        """
        pass

    def test_config_zeromq_preview_get(self) -> None:
        """Test case for config_zeromq_preview_get

        Get ZeroMQ preview settings
        """
        pass

    def test_config_zeromq_preview_put(self) -> None:
        """Test case for config_zeromq_preview_put

        Set ZeroMQ preview settings
        """
        pass

    def test_deactivate_post(self) -> None:
        """Test case for deactivate_post

        Prepare detector to turn off
        """
        pass

    def test_detector_status_get(self) -> None:
        """Test case for detector_status_get

        Get detector status
        """
        pass

    def test_fpga_status_get(self) -> None:
        """Test case for fpga_status_get

        Get status of FPGA devices
        """
        pass

    def test_image_buffer_clear_post(self) -> None:
        """Test case for image_buffer_clear_post

        Clear image buffer
        """
        pass

    def test_image_buffer_image_cbor_get(self) -> None:
        """Test case for image_buffer_image_cbor_get

        Get image message in CBOR format
        """
        pass

    def test_image_buffer_image_jpeg_get(self) -> None:
        """Test case for image_buffer_image_jpeg_get

        Get preview image in JPEG format using custom settings
        """
        pass

    def test_image_buffer_image_png_get(self) -> None:
        """Test case for image_buffer_image_png_get

        Get preview image in PNG format using custom settings
        """
        pass

    def test_image_buffer_image_tiff_get(self) -> None:
        """Test case for image_buffer_image_tiff_get

        Get preview image in TIFF format
        """
        pass

    def test_image_buffer_start_cbor_get(self) -> None:
        """Test case for image_buffer_start_cbor_get

        Get Start message in CBOR format
        """
        pass

    def test_image_buffer_status_get(self) -> None:
        """Test case for image_buffer_status_get

        Get status of the image buffers
        """
        pass

    def test_initialize_post(self) -> None:
        """Test case for initialize_post

        Initialize detector and data acquisition
        """
        pass

    def test_pedestal_post(self) -> None:
        """Test case for pedestal_post

        Collect dark current for the detector
        """
        pass

    def test_preview_pedestal_tiff_get(self) -> None:
        """Test case for preview_pedestal_tiff_get

        Get pedestal in TIFF format
        """
        pass

    def test_preview_plot_get(self) -> None:
        """Test case for preview_plot_get

        Generate 1D plot from Jungfraujoch
        """
        pass

    def test_result_scan_get(self) -> None:
        """Test case for result_scan_get

        Get full scan result
        """
        pass

    def test_start_post(self) -> None:
        """Test case for start_post

        Start detector
        """
        pass

    def test_statistics_calibration_get(self) -> None:
        """Test case for statistics_calibration_get

        Get calibration statistics
        """
        pass

    def test_statistics_data_collection_get(self) -> None:
        """Test case for statistics_data_collection_get

        Get data collection statistics
        """
        pass

    def test_statistics_get(self) -> None:
        """Test case for statistics_get

        Get general statistics
        """
        pass

    def test_status_get(self) -> None:
        """Test case for status_get

        Get Jungfraujoch status
        """
        pass

    def test_trigger_post(self) -> None:
        """Test case for trigger_post

        Send soft trigger to the detector
        """
        pass

    def test_version_get(self) -> None:
        """Test case for version_get

        Get Jungfraujoch version of jfjoch_broker
        """
        pass

    def test_wait_till_done_post(self) -> None:
        """Test case for wait_till_done_post

        Wait for acquisition done
        """
        pass

    def test_xfel_event_code_get(self) -> None:
        """Test case for xfel_event_code_get

        Return XFEL event codes for the current data acquisition
        """
        pass

    def test_xfel_pulse_id_get(self) -> None:
        """Test case for xfel_pulse_id_get

        Return XFEL pulse IDs for the current data acquisition
        """
        pass


if __name__ == '__main__':
    unittest.main()
