# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.62
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from jfjoch_client.models.jfjoch_settings import JfjochSettings

class TestJfjochSettings(unittest.TestCase):
    """JfjochSettings unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> JfjochSettings:
        """Test JfjochSettings
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `JfjochSettings`
        """
        model = JfjochSettings()
        if include_optional:
            return JfjochSettings(
                pcie = [
                    jfjoch_client.models.pcie_devices_inner.pcie_devices_inner(
                        blk = '/dev/jfjoch0', 
                        ipv4 = '10.1.1.7', )
                    ],
                zeromq = jfjoch_client.models.zeromq_settings.zeromq_settings(
                    send_watermark = 2, 
                    send_buffer_size = 56, 
                    image_socket = ["tcp://1.2.3.4:5000","tcp://1.2.3.4:5001"], 
                    writer_notification_socket = 'tcp://1.3.4.6:7000', ),
                instrument = jfjoch_client.models.instrument_metadata.instrument_metadata(
                    source_name = 'Swiss Light Source', 
                    source_type = '', 
                    instrument_name = 'CristallinaMX', 
                    pulsed_source = True, 
                    electron_source = True, ),
                file_writer = jfjoch_client.models.file_writer_settings.file_writer_settings(
                    overwrite = True, 
                    format = 'NXmxLegacy', ),
                detector = [
                    jfjoch_client.models.detector.detector(
                        description = '0', 
                        serial_number = 'Unknown', 
                        type = 'EIGER', 
                        high_voltage_v = 0, 
                        udp_interface_count = 1, 
                        module_sync = True, 
                        sensor_thickness_um = 0, 
                        readout_time_us = 1, 
                        minimum_count_time_us = 0, 
                        minimum_frame_time_us = 0, 
                        calibration_file = [
                            ''
                            ], 
                        hostname = [
                            ''
                            ], 
                        sensor_material = 'Si', 
                        tx_delay = [
                            56
                            ], 
                        base_data_ipv4_address = '10.10.10.50', 
                        standard_geometry = jfjoch_client.models.standard_detector_geometry.standard_detector_geometry(
                            nmodules = 1, 
                            gap_x = 0, 
                            gap_y = 0, 
                            modules_in_row = 1, ), 
                        custom_geometry = [
                            jfjoch_client.models.detector_module.detector_module(
                                x0 = 1.337, 
                                y0 = 1.337, 
                                fast_axis = 'Xp', 
                                slow_axis = 'Xp', )
                            ], 
                        roi_mode = '', 
                        mirror_y = True, )
                    ],
                indexing = jfjoch_client.models.indexing_settings.indexing_settings(
                    algorithm = 'FFBIDX', 
                    fft_max_unit_cell_a = 50, 
                    fft_min_unit_cell_a = 5, 
                    fft_high_resolution_a = 0.5, 
                    fft_num_vectors = 128, 
                    tolerance = 0.0, ),
                detector_settings = jfjoch_client.models.detector_settings.detector_settings(
                    frame_time_us = 1, 
                    count_time_us = 56, 
                    internal_frame_generator = True, 
                    internal_frame_generator_images = 1, 
                    detector_trigger_delay_ns = 0, 
                    timing = 'trigger', 
                    eiger_threshold_ke_v = 1.0, 
                    eiger_bit_depth = 8, 
                    jungfrau_pedestal_g0_frames = 0, 
                    jungfrau_pedestal_g1_frames = 0, 
                    jungfrau_pedestal_g2_frames = 0, 
                    jungfrau_pedestal_min_image_count = 32, 
                    jungfrau_storage_cell_count = 1, 
                    jungfrau_storage_cell_delay_ns = 2100, 
                    jungfrau_fixed_gain_g1 = True, 
                    jungfrau_use_gain_hg0 = True, ),
                azim_int = jfjoch_client.models.azim_int_settings.azim_int_settings(
                    polarization_corr = True, 
                    solid_angle_corr = True, 
                    high_q_recip_a = 1.337, 
                    low_q_recip_a = 1.337, 
                    q_spacing = 1.337, 
                    azimuthal_bins = 1, ),
                image_format = jfjoch_client.models.image_format_settings.image_format_settings(
                    summation = True, 
                    geometry_transform = True, 
                    jungfrau_conversion = True, 
                    jungfrau_conversion_factor_ke_v = 0.001, 
                    bit_depth_image = 8, 
                    signed_output = True, 
                    mask_module_edges = True, 
                    mask_chip_edges = True, 
                    jungfrau_mask_pixels_without_g0 = True, 
                    apply_mask = True, 
                    jungfrau_pedestal_g0_rms_limit = 0, ),
                image_buffer_mi_b = 128,
                receiver_threads = 1,
                numa_policy = '',
                frontend_directory = '',
                inference_server_addr = [
                    'gA9LCSLv1C1ylmgd0.Y2TA5TkIRHRk'
                    ],
                image_pusher = 'None',
                zeromq_preview = jfjoch_client.models.zeromq_preview_settings.zeromq_preview_settings(
                    enabled = True, 
                    period_ms = 56, 
                    socket_address = '', ),
                zeromq_metadata = jfjoch_client.models.zeromq_metadata_settings.zeromq_metadata_settings(
                    enabled = True, 
                    period_ms = 1, 
                    socket_address = '', )
            )
        else:
            return JfjochSettings(
                detector = [
                    jfjoch_client.models.detector.detector(
                        description = '0', 
                        serial_number = 'Unknown', 
                        type = 'EIGER', 
                        high_voltage_v = 0, 
                        udp_interface_count = 1, 
                        module_sync = True, 
                        sensor_thickness_um = 0, 
                        readout_time_us = 1, 
                        minimum_count_time_us = 0, 
                        minimum_frame_time_us = 0, 
                        calibration_file = [
                            ''
                            ], 
                        hostname = [
                            ''
                            ], 
                        sensor_material = 'Si', 
                        tx_delay = [
                            56
                            ], 
                        base_data_ipv4_address = '10.10.10.50', 
                        standard_geometry = jfjoch_client.models.standard_detector_geometry.standard_detector_geometry(
                            nmodules = 1, 
                            gap_x = 0, 
                            gap_y = 0, 
                            modules_in_row = 1, ), 
                        custom_geometry = [
                            jfjoch_client.models.detector_module.detector_module(
                                x0 = 1.337, 
                                y0 = 1.337, 
                                fast_axis = 'Xp', 
                                slow_axis = 'Xp', )
                            ], 
                        roi_mode = '', 
                        mirror_y = True, )
                    ],
                frontend_directory = '',
                image_pusher = 'None',
        )
        """

    def testJfjochSettings(self):
        """Test JfjochSettings"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
