# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConfigResult',
    'AwaitableGetConfigResult',
    'get_config',
    'get_config_output',
]

@pulumi.output_type
class GetConfigResult:
    """
    A collection of values returned by getConfig.
    """
    def __init__(__self__, base64_encode=None, boundary=None, gzip=None, id=None, parts=None, rendered=None):
        if base64_encode and not isinstance(base64_encode, bool):
            raise TypeError("Expected argument 'base64_encode' to be a bool")
        pulumi.set(__self__, "base64_encode", base64_encode)
        if boundary and not isinstance(boundary, str):
            raise TypeError("Expected argument 'boundary' to be a str")
        pulumi.set(__self__, "boundary", boundary)
        if gzip and not isinstance(gzip, bool):
            raise TypeError("Expected argument 'gzip' to be a bool")
        pulumi.set(__self__, "gzip", gzip)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parts and not isinstance(parts, list):
            raise TypeError("Expected argument 'parts' to be a list")
        pulumi.set(__self__, "parts", parts)
        if rendered and not isinstance(rendered, str):
            raise TypeError("Expected argument 'rendered' to be a str")
        pulumi.set(__self__, "rendered", rendered)

    @_builtins.property
    @pulumi.getter(name="base64Encode")
    def base64_encode(self) -> _builtins.bool:
        """
        Specify whether or not to base64 encode the `rendered` output. Defaults to `true`, and cannot be disabled if gzip is `true`.
        """
        return pulumi.get(self, "base64_encode")

    @_builtins.property
    @pulumi.getter
    def boundary(self) -> _builtins.str:
        """
        Specify the Writer's default boundary separator. Defaults to `MIMEBOUNDARY`.
        """
        return pulumi.get(self, "boundary")

    @_builtins.property
    @pulumi.getter
    def gzip(self) -> _builtins.bool:
        """
        Specify whether or not to gzip the `rendered` output. Defaults to `true`.
        """
        return pulumi.get(self, "gzip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        [CRC-32](https://pkg.go.dev/hash/crc32) checksum of `rendered` cloud-init config.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def parts(self) -> Optional[Sequence['outputs.GetConfigPartResult']]:
        """
        A nested block type which adds a file to the generated cloud-init configuration. Use multiple `part` blocks to specify multiple files, which will be included in order of declaration in the final MIME document.
        """
        return pulumi.get(self, "parts")

    @_builtins.property
    @pulumi.getter
    def rendered(self) -> _builtins.str:
        """
        The final rendered multi-part cloud-init config.
        """
        return pulumi.get(self, "rendered")


class AwaitableGetConfigResult(GetConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigResult(
            base64_encode=self.base64_encode,
            boundary=self.boundary,
            gzip=self.gzip,
            id=self.id,
            parts=self.parts,
            rendered=self.rendered)


def get_config(base64_encode: Optional[_builtins.bool] = None,
               boundary: Optional[_builtins.str] = None,
               gzip: Optional[_builtins.bool] = None,
               parts: Optional[Sequence[Union['GetConfigPartArgs', 'GetConfigPartArgsDict']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigResult:
    """
    Renders a [multi-part MIME configuration](https://cloudinit.readthedocs.io/en/latest/explanation/format.html#mime-multi-part-archive) for use with [cloud-init](https://cloudinit.readthedocs.io/en/latest/).

    Cloud-init is a commonly-used startup configuration utility for cloud compute instances. It accepts configuration via provider-specific user data mechanisms, such as `user_data` for Amazon EC2 instances. Multi-part MIME is one of the data formats it accepts. For more information, see [User-Data Formats](https://cloudinit.readthedocs.io/en/latest/explanation/format.html) in the cloud-init manual.

    This is not a generalized utility for producing multi-part MIME messages. Its feature set is specialized for cloud-init multi-part MIME messages.

    ## Example Usage

    ### Config

    ### hello-script.sh

    ### cloud-config.yaml

    <!-- This schema was originally generated with tfplugindocs, then modified manually to ensure `part` block list is noted as Required -->


    :param _builtins.bool base64_encode: Specify whether or not to base64 encode the `rendered` output. Defaults to `true`, and cannot be disabled if gzip is `true`.
    :param _builtins.str boundary: Specify the Writer's default boundary separator. Defaults to `MIMEBOUNDARY`.
    :param _builtins.bool gzip: Specify whether or not to gzip the `rendered` output. Defaults to `true`.
    :param Sequence[Union['GetConfigPartArgs', 'GetConfigPartArgsDict']] parts: A nested block type which adds a file to the generated cloud-init configuration. Use multiple `part` blocks to specify multiple files, which will be included in order of declaration in the final MIME document.
    """
    __args__ = dict()
    __args__['base64Encode'] = base64_encode
    __args__['boundary'] = boundary
    __args__['gzip'] = gzip
    __args__['parts'] = parts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudinit:index/getConfig:getConfig', __args__, opts=opts, typ=GetConfigResult).value

    return AwaitableGetConfigResult(
        base64_encode=pulumi.get(__ret__, 'base64_encode'),
        boundary=pulumi.get(__ret__, 'boundary'),
        gzip=pulumi.get(__ret__, 'gzip'),
        id=pulumi.get(__ret__, 'id'),
        parts=pulumi.get(__ret__, 'parts'),
        rendered=pulumi.get(__ret__, 'rendered'))
def get_config_output(base64_encode: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      boundary: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      gzip: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      parts: Optional[pulumi.Input[Optional[Sequence[Union['GetConfigPartArgs', 'GetConfigPartArgsDict']]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigResult]:
    """
    Renders a [multi-part MIME configuration](https://cloudinit.readthedocs.io/en/latest/explanation/format.html#mime-multi-part-archive) for use with [cloud-init](https://cloudinit.readthedocs.io/en/latest/).

    Cloud-init is a commonly-used startup configuration utility for cloud compute instances. It accepts configuration via provider-specific user data mechanisms, such as `user_data` for Amazon EC2 instances. Multi-part MIME is one of the data formats it accepts. For more information, see [User-Data Formats](https://cloudinit.readthedocs.io/en/latest/explanation/format.html) in the cloud-init manual.

    This is not a generalized utility for producing multi-part MIME messages. Its feature set is specialized for cloud-init multi-part MIME messages.

    ## Example Usage

    ### Config

    ### hello-script.sh

    ### cloud-config.yaml

    <!-- This schema was originally generated with tfplugindocs, then modified manually to ensure `part` block list is noted as Required -->


    :param _builtins.bool base64_encode: Specify whether or not to base64 encode the `rendered` output. Defaults to `true`, and cannot be disabled if gzip is `true`.
    :param _builtins.str boundary: Specify the Writer's default boundary separator. Defaults to `MIMEBOUNDARY`.
    :param _builtins.bool gzip: Specify whether or not to gzip the `rendered` output. Defaults to `true`.
    :param Sequence[Union['GetConfigPartArgs', 'GetConfigPartArgsDict']] parts: A nested block type which adds a file to the generated cloud-init configuration. Use multiple `part` blocks to specify multiple files, which will be included in order of declaration in the final MIME document.
    """
    __args__ = dict()
    __args__['base64Encode'] = base64_encode
    __args__['boundary'] = boundary
    __args__['gzip'] = gzip
    __args__['parts'] = parts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudinit:index/getConfig:getConfig', __args__, opts=opts, typ=GetConfigResult)
    return __ret__.apply(lambda __response__: GetConfigResult(
        base64_encode=pulumi.get(__response__, 'base64_encode'),
        boundary=pulumi.get(__response__, 'boundary'),
        gzip=pulumi.get(__response__, 'gzip'),
        id=pulumi.get(__response__, 'id'),
        parts=pulumi.get(__response__, 'parts'),
        rendered=pulumi.get(__response__, 'rendered')))
