#################################################################################
# Eclipse Tractus-X - Software Development KIT
#
# Copyright (c) 2025 Contributors to the Eclipse Foundation
#
# See the NOTICE file(s) distributed with this work for additional
# information regarding copyright ownership.
#
# This program and the accompanying materials are made available under the
# terms of the Apache License, Version 2.0 which is available at
# https://www.apache.org/licenses/LICENSE-2.0.
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the
# License for the specific language govern in permissions and limitations
# under the License.
#
# SPDX-License-Identifier: Apache-2.0
#################################################################################

# Part of this content was generated by Co-Pilot and reviewed by a human developer.

from typing import List, TypeVar, Generic
from enum import Enum
from pydantic import Field
from tractusx_sdk.industry.models.aas import (
    BaseAbstractModel,
    AbstractShellDescriptor,
    AbstractSubModelDescriptor,
)

# Defined Generic types for each Abstract class
# By bounding the Generic types to the specific class
# , we can ensure that it only accepts implementations of the abstract classes
# these implementations are the AAS version specific classes
TSubModelDesc = TypeVar("TSubModelDesc", bound="AbstractSubModelDescriptor")
TPagingMetadata = TypeVar("TPagingMetadata", bound="AbstractPagingMetadata")
TShellDescriptor = TypeVar("TShellDescriptor", bound="AbstractShellDescriptor")
TMessage = TypeVar("TMessage", bound="AbstractMessage")


class MessageTypeEnum(str, Enum):
    """Enum for message types."""

    UNDEFINED = "Undefined"
    INFO = "Info"
    WARNING = "Warning"
    ERROR = "Error"
    EXCEPTION = "Exception"


class ProfileEnum(str, Enum):
    ASSETADMINISTRATIONSHELLSERVICESPECIFICATION_SSP_001 = "https://admin-shell.io/aas/API/3/0/AssetAdministrationShellServiceSpecification/SSP-001"
    ASSETADMINISTRATIONSHELLSERVICESPECIFICATION_SSP_002 = "https://admin-shell.io/aas/API/3/0/AssetAdministrationShellServiceSpecification/SSP-002"
    SUBMODELSERVICESPECIFICATION_SSP_001 = (
        "https://admin-shell.io/aas/API/3/0/SubmodelServiceSpecification/SSP-001"
    )
    SUBMODELSERVICESPECIFICATION_SSP_002 = (
        "https://admin-shell.io/aas/API/3/0/SubmodelServiceSpecification/SSP-002"
    )
    SUBMODELSERVICESPECIFICATION_SSP_003 = (
        "https://admin-shell.io/aas/API/3/0/SubmodelServiceSpecification/SSP-003"
    )
    AASXFILESERVICESPECIFICATION_SSP_001 = (
        "https://admin-shell.io/aas/API/3/0/AasxFileServerServiceSpecification/SSP-001"
    )
    ASSETADMINISTRATIONSHELLREGISTRYSERVICESPECIFICATION_SSP_001 = "https://admin-shell.io/aas/API/3/0/AssetAdministrationShellRegistryServiceSpecification/SSP-001"
    ASSETADMINISTRATIONSHELLREGISTRYSERVICESPECIFICATION_SSP_002 = "https://admin-shell.io/aas/API/3/0/AssetAdministrationShellRegistryServiceSpecification/SSP-002"
    SUBMODELREGISTRYSERVICESPECIFICATION_SSP_001 = "https://admin-shell.io/aas/API/3/0/SubmodelRegistryServiceSpecification/SSP-001"
    SUBMODELREGISTRYSERVICESPECIFICATION_SSP_002 = "https://admin-shell.io/aas/API/3/0/SubmodelRegistryServiceSpecification/SSP-002"
    DISCOVERYSERVICESPECIFICATION_SSP_001 = (
        "https://admin-shell.io/aas/API/3/0/DiscoveryServiceSpecification/SSP-001"
    )
    ASSETADMINISTRATIONSHELLREPOSITORYSERVICESPECIFICATION_SSP_001 = "https://admin-shell.io/aas/API/3/0/AssetAdministrationShellRepositoryServiceSpecification/SSP-001"
    ASSETADMINISTRATIONSHELLREPOSITORYSERVICESPECIFICATION_SSP_002 = "https://admin-shell.io/aas/API/3/0/AssetAdministrationShellRepositoryServiceSpecification/SSP-002"
    SUBMODELREPOSITORYSERVICESPECIFICATION_SSP_001 = "https://admin-shell.io/aas/API/3/0/SubmodelRepositoryServiceSpecification/SSP-001"
    SUBMODELREPOSITORYSERVICESPECIFICATION_SSP_002 = "https://admin-shell.io/aas/API/3/0/SubmodelRepositoryServiceSpecification/SSP-002"
    SUBMODELREPOSITORYSERVICESPECIFICATION_SSP_003 = "https://admin-shell.io/aas/API/3/0/SubmodelRepositoryServiceSpecification/SSP-003"
    SUBMODELREPOSITORYSERVICESPECIFICATION_SSP_004 = "https://admin-shell.io/aas/API/3/0/SubmodelRepositoryServiceSpecification/SSP-004"
    CONCEPTDESCRIPTIONSERVICESPECIFICATION_SSP_001 = "https://admin-shell.io/aas/API/3/0/ConceptDescriptionServiceSpecification/SSP-001"


class AbstractServiceDescription(BaseAbstractModel):
    """
    The Description object enables servers to present their capabilities to the clients, in particular which profiles they implement.
    """

    profiles: List[ProfileEnum] | None = Field(None)


class AbstractPagingMetadata(BaseAbstractModel):
    """
    Abstract class for paging metadata for responses.
    This class should not be used directly. Instead, use a version-specific implementation.
    Supported versions extend this class with modifications specific to that API version.
    Extending classes can add additional version-specific configuration.
    """

    cursor: str | None = Field(None)


class AbstractPaginatedResponse(BaseAbstractModel, Generic[TPagingMetadata]):
    """
    Abstract base class for paginated responses.
    This class should not be used directly. Instead, use a version-specific implementation.
    Supported versions extend this class with modifications specific to that API version.
    Extending classes can add additional version-specific configuration.
    """

    paging_metadata: TPagingMetadata | None = Field(None)


class AbstractGetAllShellDescriptorsResponse(
    AbstractPaginatedResponse[TPagingMetadata],
    Generic[TPagingMetadata, TShellDescriptor],
):
    """
    Abstract response model for the get_all_shell_descriptors method.
    This class should not be used directly. Instead, use a version-specific implementation.
    Supported versions extend this class with modifications specific to that API version.
    Extending classes can add additional version-specific configuration.
    """

    result: List[TShellDescriptor]


class AbstractGetSubmodelDescriptorsByAssResponse(
    AbstractPaginatedResponse[TPagingMetadata], Generic[TPagingMetadata, TSubModelDesc]
):
    """
    Abstract response model for the get_submodel_descriptors method.
    This class should not be used directly. Instead, use a version-specific implementation.
    Supported versions extend this class with modifications specific to that API version.
    Extending classes can add additional version-specific configuration.
    """

    result: List[TSubModelDesc]


class AbstractMessage(BaseAbstractModel):
    """
    Abstract class for message in a not 2XX response.
    This class should not be used directly. Instead, use a version-specific implementation.
    Supported versions extend this class with modifications specific to that API version.
    Extending classes can add additional version-specific configuration.
    """

    code: str | None = Field(None)
    correlationId: str | None = Field(None)
    messageType: MessageTypeEnum | None = Field(None)
    text: str | None = Field(None)
    timestamp: str | None = Field(None)


class AbstractResult(BaseAbstractModel, Generic[TMessage]):
    """
    Abstract class for result in a not 2XX response.
    This class should not be used directly. Instead, use a version-specific implementation.
    Supported versions extend this class with modifications specific to that API version.
    Extending classes can add additional version-specific configuration.
    """

    messages: List[TMessage] | None = Field(None)
