import route53 = require('@aws-cdk/aws-route53');
import cdk = require('@aws-cdk/core');
import { CertificateProps, ICertificate } from './certificate';
/**
 * @experimental
 */
export interface DnsValidatedCertificateProps extends CertificateProps {
    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.  The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     */
    readonly hostedZone: route53.IHostedZone;
    /**
     * AWS region that will host the certificate. This is needed especially
     * for certificates used for CloudFront distributions, which require the region
     * to be us-east-1.
     *
     * @default the region the stack is deployed in.
     */
    readonly region?: string;
}
/**
 * A certificate managed by AWS Certificate Manager.  Will be automatically
 * validated using DNS validation against the specified Route 53 hosted zone.
 *
 * @resource AWS::CertificateManager::Certificate
 * @experimental
 */
export declare class DnsValidatedCertificate extends cdk.Resource implements ICertificate {
    readonly certificateArn: string;
    private normalizedZoneName;
    private hostedZoneId;
    private domainName;
    constructor(scope: cdk.Construct, id: string, props: DnsValidatedCertificateProps);
    protected validate(): string[];
}
