"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const publicSuffixes = require("./public-suffixes");
/**
 * Returns the apex domain (domain.com) from a subdomain (www.sub.domain.com)
 */
function apexDomain(domainName) {
    const parts = domainName.split('.').reverse();
    let curr = publicSuffixes;
    const accumulated = [];
    for (const part of parts) {
        accumulated.push(part);
        if (!(part in curr)) {
            break;
        }
        curr = curr[part];
    }
    return accumulated.reverse().join('.');
}
exports.apexDomain = apexDomain;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxvREFBcUQ7QUFFckQ7O0dBRUc7QUFDSCxTQUFnQixVQUFVLENBQUMsVUFBa0I7SUFDM0MsTUFBTSxLQUFLLEdBQUcsVUFBVSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUU5QyxJQUFJLElBQUksR0FBUSxjQUFjLENBQUM7SUFFL0IsTUFBTSxXQUFXLEdBQWEsRUFBRSxDQUFDO0lBQ2pDLEtBQUssTUFBTSxJQUFJLElBQUksS0FBSyxFQUFFO1FBQ3hCLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDdkIsSUFBSSxDQUFDLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxFQUFFO1lBQUUsTUFBTTtTQUFFO1FBQy9CLElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDbkI7SUFDRCxPQUFPLFdBQVcsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDekMsQ0FBQztBQVpELGdDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHB1YmxpY1N1ZmZpeGVzID0gcmVxdWlyZSgnLi9wdWJsaWMtc3VmZml4ZXMnKTtcblxuLyoqXG4gKiBSZXR1cm5zIHRoZSBhcGV4IGRvbWFpbiAoZG9tYWluLmNvbSkgZnJvbSBhIHN1YmRvbWFpbiAod3d3LnN1Yi5kb21haW4uY29tKVxuICovXG5leHBvcnQgZnVuY3Rpb24gYXBleERvbWFpbihkb21haW5OYW1lOiBzdHJpbmcpOiBzdHJpbmcge1xuICBjb25zdCBwYXJ0cyA9IGRvbWFpbk5hbWUuc3BsaXQoJy4nKS5yZXZlcnNlKCk7XG5cbiAgbGV0IGN1cnI6IGFueSA9IHB1YmxpY1N1ZmZpeGVzO1xuXG4gIGNvbnN0IGFjY3VtdWxhdGVkOiBzdHJpbmdbXSA9IFtdO1xuICBmb3IgKGNvbnN0IHBhcnQgb2YgcGFydHMpIHtcbiAgICBhY2N1bXVsYXRlZC5wdXNoKHBhcnQpO1xuICAgIGlmICghKHBhcnQgaW4gY3VycikpIHsgYnJlYWs7IH1cbiAgICBjdXJyID0gY3VycltwYXJ0XTtcbiAgfVxuICByZXR1cm4gYWNjdW11bGF0ZWQucmV2ZXJzZSgpLmpvaW4oJy4nKTtcbn1cbiJdfQ==